#include "dos/dpmi.bi"
#include "dos/dos.bi"
#include "dos/sys/movedata.bi"

' This file has no copyright assigned and is placed in the Public Domain

dim dos_transfer_buffer as string*2048
'put URB at offset 0 of dos_transfer_buffer
'put device_request at offset 33 of dos_transfer_buffer
'put i/o buffer at offset 41 of dos_transfer_buffer

Dim dos_seg As Integer, dos_sel As Integer
       
Dim regs As __dpmi_regs

dos_seg = __dpmi_allocate_dos_memory((Len(dos_transfer_buffer) + 15) \ 16, @dos_sel)
If dos_seg = 0 Then end ' out of memory    

devadd%=1

'define structure of URB
type urbtype field=1
  transaction_token as ubyte 'control (2Dh), in (69h), out (E1h) as hex code
  chain_end_flag  as ubyte
  dev_add         as ubyte
  end_point       as ubyte
  error_code      as ubyte
  status          as ubyte  'returned by dosuhci
  transaction_flags as ushort 'reserved
  buffer_off      as ushort  'for in/out
  buffer_seg      as ushort  'for in/out
  buffer_length   as ushort  'for in/out
  actual_length   as ushort  'for in/out
  setup_buffer_off as ushort 'for control
  setup_buffer_seg as ushort 'for control
  start_frame     as ushort  'reserved
  nr_of_packets   as ushort  'reserved - iso
  int_interval    as ubyte  'reserved - int
  error_count     as ubyte  'reserved
  timeout         as ushort  'reserved
  next_urb_off    as ushort  'reserved
  next_urb_seg    as ushort  'reserved
end type '32 byte long

dim urb as urbtype

type setuptype field=1
   bmRequestType  as ubyte
   bRequest	  as ubyte
   wValue	  as ushort
   wIndex         as ushort
   wLength        as ushort
end type

dim device_request as setuptype

type device_descriptor_type field=1
   dummy                as string*40   'input starts at position 41
   bLength              as ubyte       'in dos_transfer_buffer
   bDescriptorType	as ubyte
   bcdUSB		as ushort
   bDeviceClass		as ubyte
   bDeviceSubClass	as ubyte
   bDeviceProtocol	as ubyte
   bMaxPacketSize	as ubyte
   idVendor		as ushort
   idProduct		as ushort
   bcdDevice		as ushort
   iManufacturer	as ubyte
   iProduct		as ubyte
   iSerialNumber	as ubyte
   bNumConfigurations	as ubyte
end type

Dim As device_descriptor_type Ptr device_descriptor_ptr = CPtr(device_descriptor_type Ptr, @dos_transfer_buffer)

'request full device descriptor
device_request.bmRequestType=&H80
device_request.bRequest=6
device_request.wValue=&H0100
device_request.wIndex=0
device_request.wLength=&H12 '18 'hex 12

'set up device descriptor request
  urb.transaction_token=&H2D
  urb.chain_end_flag=0
  urb.dev_add=devadd%
  urb.end_point=0
  urb.error_code=0
  urb.status=0
  urb.transaction_flags=0
  urb.buffer_seg=dos_seg
  urb.buffer_off=41
  urb.buffer_length=18
  urb.actual_length=64
  urb.setup_buffer_seg=dos_seg
  urb.setup_buffer_off=33
  urb.start_frame=0
  urb.nr_of_packets=0
  urb.int_interval=0
  urb.error_count=0
  urb.timeout=0
  urb.next_urb_seg=0
  urb.next_urb_off=0

'now call Dosusb
  GoSub call_dosusb

'invalid device address?
if urb.error_code=1 then
        cls : locate 14,23
	print "Invalid device address"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if

'transaction error?
if urb.status >1 then
        cls : locate 14,23
	print "Device does not respond"
        locate 24,23
        input "Press enter to continue", a$
        goto do_end
end if

cls
print
print "Device Descriptor:"
print "Length:                ";device_descriptor_ptr->bLength
print "Descriptor type:       ";device_descriptor_ptr->bDescriptorType
print "USB specification nr.: ";device_descriptor_ptr->bcdUSB
print "Class code:            ";device_descriptor_ptr->bDeviceClass;
if device_descriptor_ptr->bDeviceClass=0 then
 print " Class code specified by interface"
elseif device_descriptor_ptr->bDeviceClass=1 then
 print " Audio device"
elseif device_descriptor_ptr->bDeviceClass=2 then
 print " Modem device"
elseif device_descriptor_ptr->bDeviceClass=3 then
 print " Human interface device - mouse, keyboard, etc."
elseif device_descriptor_ptr->bDeviceClass=6 then
 print " Scanner / imaging device"
elseif device_descriptor_ptr->bDeviceClass=7 then
 print " Printer"
elseif device_descriptor_ptr->bDeviceClass=8 then
 print " Mass storage device"
elseif device_descriptor_ptr->bDeviceClass=9 then
 print " Hub"
elseif device_descriptor_ptr->bDeviceClass=&H0B then
 print " Chip/smart card interface device"
elseif device_descriptor_ptr->bDeviceClass=&H0E then
 print " Video device"
elseif device_descriptor_ptr->bDeviceClass=&HE0 then
 print " Bluetooth"
elseif device_descriptor_ptr->bDeviceClass=255 then
 print " Vendor specified class code"
else
 print
end if
print "Subclass code:         ";device_descriptor_ptr->bDeviceSubClass
print "Protocol code:         ";device_descriptor_ptr->bDeviceProtocol
print "Max Packet size:       ";device_descriptor_ptr->bMaxPacketSize
print "Vendor ID:             ";device_descriptor_ptr->idVendor
print "Product ID:            ";device_descriptor_ptr->idProduct
print "Device release nr.:    ";device_descriptor_ptr->bcdDevice
print "Index of manufacturer: ";device_descriptor_ptr->iManufacturer
print "Index of product:      ";device_descriptor_ptr->iProduct
print "Index of serial nr.:   ";device_descriptor_ptr->iSerialNumber
print "Nr. of configurations: ";device_descriptor_ptr->bNumConfigurations


__dpmi_free_dos_memory(dos_sel)

do_end:
        
End

Call_dosusb:

        dosmemput(varptr(urb), 32, dos_seg * 16)
        dosmemput(varptr(device_request), Len(device_request), dos_seg * 16 + 33)

        regs.x.ax = &H00
        regs.x.dx = 0
        regs.x.ds = dos_seg
        __dpmi_int(&H65, @regs)

        dosmemget(dos_seg * 16, Len(dos_transfer_buffer), Strptr(dos_transfer_buffer))

Return
