; This file has no copyright assigned and is placed in the Public Domain
; This public domain tool sends a "restart" command packet to DOSUSB
; Compile with: nasm -o restart.com restart.asm

	org 0x100	; .com program
	mov ax,ds	; adjust seg in control transaction URB
	mov [buffer_seg],ax
	mov [setup_buf_seg],ax
	push es
	mov ax,0x3565	; check if any int 65 handler present
	int 0x21
	mov ax,es
	or ax,bx	; ax not null if es, bx or both not null
	pop es
	or ax,ax
	jz no_dosusb	; null pointer? then do not call int 65
	mov ax,8
	mov dx,urb	; offset
	int 0x65	; call DOSUHCI / DOSUSB
	mov dx,restart_msg	; offset
	mov ah,9	; show string
	int 0x21
	mov ax,0x4c00	; terminate program, errorlevel 0
	int 0x21

no_dosusb:
	mov dx,no_message	; offset
	mov ah,9	; show string
	int 0x21
	mov ax,0x4c01	; terminate program, errorlevel 1
	int 0x21

restart_msg	db "DOSUSB restarted",13,10,"$"
no_message	db "DOSUSB not found",13,10,"$"

urb:	; URB structure follows, 32 bytes
transact_token	db 0xff ;control, in, out 
chain_end_flag	db 0  
dev_add 	db 1
end_point	db 0
error_code	db 0  ; error codes returned by dosuhci
status  	db 0  ; status byte returned by controller
transact_flags	dw 0  ; reserved
buffer_off	dw 0  ; for in/out
buffer_seg	dw -1 ; for in/out (set by code)
buffer_length	dw 8  ; for in/out ; 12h (?)
actual_length	dw 8  ; for in/out
setup_buf_off	dw 0  ; for control
setup_buf_seg	dw -1 ; for control (set by code)
start_frame	dw 0  ; reserved 
nr_of_packets	dw 0  ; iso
int_interval	db 0  ; int
error_count	db 0  ; reserved 
timeout 	dw 0  ; reserved
next_urb_off	dw 0  ; reserved
next_urb_seg	dw 0  ; reserved
	; end of URB structure
