; This file has no copyright assigned and is placed in the Public Domain
; Compiled with TASM : tasm enum -> tlink enum /t -> enum.com
;
.MODEL TINY
.CODE
ORG 100h
START:               

;set up URB for control transaction
mov urb.transaction_token,2Dh
mov urb.chain_end_flag,0
mov urb.dev_add,1
mov urb.end_point,00h
mov urb.error_code,0
mov urb.status,0
mov urb.transaction_flags,0
mov ax,offset in_buffer
mov urb.buffer_off,ax
push ds
pop urb.buffer_seg
mov urb.actual_length,8
mov urb.buffer_length,8 ;12h
mov ax,offset get_dev_dis
mov urb.setup_buffer_off,ax
push ds
pop urb.setup_buffer_seg
mov urb.start_frame,0
mov urb.nr_of_packets,0
mov urb.int_interval,0
mov urb.error_count,0
mov urb.timeout,0
mov urb.next_urb_off,0
mov urb.next_urb_seg,0

;now call DosUHCI
mov dx,offset urb
int 65h

;output received data to screen
mov  cx,9
mov  di,0
buffer_out_loop:
        mov  ah,02            
        mov  dl,in_buffer[di] 
        push cx
        push di
        int  21h
        pop di
        pop cx
        inc di
loop buffer_out_loop

;terminate program
mov ax,4C00h
int 21h

;data

in_buffer    db 8 dup(0)    

;get_device_descriptor
get_dev_dis  db  80h,06h 
             dw  0100h,0000h,0008h

;define data type of URB
urbstruc struc
  transaction_token db ? ;control, in, out 
  chain_end_flag  db ?  
  dev_add         db ?
  end_point       db ?
  error_code      db ?  ;error codes returned by dosuhci
  status          db ?  ;status byte returned by controller
  transaction_flags dw ?  ;reserved
  buffer_off      dw ?  ;for in/out
  buffer_seg      dw ?  ;for in/out
  buffer_length   dw ?  ;for in/out
  actual_length   dw ?  ;for in/out
  setup_buffer_off dw ? ;for control
  setup_buffer_seg dw ? ;for control
  start_frame     dw ?  ;reserved 
  nr_of_packets   dw ?  ;iso
  int_interval    db ?  ;int
  error_count     db ?  ;reserved 
  timeout         dw ?  ;reserved
  next_urb_off    dw ?  ;reserved
  next_urb_seg    dw ?  ;reserved
urbstruc ends ;32 byte long 

;define urb with this type
urb     urbstruc <> 

END  START
