--
-- luaConvert.lua - This converts *.cxx files generated by FLUID to murgaLua
--                  See murgaLua tutorials for usage examples.
--
-- Copyright (C) 2007 Markku Kotiaho
--
-- Modified by John Murga
-- Incorporated changes from Tobias Opfermann
-- 
-- Based on convertFluidToMurga.sh -- (C) 2006 John Murga
-- 
-- This program is free software; you can redistribute it and/or
-- modify it under the terms of the GNU General Public License
-- as published by the Free Software Foundation; either version 2
-- of the License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the :
-- 
--   Free Software Foundation, Inc.
--   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
--

if (not arg[1]) then
   print("\n" ..
         "luaConvert.lua usage:\n" ..
	 "  murgaLua luaConvert.lua <FLUID GENERATED FILE>.cxx > <murgaLua File>.lua")
   return
end

function split(Line) 
   R = {}
   if (string.len(Line) < 1) then
      return R
   end
   for w in string.gmatch(Line, "%S+") do --iterate over all non-space sequences in Line
      table.insert(R,w)
   end
   return R
end

Marker     = -2
PrefixFlag =  0

for line in io.lines(arg[1]) do

   currentLine = string.gsub(line,"\n$", "") --get rid of newline

   Fld = split(currentLine)

   -- Ignore everything before the main function
   if (Fld[2] == 'make_window()' or Marker > -2) then
      Marker = Marker + 1
   end

   -- This is the part of the file we are interested in
   if (Marker > 0) then

      -- Make sure that we have not come to end of the window definition
      if string.find(currentLine,'o->end()') then
         -- Append some code that will allow for the murgaLua file to be
         -- run directly (with no behaviour).
         print("  end")
         print("  window:show();")
         print("  Fl:run();")
         break
      end

      -- If there is a "\" at the end of line it is a continuation    
      where,ending = string.find(currentLine, '\\$') 
      if (where and where > 1) then
         PrefixFlag = 1
      else
         -- If this flag was set it means this is a string continuation line
         if (PrefixFlag == 1) then
            currentLine = "\"" .. currentLine
         end
         PrefixFlag = 0
      end

      -- Replace the continuation with a LUA string concatenation
      -- (I am assuming that FLUID only wraps long strings)
      currentLine = string.gsub(currentLine, '\\$', "\" .. ")

      -- Do some basic replacements in code (definitions/boundaries)
      currentLine = string.gsub(currentLine, 'Fl_.* o = new ', "local object = fltk:")
      currentLine = string.gsub(currentLine, 'new Fl_', "fltk:Fl_")
      currentLine = string.gsub(currentLine, '\{', "do")
      currentLine = string.gsub(currentLine, '\}', "end")

      -- Convert object notation
      currentLine = string.gsub(currentLine, 'o%->', "object:")
      
      -- Convert object notation of named objects
      currentLine = string.gsub(currentLine, '%w+%->', "%1:")
      currentLine = string.gsub(currentLine, '->:', ":")
      -- handle special case where custom object name ends with o
      -- (all o's get replaced with object, so need that in the constructor as well)
      currentLine = string.gsub(currentLine, "o = fltk:Fl_", "object = fltk:Fl_")

      -- Logical ORs can be replaced with arithmetic ADDs
      currentLine = string.gsub(currentLine, '\|FL_', "+FL_")
      -- Convert the namespace to the used in murgaLua
      currentLine = string.gsub(currentLine, 'FL_', "fltk.FL_")

      -- Remove casts as they are not required in LUA
      currentLine = string.gsub(currentLine, "%(Fl_%w*%*%)", "")
      
      -- Replace C++ comments with Lua ones
      currentLine = string.gsub(currentLine, '//', "--")
    
      -- Change the initial window declaration
      currentLine = string.gsub(currentLine, 'w = o', "window = object")

      -- Output the converted line
      print(currentLine)

   end
   
end

