if not fltk.Fl_Pixmap then
fltk.fl_alert("This widget requires\nmurgaLua 0.6 or later")
os.exit(1)
end

w=fltk:Fl_Double_Window(500,400,"image-xpm3.lua")
xpm_box=fltk:Fl_Box(30,20,100,300)
xpm_box_label=fltk:Fl_Box(130,20,300,300)
xpm_box_label:align(fltk.FL_ALIGN_WRAP)

xpm_box_label:label("The image data used by Fl_Pixmap() is read directly from a table in the script.")

xpm_file={
"48 48 16 1",
"0      c #1C1918",
"1      c #6A0903",
"2      c #420015",
"3      c #474267",
"4      c #5E5F57",
"5      c #79698C",
"6      c #795E97",
"7      c #646DA7",
"8      c #ADA2C8",
"9      c #80B0DB",
"A      c #98D4F5",
"B      c #989A96",
"C      c #BBBDBA",
"D      c #CDCFCC",
"E      c #F4F7F3",
"       c None",
"               00000306                         ",
"            337AAAAAA973773                     ",
"          33A9AAA9666AAAA932000                 ",
"         099AAA9544BB45A64DEEEEB0               ",
"       00999A993BDEEEEB34DDEEEEEB0              ",
"      093999993BDDEEEEEC4DDEC4BEE4              ",
"     099799993BDDEEEEEEE4BDD44CEEC0             ",
"    0999999964DDDEED44EED4DC0404ED0             ",
"   0999999993BDDDEE444DDE4CB0000ED0             ",
"   0999999994CDDDED04004ED4C0004DC0             ",
"  09999999994CDDDEB00004ED4DB44DD40             ",
"  09999999994BCDDDC00004ED4CCCDC4560            ",
" 099999999994BCCDDD0000BDC2444439AA92           ",
" 0999999999954BCCDDB004CD46A9AAAAAAA90          ",
" 0999999999994BBBCDCCCDDB29AAAAAAAAAA6000       ",
"099999999999964BBBBBCCCB29AAAAAAAAAAAA53730     ",
"099999999999996344BBB4439AAAAAAAAAAAAAA28830    ",
"09999999999999999656569AAAAAAAAAAAAAAA638882    ",
"09999999999999999A99A9AAAAAAAAAAAAAAA5388883    ",
"095369999999999999A99AAAAAAAAAAAAAA636888882    ",
"093999999999999999AAAAAAAAAAAAAAA62378888830    ",
"0659339999999999999AA99AAAAA99333688888872B4    ",
"0999222359999999A99A9A9965533677888888734BBD0   ",
"099950236323566666333336677888888888734B4EBC4   ",
"09999211067866666788888888888888873444EECBE40   ",
"0999922111237788888888888887776220BEED4EEBD4    ",
"09999531111CB4236777876633220BB411DEEED4EE44    ",
"0999992311BEEBCDB44BB40BDE41BEEEB0DEEEECBE44    ",
"0999995331BEE4EEE4EEEBBEEED0DEEEEBDEEEEEBBBD0   ",
"09999992604BB4EEDBEEE4DEEEE4EEEEEDBEEEEECB4C0   ",
"09999996371104EECDEEE4EEEEE4EEEEEEBEEEEEBDB40   ",
"099999996660CB4B4BEEE4EEEEE4EEEEEEBBDDC44ED000  ",
"099999999573BD444BEEE4EEEEEBDEEEEC4BBBCEBDD2720 ",
"09999999993734BED44444BDDDD444BB444DEEEECCE0682 ",
"09999999999372BEBDEBBDB44444DDDDEEDBEEEEDBB07870",
" 09999999999372CBDEBDEE4EEEBDEEEEECBEEEED0028870",
" 0999999999A63830BEBDEE4EEEBDEEEEEB4EEEEB0388882",
" 099999999A9A63732D4BEE4EEED4EEEEE414DDB37888870",
" 09999999999AA9687200EEBBEEE4DEEEC11103788888870",
" 3099999AAAAAAA9578624B40DEE04EED00278888888882 ",
"  0399AA99AAA9AA9578762114B41144377888888888830 ",
"    36AA9AAAAAAAAA378887666667788888888888872   ",
"     359AAAAAAAAAAA6378888888888888888888720    ",
"      3269AAAAAAAAAA9536788888888888877320      ",
"         259AAAAAAAAAA62023667778776320         ",
"           0056666532000   000000000            ",
"                                                ",
"                                                "
}







xpm_data=fltk:Fl_Pixmap(xpm_file)
xpm_copy=xpm_data:copy() -- make a copy for deimage
xpm_copy:inactive() -- fade the copy
xpm_box:image(xpm_data) -- apply the original to activated state
xpm_box:deimage(xpm_copy) -- apply the copy to deactivated state
deimage_button=fltk:Fl_Toggle_Button(130,240,300,30,"toggle deimage")
deimage_button:callback(function(deimg_cb)
if deimage_button:value() == 1 then
	xpm_box:deactivate()
else
	xpm_box:activate()
end
xpm_box:redraw()
end
)
xpm_box:tooltip("my_image:count() = "..xpm_data:count())
w:show()
Fl:run()
