/*
 * Decompiled with CFR 0.152.
 */
package org.capybara.artnetforprocessing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.capybara.artnetforprocessing.AbstractPixelRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Universe {
    private List<AbstractPixelRange> pixelRanges = new ArrayList<AbstractPixelRange>();
    private int subnet;
    private int universe;
    private final Logger log = LoggerFactory.getLogger(Universe.class);

    public Universe(int subnet, int universe) {
        this.subnet = subnet;
        this.universe = universe;
    }

    public void addPixelRange(AbstractPixelRange pr) {
        this.pixelRanges.add(pr);
        this.log.debug(pr.toString());
    }

    public List<AbstractPixelRange> getPixelRanges() {
        return Collections.unmodifiableList(this.pixelRanges);
    }

    public int getSubnet() {
        return this.subnet;
    }

    public int getUniverse() {
        return this.universe;
    }
}

