/*
 * Decompiled with CFR 0.152.
 */
package org.capybara.artnetforprocessing;

import artnet4j.ArtNet;
import artnet4j.ArtNetException;
import artnet4j.ArtNetNode;
import artnet4j.events.ArtNetDiscoveryListener;
import artnet4j.packets.ArtDmxPacket;
import java.util.ArrayList;
import java.util.List;
import org.capybara.artnetforprocessing.AbstractPixelRange;
import org.capybara.artnetforprocessing.HorizPixelRange;
import org.capybara.artnetforprocessing.Universe;
import org.capybara.artnetforprocessing.VertPixelRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import processing.core.PApplet;
import processing.core.PConstants;

public class ArtnetForProcessing
implements ArtNetDiscoveryListener,
PConstants {
    private PApplet parent;
    private static final Logger log = LoggerFactory.getLogger(ArtnetForProcessing.class);
    private ArtNetNode netLynx;
    private int sequenceID;
    private ArtNet artnet;
    private List<Universe> universes = new ArrayList<Universe>();

    public ArtnetForProcessing(PApplet parent) {
        this.parent = parent;
        parent.registerMethod("dispose", (Object)this);
        parent.registerMethod("post", (Object)this);
        this.artnet = new ArtNet();
        try {
            this.artnet.start();
        }
        catch (Exception e) {
            log.error("unable to start artnet: " + e.getMessage());
        }
    }

    public void addUniverse(Universe u) {
        this.universes.add(u);
    }

    public void post() {
        for (Universe u : this.universes) {
            byte[] universeBuffer = new byte[512];
            for (AbstractPixelRange pixelRange : u.getPixelRanges()) {
                int startOffset = pixelRange.getStartChannel();
                int length = Math.abs(pixelRange.getLength());
                boolean invert = pixelRange.getLength() < 0;
                int i = 0;
                while (i < length) {
                    int rgbPixel = 0;
                    if (pixelRange instanceof HorizPixelRange) {
                        rgbPixel = !invert ? this.parent.get(pixelRange.getX() + i, pixelRange.getY()) : this.parent.get(pixelRange.getX() - i, pixelRange.getY());
                    } else if (pixelRange instanceof VertPixelRange) {
                        rgbPixel = !invert ? this.parent.get(pixelRange.getX(), pixelRange.getY() + i) : this.parent.get(pixelRange.getX(), pixelRange.getY() - i);
                    } else {
                        log.error("Unknown pixel range type, aborting frame: " + pixelRange.toString());
                        return;
                    }
                    int red = rgbPixel >> 16 & 0xFF;
                    int green = rgbPixel >> 8 & 0xFF;
                    int blue = rgbPixel & 0xFF;
                    int channelPos = i * 3 + startOffset;
                    universeBuffer[channelPos] = (byte)green;
                    universeBuffer[channelPos + 1] = (byte)red;
                    universeBuffer[channelPos + 2] = (byte)blue;
                    ++i;
                }
            }
            this.sendPacket(universeBuffer, u.getSubnet(), u.getUniverse());
        }
    }

    public void setBroadcastAddress(String ip) {
        this.artnet.setBroadCastAddress(ip);
    }

    public void dispose() {
        this.artnet.stop();
    }

    @Override
    public void discoveredNewNode(ArtNetNode node) {
        if (this.netLynx == null) {
            this.netLynx = node;
            log.debug("found a new node: " + node);
        }
    }

    @Override
    public void discoveredNodeDisconnected(ArtNetNode node) {
        System.out.println("node disconnected: " + node);
        if (node == this.netLynx) {
            this.netLynx = null;
        }
    }

    @Override
    public void discoveryCompleted(List<ArtNetNode> nodes) {
        log.debug(String.valueOf(nodes.size()) + " nodes found:");
        for (ArtNetNode n : nodes) {
            log.debug("   " + n);
        }
    }

    private void sendPacket(byte[] buffer, int subnet, int universe) {
        ArtDmxPacket dmx = new ArtDmxPacket();
        dmx.setUniverse(subnet, universe);
        dmx.setSequenceID(this.sequenceID % 255);
        dmx.setDMX(buffer, buffer.length);
        this.artnet.broadcastPacket(dmx);
        ++this.sequenceID;
    }

    @Override
    public void discoveryFailed(Throwable t) {
        log.error("discovery failed: " + t.getMessage(), t);
    }

    public void start() {
        try {
            this.artnet.getNodeDiscovery().addListener(this);
            this.artnet.startNodeDiscovery();
        }
        catch (ArtNetException e) {
            log.error("error starting artnet: " + e.getMessage(), (Throwable)e);
        }
    }
}

