/*
 * Decompiled with CFR 0.152.
 */
package org.capybara.artnetforprocessing;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPixelRange {
    private int y;
    private int x;
    private int length;
    private int startChannel;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractPixelRange(int x, int y, int length, int startDmxChannel) {
        this.x = x;
        this.y = y;
        if (startDmxChannel == 0) {
            this.log.warn("dmx channels start at 1, not 0. assuming you meant 1.");
            startDmxChannel = 1;
        }
        this.length = length;
        this.startChannel = --startDmxChannel;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "  range: y=" + this.y + " x=[" + this.x + "-" + (this.x + this.length) + "] channels=[" + this.startChannel + "-" + (this.startChannel + this.length * 3) + "]";
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public int getLength() {
        return this.length;
    }

    public int getStartChannel() {
        return this.startChannel;
    }
}

