/*
 * Decompiled with CFR 0.152.
 */
package artnet4j.packets;

import artnet4j.packets.ArtNetPacket;
import artnet4j.packets.ArtPollPacket;
import artnet4j.packets.ArtPollReplyPacket;

public enum PacketType {
    ART_POLL(8192, ArtPollPacket.class),
    ART_POLL_REPLY(8448, ArtPollReplyPacket.class),
    ART_OUTPUT(20480, null),
    ART_ADDRESS(24576, null),
    ART_INPUT(28672, null),
    ART_TOD_REQUEST(32768, null),
    ART_TOD_DATA(33024, null),
    ART_TOD_CONTROL(33280, null),
    ART_RDM(33536, null),
    ART_RDMSUB(33792, null),
    ART_MEDIA(36864, null),
    ART_MEDIA_PATCH(37120, null),
    ART_MEDIA_CONTROL(37376, null),
    ART_MEDIA_CONTROL_REPLY(37632, null),
    ART_VIDEO_SETUP(40976, null),
    ART_VIDEO_PALETTE(40992, null),
    ART_VIDEO_DATA(41024, null),
    ART_MAC_MASTER(61440, null),
    ART_MAC_SLAVE(61696, null),
    ART_FIRMWARE_MASTER(61952, null),
    ART_FIRMWARE_REPLY(62208, null),
    ART_IP_PROG(63488, null),
    ART_IP_PROG_REPLY(63744, null);

    private final int opCode;
    private final Class<? extends ArtNetPacket> packetClass;

    private PacketType(int code, Class<? extends ArtNetPacket> clazz) {
        this.opCode = code;
        this.packetClass = clazz;
    }

    public ArtNetPacket createPacket() {
        ArtNetPacket p = null;
        if (this.packetClass != null) {
            try {
                p = this.packetClass.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public int getOpCode() {
        return this.opCode;
    }
}

