/*
 * Decompiled with CFR 0.152.
 */
package artnet4j.packets;

import artnet4j.NodeReportCode;
import artnet4j.NodeStyle;
import artnet4j.PortDescriptor;
import artnet4j.packets.ArtNetPacket;
import artnet4j.packets.PacketType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class ArtPollReplyPacket
extends ArtNetPacket {
    private InetAddress ip;
    private int subSwitch;
    private int oemCode;
    private int nodeStatus;
    private String shortName;
    private String longName;
    private int numPorts;
    private PortDescriptor[] ports;
    private NodeStyle nodeStyle;
    private NodeReportCode reportCode;
    private byte[] dmxIns;
    private byte[] dmxOuts;

    public ArtPollReplyPacket() {
        super(PacketType.ART_POLL_REPLY);
    }

    public ArtPollReplyPacket(byte[] data) {
        super(PacketType.ART_POLL_REPLY);
        this.setData(data);
    }

    public byte[] getDmxIns() {
        return this.dmxIns;
    }

    public byte[] getDmxOuts() {
        return this.dmxOuts;
    }

    public InetAddress getIPAddress() {
        InetAddress ipClone = null;
        try {
            ipClone = InetAddress.getByAddress(this.ip.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipClone;
    }

    public String getLongName() {
        return this.longName;
    }

    public int getNodeStatus() {
        return this.nodeStatus;
    }

    public NodeStyle getNodeStyle() {
        return this.nodeStyle;
    }

    public int getOEMCode() {
        return this.oemCode;
    }

    public PortDescriptor[] getPorts() {
        return this.ports;
    }

    public NodeReportCode getReportCode() {
        return this.reportCode;
    }

    public String getShortName() {
        return this.shortName;
    }

    public int getSubSwitch() {
        return this.subSwitch;
    }

    @Override
    public boolean parse(byte[] raw) {
        int i;
        this.setData(raw);
        this.setIPAddress(this.data.getByteChunk(null, 10, 4));
        this.subSwitch = this.data.getInt16(18);
        this.oemCode = this.data.getInt16(20);
        this.nodeStatus = this.data.getInt8(23);
        this.shortName = new String(this.data.getByteChunk(null, 26, 17));
        this.longName = new String(this.data.getByteChunk(null, 44, 64));
        this.reportCode = NodeReportCode.getForID(new String(this.data.getByteChunk(null, 108, 5)));
        this.numPorts = this.data.getInt16(172);
        this.ports = new PortDescriptor[this.numPorts];
        for (i = 0; i < this.numPorts; ++i) {
            this.ports[i] = new PortDescriptor(this.data.getInt8(174 + i));
        }
        this.dmxIns = this.data.getByteChunk(null, 186, 4);
        this.dmxOuts = this.data.getByteChunk(null, 190, 4);
        i = 0;
        while (i < 4) {
            int n = i;
            this.dmxIns[n] = (byte)(this.dmxIns[n] & 0xF);
            int n2 = i++;
            this.dmxOuts[n2] = (byte)(this.dmxOuts[n2] & 0xF);
        }
        int styleID = this.data.getInt8(200);
        for (NodeStyle s : NodeStyle.values()) {
            if (styleID != s.getStyleID()) continue;
            this.nodeStyle = s;
        }
        return true;
    }

    public void setDmxIns(byte[] dmxIns) {
        this.dmxIns = dmxIns;
    }

    public void setDmxOuts(byte[] dmxOuts) {
        this.dmxOuts = dmxOuts;
    }

    private void setIPAddress(byte[] address) {
        try {
            this.ip = InetAddress.getByAddress(address);
            logger.fine("setting ip address: " + this.ip);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void setReportCode(NodeReportCode reportCode) {
        this.reportCode = reportCode;
    }
}

