/*
 * Decompiled with CFR 0.152.
 */
package artnet4j.packets;

import artnet4j.packets.ArtNetPacket;
import artnet4j.packets.PacketType;

public class ArtPollPacket
extends ArtNetPacket {
    private static int ARTPOLL_LENGTH = 14;
    private boolean replyOnce;
    private boolean replyDirect;

    public ArtPollPacket() {
        this(true, true);
    }

    public ArtPollPacket(boolean replyOnce, boolean replyDirect) {
        super(PacketType.ART_POLL);
        this.setData(new byte[ARTPOLL_LENGTH]);
        this.setHeader();
        this.setProtocol();
        this.setTalkToMe(replyOnce, replyDirect);
    }

    @Override
    public int getLength() {
        return this.data.getLength();
    }

    @Override
    public boolean parse(byte[] raw) {
        this.setData(raw, ARTPOLL_LENGTH);
        int talk = this.data.getInt8(12);
        this.replyOnce = 0 == (talk & 2);
        this.replyDirect = 1 == (talk & 1);
        return true;
    }

    private void setTalkToMe(boolean replyOnce, boolean replyDirect) {
        this.replyOnce = replyOnce;
        this.replyDirect = replyDirect;
        this.data.setInt8((replyOnce ? 0 : 2) | (replyDirect ? 1 : 0), 12);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + ": reply once:" + this.replyOnce + " direct: " + this.replyDirect;
    }
}

