/*
 * Decompiled with CFR 0.152.
 */
package artnet4j.packets;

import artnet4j.packets.ByteUtils;
import artnet4j.packets.PacketType;
import java.util.logging.Logger;

public abstract class ArtNetPacket {
    public static final byte[] HEADER = "Art-Net\u0000".getBytes();
    public static final int PROTOCOL_VERSION = 14;
    public static final Logger logger = Logger.getLogger(ArtNetPacket.class.getClass().getName());
    protected ByteUtils data;
    protected final PacketType type;

    public ArtNetPacket(PacketType type) {
        this.type = type;
    }

    public byte[] getData() {
        return this.data.getBytes();
    }

    public int getLength() {
        return this.data.length;
    }

    public PacketType getType() {
        return this.type;
    }

    public abstract boolean parse(byte[] var1);

    public void setData(byte[] data) {
        this.data = new ByteUtils(data);
    }

    public void setData(byte[] raw, int maxLength) {
        if (raw.length > maxLength) {
            byte[] raw2 = new byte[maxLength];
            System.arraycopy(raw, 0, raw2, 0, maxLength);
            raw = raw2;
        }
        this.setData(raw);
    }

    protected void setHeader() {
        this.data.setByteChunk(HEADER, 0, 8);
        this.data.setInt16LE(this.type.getOpCode(), 8);
    }

    protected void setProtocol() {
        this.data.setInt16(14, 10);
    }

    public String toString() {
        return this.data.toHex(this.getLength());
    }
}

