/*
 * Decompiled with CFR 0.152.
 */
package artnet4j.packets;

import artnet4j.packets.ArtNetPacket;
import artnet4j.packets.ByteUtils;
import artnet4j.packets.PacketType;

public class ArtDmxPacket
extends ArtNetPacket {
    private int numChannels;
    private int sequenceID;
    private int subnetID;
    private int universeID;

    public ArtDmxPacket() {
        super(PacketType.ART_OUTPUT);
        this.setData(new byte[530]);
        this.setHeader();
        this.setProtocol();
        this.data.setInt8(2, 13);
    }

    @Override
    public int getLength() {
        return 18 + (1 == this.numChannels % 2 ? this.numChannels + 1 : this.numChannels);
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getSequenceID() {
        return this.sequenceID;
    }

    public int getSubnetID() {
        return this.subnetID;
    }

    public int getUniverseID() {
        return this.universeID;
    }

    @Override
    public boolean parse(byte[] raw) {
        return false;
    }

    public void setDMX(byte[] dmxData, int numChannels) {
        logger.finer("setting DMX data for: " + numChannels + " channels");
        this.numChannels = numChannels;
        this.data.setByteChunk(dmxData, 18, numChannels);
        this.data.setInt16(1 == numChannels % 2 ? numChannels + 1 : numChannels, 16);
    }

    public void setNumChannels(int numChannels) {
        this.numChannels = numChannels > 512 ? 512 : numChannels;
    }

    public void setSequenceID(int id) {
        this.sequenceID = id % 255;
        this.data.setInt8(id, 12);
    }

    public void setSubnetID(int subnetID) {
        this.subnetID = subnetID & 0xF;
    }

    public void setUniverse(int subnetID, int universeID) {
        this.subnetID = subnetID & 0xF;
        this.universeID = universeID & 0xF;
        this.data.setInt16LE(subnetID << 4 | universeID, 14);
        logger.finer("universe ID set to: subnet: " + ByteUtils.hex(subnetID, 2) + "/" + ByteUtils.hex(universeID, 2));
    }

    public void setUniverseID(int universeID) {
        this.universeID = universeID & 0xF;
    }
}

