/*
 * Decompiled with CFR 0.152.
 */
package artnet4j;

import artnet4j.ArtNetException;
import artnet4j.ArtNetNode;
import artnet4j.NodeStyle;
import artnet4j.events.ArtNetServerListener;
import artnet4j.packets.ArtNetPacket;
import artnet4j.packets.ArtNetPacketParser;
import artnet4j.packets.ArtPollPacket;
import artnet4j.packets.PacketType;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ArtNetServer
extends ArtNetNode
implements Runnable {
    public static final int DEFAULT_PORT = 6454;
    public static final String DEFAULT_BROADCAST_IP = "2.255.255.255";
    protected final int port;
    protected final int sendPort;
    protected DatagramSocket socket;
    protected InetAddress broadCastAddress;
    protected Thread serverThread;
    protected int receiveBufferSize;
    protected boolean isRunning;
    protected final List<ArtNetServerListener> listeners;

    public ArtNetServer() {
        this(6454, 6454);
    }

    public ArtNetServer(int port, int sendPort) {
        super(NodeStyle.ST_SERVER);
        this.port = port;
        this.sendPort = sendPort;
        this.listeners = new ArrayList<ArtNetServerListener>();
        this.setBufferSize(2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ArtNetServerListener l) {
        List<ArtNetServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public void broadcastPacket(ArtNetPacket ap) {
        try {
            DatagramPacket packet = new DatagramPacket(ap.getData(), ap.getLength(), this.broadCastAddress, this.sendPort);
            this.socket.send(packet);
            for (ArtNetServerListener l : this.listeners) {
                l.artNetPacketBroadcasted(ap);
            }
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ArtNetServerListener l) {
        List<ArtNetServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void run() {
        byte[] receiveBuffer = new byte[this.receiveBufferSize];
        DatagramPacket receivedPacket = new DatagramPacket(receiveBuffer, receiveBuffer.length);
        try {
            while (this.isRunning) {
                this.socket.receive(receivedPacket);
                logger.finer("received new packet");
                ArtNetPacket packet = ArtNetPacketParser.parse(receivedPacket);
                if (packet == null) continue;
                if (packet.getType() == PacketType.ART_POLL) {
                    this.sendArtPollReply(receivedPacket.getAddress(), (ArtPollPacket)packet);
                }
                for (ArtNetServerListener l : this.listeners) {
                    l.artNetPacketReceived(packet);
                }
            }
            this.socket.close();
            logger.info("server thread terminated.");
            for (ArtNetServerListener l : this.listeners) {
                l.artNetServerStopped(this);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendArtPollReply(InetAddress inetAddress, ArtPollPacket packet) {
    }

    public void setBroadcastAddress(String address) {
        try {
            this.broadCastAddress = InetAddress.getByName(address);
            logger.fine("broadcast IP set to: " + this.broadCastAddress);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void setBufferSize(int size) {
        if (!this.isRunning) {
            this.receiveBufferSize = size;
        }
    }

    public void start() throws SocketException, ArtNetException {
        if (this.broadCastAddress == null) {
            this.setBroadcastAddress(DEFAULT_BROADCAST_IP);
        }
        if (this.socket == null) {
            this.socket = new DatagramSocket(this.port);
            logger.info("Art-Net server started at port: " + this.port);
            for (ArtNetServerListener l : this.listeners) {
                l.artNetServerStarted(this);
            }
        } else {
            throw new ArtNetException("Couldn't create server socket, server already running?");
        }
        this.isRunning = true;
        this.serverThread = new Thread(this);
        this.serverThread.start();
    }

    public void stop() {
        this.isRunning = false;
    }

    public void unicastPacket(ArtNetPacket ap, InetAddress targetAdress) {
        try {
            DatagramPacket packet = new DatagramPacket(ap.getData(), ap.getLength(), targetAdress, this.sendPort);
            this.socket.send(packet);
            logger.finer("sent packet to: " + targetAdress);
            for (ArtNetServerListener l : this.listeners) {
                l.artNetPacketUnicasted(ap);
            }
        }
        catch (IOException e) {
            logger.warning(e.getMessage());
        }
    }
}

