/*
 * Decompiled with CFR 0.152.
 */
package artnet4j;

import artnet4j.ArtNet;
import artnet4j.ArtNetException;
import artnet4j.ArtNetNode;
import artnet4j.events.ArtNetDiscoveryListener;
import artnet4j.packets.ArtPollPacket;
import artnet4j.packets.ArtPollReplyPacket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class ArtNetNodeDiscovery
implements Runnable {
    public static final int POLL_INTERVAL = 10000;
    public static final Logger logger = Logger.getLogger(ArtNetNodeDiscovery.class.getClass().getName());
    protected final ArtNet artNet;
    protected ConcurrentHashMap<InetAddress, ArtNetNode> discoveredNodes = new ConcurrentHashMap();
    protected List<ArtNetNode> lastDiscovered = new ArrayList<ArtNetNode>();
    protected List<ArtNetDiscoveryListener> listeners = new ArrayList<ArtNetDiscoveryListener>();
    protected boolean isActive = true;
    protected long discoveryInterval;
    private Thread discoveryThread;

    public ArtNetNodeDiscovery(ArtNet artNet) {
        this.artNet = artNet;
        this.setInterval(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ArtNetDiscoveryListener l) {
        List<ArtNetDiscoveryListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    public void discoverNode(ArtPollReplyPacket reply) {
        InetAddress nodeIP = reply.getIPAddress();
        ArtNetNode node = this.discoveredNodes.get(nodeIP);
        if (node == null) {
            logger.info("discovered new node: " + nodeIP);
            node = reply.getNodeStyle().createNode();
            node.extractConfig(reply);
            this.discoveredNodes.put(nodeIP, node);
            for (ArtNetDiscoveryListener l : this.listeners) {
                l.discoveredNewNode(node);
            }
        } else {
            node.extractConfig(reply);
        }
        this.lastDiscovered.add(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ArtNetDiscoveryListener l) {
        List<ArtNetDiscoveryListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.isActive) {
                this.lastDiscovered.clear();
                ArtPollPacket poll = new ArtPollPacket();
                this.artNet.broadcastPacket(poll);
                Thread.sleep(3000L);
                if (!this.isActive) continue;
                List<ArtNetDiscoveryListener> list = this.listeners;
                synchronized (list) {
                    for (ArtNetNode node : this.discoveredNodes.values()) {
                        if (this.lastDiscovered.contains(node)) continue;
                        this.discoveredNodes.remove(node.getIPAddress());
                        for (ArtNetDiscoveryListener l : this.listeners) {
                            l.discoveredNodeDisconnected(node);
                        }
                    }
                    for (ArtNetDiscoveryListener l : this.listeners) {
                        l.discoveryCompleted(new ArrayList<ArtNetNode>(this.discoveredNodes.values()));
                    }
                }
                Thread.sleep(this.discoveryInterval - 3000L);
            }
        }
        catch (InterruptedException e) {
            logger.warning("node discovery interrupted");
        }
    }

    public void setInterval(int interval) {
        this.discoveryInterval = Math.max((long)interval, 3000L);
    }

    public void start() throws ArtNetException {
        if (this.discoveryThread != null) {
            throw new ArtNetException("discovery already started.");
        }
        this.discoveryThread = new Thread(this);
        this.discoveryThread.start();
    }

    public void stop() {
        this.isActive = false;
    }
}

