/*
 * Decompiled with CFR 0.152.
 */
package artnet4j;

import artnet4j.ArtNetException;
import artnet4j.ArtNetNode;
import artnet4j.ArtNetNodeDiscovery;
import artnet4j.ArtNetServer;
import artnet4j.events.ArtNetServerEventAdapter;
import artnet4j.events.ArtNetServerListener;
import artnet4j.packets.ArtNetPacket;
import artnet4j.packets.ArtPollReplyPacket;
import artnet4j.packets.PacketType;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArtNet {
    public static final Logger logger = Logger.getLogger(ArtNet.class.getClass().getName());
    protected static final long ARTPOLL_REPLY_TIMEOUT = 3000L;
    protected static final String VERSION = "0001-20091119";
    protected ArtNetServer server;
    protected ArtNetNodeDiscovery discovery;

    public ArtNet() {
        logger.info("Art-Net v0001-20091119");
    }

    public void addServerListener(ArtNetServerListener l) {
        this.server.addListener(l);
    }

    public void broadcastPacket(ArtNetPacket packet) {
        this.server.broadcastPacket(packet);
    }

    public ArtNetNodeDiscovery getNodeDiscovery() {
        if (this.discovery == null) {
            this.discovery = new ArtNetNodeDiscovery(this);
        }
        return this.discovery;
    }

    public void init() {
        this.server = new ArtNetServer();
        this.server.addListener(new ArtNetServerEventAdapter(){

            @Override
            public void artNetPacketReceived(ArtNetPacket packet) {
                logger.fine("packet received: " + (Object)((Object)packet.getType()));
                if (ArtNet.this.discovery != null && packet.getType() == PacketType.ART_POLL_REPLY) {
                    ArtNet.this.discovery.discoverNode((ArtPollReplyPacket)packet);
                }
            }

            @Override
            public void artNetServerStarted(ArtNetServer artNetServer) {
                logger.fine("server started callback");
            }

            @Override
            public void artNetServerStopped(ArtNetServer artNetServer) {
                logger.info("server stopped");
            }
        });
    }

    public void removeServerListener(ArtNetServerListener l) {
        this.server.removeListener(l);
    }

    public void setBroadCastAddress(String ip) {
        this.server.setBroadcastAddress(ip);
    }

    public void start() throws SocketException, ArtNetException {
        if (this.server == null) {
            this.init();
        }
        this.server.start();
    }

    public void startNodeDiscovery() throws ArtNetException {
        this.getNodeDiscovery().start();
    }

    public void stop() {
        if (this.discovery != null) {
            this.discovery.stop();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void unicastPacket(ArtNetPacket packet, ArtNetNode node) {
        this.server.unicastPacket(packet, node.getIPAddress());
    }

    public void unicastPacket(ArtNetPacket packet, InetAddress adr) {
        this.server.unicastPacket(packet, adr);
    }

    public void unicastPacket(ArtNetPacket packet, String adr) {
        try {
            InetAddress targetAdress = InetAddress.getByName(adr);
            this.server.unicastPacket(packet, targetAdress);
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }
}

