/*
 * Decompiled with CFR 0.152.
 */
package com.triplescape.doapamine;

import com.triplescape.doapamine.Person;
import com.triplescape.doapamine.Project;
import com.triplescape.doapamine.Repository;
import com.triplescape.doapamine.Specification;
import com.triplescape.doapamine.Version;
import java.io.File;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

@Project(name="DOAPamine", homepage="http://code.google.com/p/doapamine/", old_homepage={}, category={"http://freshmeat.net/browse/45/", "http://freshmeat.net/browse/198/"}, created="2009-07-02", shortdesc="Ant task and annotations to create DOAP from Java.", description="DOAPamine generates DOAP from custom class/package annotations.", mailinglist={}, license={"http://www.opensource.org/licenses/bsd-license.php"}, download_page="http://code.google.com/p/doapamine/downloads/list", download_mirror={}, wiki="", bug_database="", screenshots={}, programming_language={"java"}, os={}, platform={"java"}, vendor="", service_endpoint="", blog="http://blog.triplescape.com", audience={"developers"}, language={"en"}, release={@Version(name="stable", created="2009-06-02", revision="0.4", os="any", platform="java", file_release="http://code.google.com/p/doapamine/downloads/list")}, _implements={@Specification(about="http://usefulinc.com/ns/doap")}, developer={@Person(name="Brian Manley", mbox="brian.manley@gmail.com", seeAlso="http://blog.triplescape.com/bmanley.rdf")}, maintainer={}, documentor={}, translator={}, tester={}, helper={}, repository=@Repository(type=Repository.type.SVNRepository, browse="http://code.google.com/p/doapamine/source/browse/", anon_root="https://doapamine.googlecode.com/svn", location="https://doapamine.googlecode.com/svn", module="daopamine"))
public class DOAPTask
extends Task {
    private String _class = null;
    private String _output = null;

    public void setClass(String clazz) {
        this._class = clazz;
    }

    public void setOutput(String dir) {
        this._output = dir;
    }

    private boolean okay(String value) {
        return value != null && value.trim().length() != 0;
    }

    private String pad(int count) {
        String pad = "";
        int i = 0;
        while (i < count) {
            pad = String.valueOf(pad) + "\t";
            ++i;
        }
        return pad;
    }

    private void emitStrings(int pad, String[] strings, String name, PrintWriter out) throws Exception {
        if (strings.length > 0) {
            int i = 0;
            while (i < strings.length) {
                if (this.okay(strings[i])) {
                    out.println(String.valueOf(this.pad(pad)) + "<" + name + ">" + strings[i] + "</" + name + ">");
                }
                ++i;
            }
            out.println();
        }
    }

    private void emitString(int pad, String value, String name, PrintWriter out) throws Exception {
        if (this.okay(value)) {
            out.println(String.valueOf(this.pad(pad)) + "<" + name + ">" + value + "</" + name + ">");
        }
    }

    private void emitResources(int pad, String[] strings, String name, PrintWriter out) throws Exception {
        if (strings.length > 0) {
            int i = 0;
            while (i < strings.length) {
                if (this.okay(strings[i])) {
                    out.println(String.valueOf(this.pad(pad)) + "<" + name + " rdf:resource=\"" + strings[i] + "\"/>");
                }
                ++i;
            }
            out.println();
        }
    }

    private void emitResource(int pad, String value, String name, PrintWriter out) throws Exception {
        if (this.okay(value)) {
            out.println(String.valueOf(this.pad(pad)) + "<" + name + " rdf:resource=\"" + value + "\"/>");
        }
    }

    public void emitPerson(int pad, Person[] people, String name, PrintWriter out) throws Exception {
        if (people.length > 0) {
            int i = 0;
            while (i < people.length) {
                out.print(String.valueOf(this.pad(pad)) + "<" + name + ">\n");
                out.print(String.valueOf(this.pad(pad + 1)) + "<foaf:Person>\n");
                out.print(String.valueOf(this.pad(pad + 2)) + "<foaf:name>" + people[i].name() + "</foaf:name>\n");
                if (people[i].mbox().startsWith("mailto:")) {
                    out.print(String.valueOf(this.pad(pad + 2)) + "<foaf:mbox rdf:resource=\"" + people[i].mbox() + "\"/>\n");
                } else {
                    out.print(String.valueOf(this.pad(pad + 2)) + "<foaf:mbox rdf:resource=\"mailto:" + people[i].mbox() + "\"/>\n");
                }
                out.print(String.valueOf(this.pad(pad + 2)) + "<rdfs:seeAlso rdf:resource=\"" + people[i].seeAlso() + "\"/>\n");
                out.print(String.valueOf(this.pad(pad + 1)) + "</foaf:Person>\n");
                out.print(String.valueOf(this.pad(pad)) + "</" + name + ">\n");
                ++i;
            }
            out.print("\n");
        }
    }

    private void emitRelease(Version release, PrintWriter out) throws Exception {
        if (this.okay(release.name()) || this.okay(release.created()) || this.okay(release.revision())) {
            out.print(String.valueOf(this.pad(2)) + "<Release>\n");
            out.print(String.valueOf(this.pad(3)) + "<version>\n");
            this.emitString(4, release.name(), "name", out);
            this.emitString(4, release.created(), "created", out);
            this.emitString(4, release.revision(), "revision", out);
            this.emitResource(4, release.file_release(), "file-release", out);
            out.print(String.valueOf(this.pad(3)) + "</version>\n");
            out.print(String.valueOf(this.pad(2)) + "</Release>\n");
            out.print("\n");
        }
    }

    private void emitRepository(Repository repos, PrintWriter out) throws Exception {
        if (repos.type() != Repository.type.NONE) {
            out.print(String.valueOf(this.pad(2)) + "<repository>\n");
            out.print(String.valueOf(this.pad(3)) + "<" + repos.type().toString() + ">\n");
            this.emitResource(4, repos.anon_root(), "anon-root", out);
            this.emitResource(4, repos.browse(), "browse", out);
            this.emitString(4, repos.module(), "module", out);
            this.emitResource(4, repos.location(), "location", out);
            out.print(String.valueOf(this.pad(3)) + "</" + repos.type().toString() + ">\n");
            out.print(String.valueOf(this.pad(2)) + "</repository>\n");
            out.print("\n");
        }
    }

    private void emitSpecification(Specification spec, PrintWriter out) throws Exception {
        if (this.okay(spec.about())) {
            out.print(String.valueOf(this.pad(2)) + "<implements>\n");
            out.print(String.valueOf(this.pad(3)) + "<Specification rdf:about=\"" + spec.about() + "\"/>\n");
            out.print(String.valueOf(this.pad(2)) + "</implements>");
            out.print("\n");
        }
    }

    private void emitHeader(PrintWriter out) throws Exception {
        out.print("<?xml version=\"1.0\"?>\n");
        out.print("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n\txmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"\n\txmlns:foaf=\"http://xmlns.com/foaf/0.1/\"\n\txmlns=\"http://usefulinc.com/ns/doap#\">\n\n");
    }

    private void emitMaker(PrintWriter out) throws Exception {
        out.print(String.valueOf(this.pad(1)) + "<rdf:Description rdf:about=\"\">\n");
        out.print(String.valueOf(this.pad(2)) + "<foaf:maker>\n");
        out.print(String.valueOf(this.pad(3)) + "<foaf:Agent>\n");
        out.print(String.valueOf(this.pad(4)) + "<foaf:name>" + DOAPTask.class.getName() + "</foaf:name>\n");
        out.print(String.valueOf(this.pad(4)) + "<foaf:homepage rdf:resource=\"http:/www.triplescape.com/doapamine\"/>\n");
        out.print(String.valueOf(this.pad(3)) + "</foaf:Agent>\n");
        out.print(String.valueOf(this.pad(2)) + "</foaf:maker>\n");
        out.print(String.valueOf(this.pad(1)) + "</rdf:Description>\n");
        out.print("\n");
    }

    public void execute() throws BuildException {
        if (this._class == null) {
            throw new BuildException("classname is required.");
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(this._class);
        }
        catch (Exception e) {
            throw new BuildException("Could not load class " + this._class);
        }
        if (!clazz.isAnnotationPresent(Project.class)) {
            throw new BuildException("No Project annotation present in class " + this._class);
        }
        System.out.println("Writing DOAP data to " + this._output);
        Project project = clazz.getAnnotation(Project.class);
        try {
            PrintWriter out = new PrintWriter(new File(this._output));
            this.emitHeader(out);
            out.println("\t<Project>\n");
            this.emitString(2, project.name(), "name", out);
            this.emitResource(2, project.homepage(), "homepage", out);
            this.emitResources(2, project.old_homepage(), "old-homepage", out);
            this.emitString(2, project.shortdesc(), "shortdesc", out);
            this.emitString(2, project.description(), "description", out);
            Repository repo = project.repository();
            this.emitRepository(repo, out);
            Version[] versions = project.release();
            int i = 0;
            while (i < versions.length) {
                this.emitRelease(versions[i], out);
                ++i;
            }
            Specification[] specs = project._implements();
            int i2 = 0;
            while (i2 < specs.length) {
                this.emitSpecification(specs[i2], out);
                ++i2;
            }
            this.emitResources(2, project.mailinglist(), "mailinglist", out);
            this.emitResource(2, project.download_page(), "download-page", out);
            this.emitResource(2, project.vendor(), "vendor", out);
            this.emitResource(2, project.wiki(), "wiki", out);
            this.emitResource(2, project.blog(), "blog", out);
            this.emitResource(2, project.bug_database(), "bug-database", out);
            this.emitResources(2, project.download_mirror(), "download-mirror", out);
            this.emitResources(2, project.license(), "license", out);
            this.emitResources(2, project.category(), "category", out);
            this.emitResources(2, project.screenshots(), "screenshots", out);
            this.emitStrings(2, project.programming_language(), "programming-language", out);
            this.emitStrings(2, project.os(), "os", out);
            this.emitStrings(2, project.language(), "language", out);
            this.emitStrings(2, project.platform(), "platform", out);
            this.emitStrings(2, project.audience(), "audience", out);
            this.emitResource(2, project.service_endpoint(), "service-endpoint", out);
            this.emitPerson(2, project.maintainer(), "maintainer", out);
            this.emitPerson(2, project.developer(), "developer", out);
            this.emitPerson(2, project.documentor(), "documentor", out);
            this.emitPerson(2, project.translator(), "translator", out);
            this.emitPerson(2, project.tester(), "tester", out);
            this.emitPerson(2, project.helper(), "helper", out);
            out.print("\t</Project>\n");
            this.emitMaker(out);
            out.print("</rdf:RDF>\n");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new BuildException("Failed to create file. " + e.getMessage());
        }
    }

    private void printUsage() {
        System.out.println("Usage: DOAPTask [annotated class name] [output file name]");
    }

    public static void main(String[] args) {
        DOAPTask task = new DOAPTask();
        if (args.length != 2) {
            task.printUsage();
            System.exit(1);
        }
        task.setClass(args[0]);
        task.setOutput(args[1]);
        task.execute();
    }
}

