/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.util.Arrays;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

class FontTexture
implements PConstants {
    protected PGL pgl = PGraphicsOpenGL.pgl;
    protected boolean is3D;
    protected int minSize;
    protected int maxSize;
    protected int offsetX;
    protected int offsetY;
    protected int lineHeight;
    protected Texture[] textures = null;
    protected PImage[] images = null;
    protected int currentTex;
    protected int lastTex;
    protected TextureInfo[] glyphTexinfos;
    protected HashMap<PFont.Glyph, TextureInfo> texinfoMap;

    public FontTexture(PGraphicsOpenGL pg, PFont font, boolean is3D) {
        this.is3D = is3D;
        this.initTexture(pg, font);
    }

    protected void allocate() {
    }

    protected void dispose() {
        int i = 0;
        while (i < this.textures.length) {
            this.textures[i].dispose();
            ++i;
        }
    }

    protected void initTexture(PGraphicsOpenGL pg, PFont font) {
        this.currentTex = -1;
        this.lastTex = -1;
        int spow = PGL.nextPowerOfTwo(font.getSize());
        this.minSize = PApplet.min(PGraphicsOpenGL.maxTextureSize, PApplet.max(256, spow));
        this.maxSize = PApplet.min(PGraphicsOpenGL.maxTextureSize, PApplet.max(1024, 2 * spow));
        if (this.maxSize < spow) {
            PGraphics.showWarning("The font size is too large to be properly displayed with OpenGL");
        }
        this.addTexture(pg);
        this.offsetX = 0;
        this.offsetY = 0;
        this.lineHeight = 0;
        this.texinfoMap = new HashMap();
        this.glyphTexinfos = new TextureInfo[font.getGlyphCount()];
        this.addAllGlyphsToTexture(pg, font);
    }

    public boolean addTexture(PGraphicsOpenGL pg) {
        boolean resize;
        int h;
        int w = this.maxSize;
        if (-1 < this.currentTex && this.textures[this.currentTex].glHeight < this.maxSize) {
            h = PApplet.min(2 * this.textures[this.currentTex].glHeight, this.maxSize);
            resize = true;
        } else {
            h = this.minSize;
            resize = false;
        }
        Texture tex = this.is3D ? new Texture(w, h, new Texture.Parameters(2, 4, false)) : new Texture(w, h, new Texture.Parameters(2, 3, false));
        if (this.textures == null) {
            this.textures = new Texture[1];
            this.textures[0] = tex;
            this.images = new PImage[1];
            this.images[0] = pg.wrapTexture(tex);
            this.currentTex = 0;
        } else if (resize) {
            Texture tex0 = this.textures[this.currentTex];
            tex.put(tex0);
            this.textures[this.currentTex] = tex;
            pg.setCache(this.images[this.currentTex], tex);
            this.images[this.currentTex].width = tex.width;
            this.images[this.currentTex].height = tex.height;
        } else {
            Texture[] tempTex = this.textures;
            this.textures = new Texture[this.textures.length + 1];
            PApplet.arrayCopy(tempTex, this.textures, tempTex.length);
            this.textures[tempTex.length] = tex;
            this.currentTex = this.textures.length - 1;
            PImage[] tempImg = this.images;
            this.images = new PImage[this.textures.length];
            PApplet.arrayCopy(tempImg, this.images, tempImg.length);
            this.images[tempImg.length] = pg.wrapTexture(tex);
        }
        this.lastTex = this.currentTex;
        tex.bind();
        return resize;
    }

    public void begin() {
        this.setTexture(0);
    }

    public void end() {
        int i = 0;
        while (i < this.textures.length) {
            this.pgl.disableTexturing(this.textures[i].glTarget);
            ++i;
        }
    }

    public void setTexture(int idx) {
        if (idx >= 0 && idx < this.textures.length) {
            this.currentTex = idx;
        }
    }

    public PImage getTexture(int idx) {
        if (idx >= 0 && idx < this.images.length) {
            return this.images[idx];
        }
        return null;
    }

    public PImage getCurrentTexture() {
        return this.getTexture(this.currentTex);
    }

    public void addAllGlyphsToTexture(PGraphicsOpenGL pg, PFont font) {
        int i = 0;
        while (i < font.getGlyphCount()) {
            this.addToTexture(pg, i, font.getGlyph(i));
            ++i;
        }
    }

    public void updateGlyphsTexCoords() {
        int i = 0;
        while (i < this.glyphTexinfos.length) {
            TextureInfo tinfo = this.glyphTexinfos[i];
            if (tinfo != null && tinfo.texIndex == this.currentTex) {
                tinfo.updateUV();
            }
            ++i;
        }
    }

    public TextureInfo getTexInfo(PFont.Glyph glyph) {
        TextureInfo info = this.texinfoMap.get(glyph);
        return info;
    }

    public TextureInfo addToTexture(PGraphicsOpenGL pg, PFont.Glyph glyph) {
        int n = this.glyphTexinfos.length;
        if (n == 0) {
            this.glyphTexinfos = new TextureInfo[1];
        }
        this.addToTexture(pg, n, glyph);
        return this.glyphTexinfos[n];
    }

    public boolean contextIsOutdated() {
        boolean outdated = false;
        int i = 0;
        while (i < this.textures.length) {
            if (this.textures[i].contextIsOutdated()) {
                outdated = true;
            }
            ++i;
        }
        if (outdated) {
            i = 0;
            while (i < this.textures.length) {
                PGraphicsOpenGL.removeTextureObject(this.textures[i].glName, this.textures[i].context);
                this.textures[i].glName = 0;
                ++i;
            }
        }
        return outdated;
    }

    protected void addToTexture(PGraphicsOpenGL pg, int idx, PFont.Glyph glyph) {
        int x;
        int y;
        int w = 1 + glyph.width + 1;
        int h = 1 + glyph.height + 1;
        int[] rgba = new int[w * h];
        int t = 0;
        int p = 0;
        if (PGL.BIG_ENDIAN) {
            Arrays.fill(rgba, 0, w, -256);
            t = w;
            y = 0;
            while (y < glyph.height) {
                rgba[t++] = -256;
                x = 0;
                while (x < glyph.width) {
                    rgba[t++] = 0xFFFFFF00 | glyph.image.pixels[p++];
                    ++x;
                }
                rgba[t++] = -256;
                ++y;
            }
            Arrays.fill(rgba, (h - 1) * w, h * w, -256);
        } else {
            Arrays.fill(rgba, 0, w, 0xFFFFFF);
            t = w;
            y = 0;
            while (y < glyph.height) {
                rgba[t++] = 0xFFFFFF;
                x = 0;
                while (x < glyph.width) {
                    rgba[t++] = glyph.image.pixels[p++] << 24 | 0xFFFFFF;
                    ++x;
                }
                rgba[t++] = 0xFFFFFF;
                ++y;
            }
            Arrays.fill(rgba, (h - 1) * w, h * w, 0xFFFFFF);
        }
        if (this.offsetX + w > this.textures[this.currentTex].glWidth) {
            this.offsetX = 0;
            this.offsetY += this.lineHeight;
            this.lineHeight = 0;
        }
        this.lineHeight = Math.max(this.lineHeight, h);
        boolean resized = false;
        if (this.offsetY + this.lineHeight > this.textures[this.currentTex].glHeight) {
            resized = this.addTexture(pg);
            if (resized) {
                this.updateGlyphsTexCoords();
            } else {
                this.offsetX = 0;
                this.offsetY = 0;
                this.lineHeight = 0;
            }
        }
        TextureInfo tinfo = new TextureInfo(this.currentTex, this.offsetX, this.offsetY, w, h, rgba);
        this.offsetX += w;
        if (idx == this.glyphTexinfos.length) {
            TextureInfo[] temp = new TextureInfo[this.glyphTexinfos.length + 1];
            System.arraycopy(this.glyphTexinfos, 0, temp, 0, this.glyphTexinfos.length);
            this.glyphTexinfos = temp;
        }
        this.glyphTexinfos[idx] = tinfo;
        this.texinfoMap.put(glyph, tinfo);
    }

    class TextureInfo {
        int texIndex;
        int width;
        int height;
        int[] crop;
        float u0;
        float u1;
        float v0;
        float v1;
        int[] pixels;

        TextureInfo(int tidx, int cropX, int cropY, int cropW, int cropH, int[] pix) {
            this.texIndex = tidx;
            this.crop = new int[4];
            this.crop[0] = cropX + 1;
            this.crop[1] = cropY + 1 + cropH - 2;
            this.crop[2] = cropW - 2;
            this.crop[3] = -cropH + 2;
            this.pixels = pix;
            this.updateUV();
            this.updateTex();
        }

        void updateUV() {
            this.width = FontTexture.this.textures[this.texIndex].glWidth;
            this.height = FontTexture.this.textures[this.texIndex].glHeight;
            this.u0 = (float)this.crop[0] / (float)this.width;
            this.u1 = this.u0 + (float)this.crop[2] / (float)this.width;
            this.v0 = (float)(this.crop[1] + this.crop[3]) / (float)this.height;
            this.v1 = this.v0 - (float)this.crop[3] / (float)this.height;
        }

        void updateTex() {
            FontTexture.this.textures[this.texIndex].setNative(this.pixels, this.crop[0] - 1, this.crop[1] + this.crop[3] - 1, this.crop[2] + 2, -this.crop[3] + 2);
        }
    }
}

