/* 
 * File:   StrichLuxIOETH.h
 * Author: sarahemm
 *
 * Created on July 1, 2012, 11:24 AM
 */

#ifndef STRICHLUXIOETH_H
#define	STRICHLUXIOETH_H

#ifdef	__cplusplus
extern "C" {
#endif

#include <plib.h>
#include <ArtNet.h>

#define MODSTATE_INIT     0x00   // still trying to negotiate with the CORE
#define MODSTATE_INMOD    0x01   // negotiation complete, we're an input module
#define MODSTATE_OUTMOD   0x02   // negotiation complete, we're an output module
#define MODSTATE_FAULT    0x03   // negotiation failed

#define SPI_NSS_PORT        IOPORT_G
#define SPI_NSS_PIN         BIT_9

BYTE        ModuleState;
BYTE        ModuleSlot;
BYTE        CoreProtoVer;

static void InitAppConfig(void);
static void AssemblePollReplyPacket(struct ArtPollReply *);
static void InputArtNetTask(void);
static void OutputArtNetTask(void);
static void NegotiateModulePosition(void);
static void SPISlaveSelect(BYTE);

#ifdef	__cplusplus
}
#endif

#endif	/* STRICHLUXIOETH_H */

