/*\
 * File:   StrichLuxIOETH.c
 * Author: sen
 *
 * Created on June 20, 2012, 9:27 PM
\*/

/*\
 * LED error codes:
 * 0 - No connection to CORE board
 * 1 - Protocol version on CORE board too low, CORE firmware update required
\*/

#define FIRMWARE_VERSION    1
#define THIS_IS_STACK_APPLICATION
#define ESTA_MFG_CODE 0x03AF

#define SUB_UNI_BASE        0x08

#define CORE_CMD_WRITE      0x02
#define CORE_CMD_GETLOC     0x06
#define CORE_CMD_GETVER     0x08
#define CORE_CMD_TAKEOVER   0x09

#define CORE_MIN_PROTO_VER  0x01

//#include <stdio.h>
#include <stdlib.h>
#include <p32xxxx.h>
#include <plib.h>
#include <HardwareProfile.h>
#include <TCPIP Stack/TCPIP.h>
#include <TCPIP Stack/Tick.h>
#include <TCPIP Stack/StackTsk.h>
#include <StrichLuxIOETH.h>
#include <ArtNet.h>
#include <StatusLEDs.h>

#pragma config OSCIOFNC=OFF, FSOSCEN=OFF, IESO=OFF, ICESEL=ICS_PGx1, POSCMOD=HS
#pragma config FNOSC=PRIPLL, UPLLEN=ON, UPLLIDIV=DIV_2, FWDTEN=OFF
#pragma config FPLLIDIV=DIV_2, FPLLODIV=DIV_1, FPLLMUL=MUL_20, FPBDIV=DIV_1
#pragma config FETHIO=OFF, FMIIEN=OFF, DEBUG=ON

APP_CONFIG      AppConfig;
static ROM BYTE SerializedMACAddress[6] = {MY_DEFAULT_MAC_BYTE1, MY_DEFAULT_MAC_BYTE2, MY_DEFAULT_MAC_BYTE3, MY_DEFAULT_MAC_BYTE4, MY_DEFAULT_MAC_BYTE5, MY_DEFAULT_MAC_BYTE6};
UDP_SOCKET      UdpReceiver;
UDP_SOCKET      UdpSender;

// TODO: move these to non-globals once any watching we need to do is done
int                 PacketLen;
BYTE                *InPacketBuffer;
int                 rv;
uint16_t            *OpCode;
uint8_t             Universe;
struct ArtPollReply PktPollReply;   // dynamically allocate this
BYTE                *DmxBuffer;

int main(int argc, char** argv) {
    PORTSetPinsDigitalOut(SPI_NSS_PORT, SPI_NSS_PIN);
    TRISB = 0xBFC3;
    TRISE = 0xFFE1;
    TRISD = 0xFFFE;
    LATB = 0x0000;
    LATD = 0x0000;
    LATE = 0x0000;
    AD1PCFG = 0xFFFF;
    LATB=0xFFFF;
    LATD=0xFFFF;    // this enables the PHY
    mJTAGPortEnable(0);

    ModuleState = MODSTATE_INIT;
    ModuleSlot  = 0xFF;

    // TODO: error check everything
    INTEnableSystemMultiVectoredInt();
    SYSTEMConfigPerformance(GetSystemClock());
    mOSCSetPBDIV(OSC_PB_DIV_1);

    // enable interrupts
    INTDisableInterrupts();
    INTConfigureSystem(INT_SYSTEM_CONFIG_MULT_VECTOR);  // multi-vector mode
    INTEnableInterrupts();
 
    TickInit();
    InitAppConfig();
    StackInit();
    LEDInit();
    
    OpenSPI2(SPI_MODE32_OFF | SPI_MODE16_OFF | SPI_MODE8_ON | MASTER_ENABLE_ON |
             SLAVE_ENABLE_OFF | FRAME_ENABLE_OFF | PRI_PRESCAL_64_1 |
             SEC_PRESCAL_4_1 | CLK_POL_ACTIVE_HIGH | SPI_CKE_OFF, SPI_ENABLE);
    NegotiateModulePosition();  // this doesn't return until negotiation is complete

    UdpReceiver = UDPOpenEx(0, UDP_OPEN_SERVER, 6454, 0);
    while(1) {
        StackTask();
        StackApplications();
        LEDTask();
        //if(ModuleState = MODSTATE_OUTMOD) OutputArtNetTask(); // TODO: support output
        if(ModuleState == MODSTATE_INMOD) InputArtNetTask();
    }

    return (EXIT_SUCCESS);
}

static void InitAppConfig(void) {
    // Start out zeroing all AppConfig bytes to ensure all fields are
    // deterministic for checksum generation
    memset((void*)&AppConfig, 0x00, sizeof(AppConfig));

    AppConfig.Flags.bIsDHCPEnabled = FALSE;
    AppConfig.Flags.bInConfigMode = FALSE;
    memcpypgm2ram((void*)&AppConfig.MyMACAddr, (ROM void*)SerializedMACAddress, sizeof(AppConfig.MyMACAddr));
    AppConfig.MyIPAddr.Val = MY_DEFAULT_IP_ADDR_BYTE1 | MY_DEFAULT_IP_ADDR_BYTE2<<8ul | MY_DEFAULT_IP_ADDR_BYTE3<<16ul | MY_DEFAULT_IP_ADDR_BYTE4<<24ul;
    AppConfig.DefaultIPAddr.Val = AppConfig.MyIPAddr.Val;
    AppConfig.MyMask.Val = MY_DEFAULT_MASK_BYTE1 | MY_DEFAULT_MASK_BYTE2<<8ul | MY_DEFAULT_MASK_BYTE3<<16ul | MY_DEFAULT_MASK_BYTE4<<24ul;
    AppConfig.DefaultMask.Val = AppConfig.MyMask.Val;
    AppConfig.MyGateway.Val = MY_DEFAULT_GATE_BYTE1 | MY_DEFAULT_GATE_BYTE2<<8ul | MY_DEFAULT_GATE_BYTE3<<16ul | MY_DEFAULT_GATE_BYTE4<<24ul;
    AppConfig.PrimaryDNSServer.Val = MY_DEFAULT_PRIMARY_DNS_BYTE1 | MY_DEFAULT_PRIMARY_DNS_BYTE2<<8ul  | MY_DEFAULT_PRIMARY_DNS_BYTE3<<16ul  | MY_DEFAULT_PRIMARY_DNS_BYTE4<<24ul;
    AppConfig.SecondaryDNSServer.Val = MY_DEFAULT_SECONDARY_DNS_BYTE1 | MY_DEFAULT_SECONDARY_DNS_BYTE2<<8ul  | MY_DEFAULT_SECONDARY_DNS_BYTE3<<16ul  | MY_DEFAULT_SECONDARY_DNS_BYTE4<<24ul;
    memcpypgm2ram(AppConfig.NetBIOSName, (ROM void*)MY_DEFAULT_HOST_NAME, 16);
    FormatNetBIOSName(AppConfig.NetBIOSName);
}

void AssemblePollReplyPacket(struct ArtPollReply *PktPollReply) {
    strcpy(PktPollReply->ID, "Art-Net");
    PktPollReply->OpCode = OpPollReply;
    PktPollReply->IPAddress[0] = 2;  // TODO: make this the real IP
    PktPollReply->IPAddress[1] = 0;
    PktPollReply->IPAddress[2] = 0;
    PktPollReply->IPAddress[3] = 3;
    PktPollReply->Port = 0x1936;
    PktPollReply->VersInfo = FIRMWARE_VERSION;
    PktPollReply->NetSwitch = 0; // FIXME: fix this
    PktPollReply->SubSwitch = 0; // FIXME: fix this
    PktPollReply->Oem = 0; // FIXME: fix this
    PktPollReply->UbeaVersion = 0;
    PktPollReply->Status1 = PollStatusIndicatorNormal;
    PktPollReply->EstaMan = ESTA_MFG_CODE;
    strcpy(PktPollReply->ShortName, "StrichLux IO-ETH");
    strcpy(PktPollReply->LongName, "StrichLux IO-ETH");
    PktPollReply->NodeReport[0] = 0;
    PktPollReply->NumPortsHi = 0;
    PktPollReply->NumPortsLo = 4;  // TODO: flexible multiport support
    PktPollReply->PortTypes[0] = PortTypeArtNet;
    PktPollReply->GoodInput[0] = PortGoodReceiving;
    PktPollReply->GoodOutput[0] = PortGoodSending;
    PktPollReply->PortTypes[1] = PortTypeArtNet;
    PktPollReply->GoodInput[1] = PortGoodReceiving;
    PktPollReply->GoodOutput[1] = PortGoodSending;
    PktPollReply->PortTypes[2] = PortTypeArtNet;
    PktPollReply->GoodInput[2] = PortGoodReceiving;
    PktPollReply->GoodOutput[2] = PortGoodSending;
    PktPollReply->PortTypes[3] = PortTypeArtNet;
    PktPollReply->GoodInput[3] = PortGoodReceiving;
    PktPollReply->GoodOutput[3] = PortGoodSending;
    PktPollReply->SwIn[0] = SUB_UNI_BASE;  // FIXME: figure out a better way of handling subscriptions
    PktPollReply->SwOut[0] = SUB_UNI_BASE;
    PktPollReply->SwIn[1] = SUB_UNI_BASE+1;
    PktPollReply->SwOut[1] = SUB_UNI_BASE+1;
    PktPollReply->SwIn[2] = SUB_UNI_BASE+2;
    PktPollReply->SwOut[2] = SUB_UNI_BASE+2;
    PktPollReply->SwIn[3] = SUB_UNI_BASE+3;
    PktPollReply->SwOut[3] = SUB_UNI_BASE+3;
    PktPollReply->SwVideo = 0x00;
    PktPollReply->SwMacro = 0x00;
    PktPollReply->SwRemote = 0x00;
    PktPollReply->Style = StNode;
    PktPollReply->MAC[0] = (uint8_t)MY_DEFAULT_MAC_BYTE1;
    PktPollReply->MAC[1] = (uint8_t)MY_DEFAULT_MAC_BYTE2;
    PktPollReply->MAC[2] = (uint8_t)MY_DEFAULT_MAC_BYTE3;
    PktPollReply->MAC[3] = (uint8_t)MY_DEFAULT_MAC_BYTE4;
    PktPollReply->MAC[4] = (uint8_t)MY_DEFAULT_MAC_BYTE5;
    PktPollReply->MAC[5] = (uint8_t)MY_DEFAULT_MAC_BYTE6;
    PktPollReply->BindIp[0] = 0;
    PktPollReply->BindIndex = 0;
    PktPollReply->Status2 = PollStatus2ManualIP;
}

void InputArtNetTask(void) {
    if(UDPIsOpened(UdpReceiver) && UDPIsGetReady(UdpReceiver) > 0) {
        PacketLen = UDPIsGetReady(UdpReceiver);
        InPacketBuffer = malloc(PacketLen);
        rv = UDPGetArray(InPacketBuffer, PacketLen);
        // only continue if it has the proper Art-Net magic bytes
        if(strncmp(InPacketBuffer, "Art-Net", 7) != 0) {
            free(InPacketBuffer);
            return;
        };
        OpCode = (uint16_t *)InPacketBuffer+4;
        switch(*OpCode) {
            case OpPoll:
                //PktPollReply = malloc(sizeof(struct ArtPollReply));
                AssemblePollReplyPacket(&PktPollReply);
                UdpSender = UDPOpenEx((DWORD)&UDPSocketInfo[UdpReceiver].remote.remoteNode, UDP_OPEN_NODE_INFO, 6454, UDPSocketInfo[UdpReceiver].localPort);
                UDPIsPutReady(UdpSender);
                UDPPutArray(&PktPollReply, sizeof(struct ArtPollReply));
                UDPFlush();
                UDPClose(UdpSender);
                //free(PktPollReply);
                break;
            case OpDmx:
                Universe = InPacketBuffer[14];
                SPISlaveSelect(1);
                putcSPI2(CORE_CMD_TAKEOVER);
                putcSPI2(Universe + 1);
                SPISlaveSelect(0);
                DelayMs(1); // FIXME: just here for debugging
                DmxBuffer = OpCode+5;
                DmxBuffer--;
                *DmxBuffer = 0x00;
                DmxBuffer--;
                *DmxBuffer = CORE_CMD_WRITE;
                // FIXME: remove 512 hardcodedness
                SPISlaveSelect(1);
                putsSPI2(512, (unsigned int *)DmxBuffer);
                SPISlaveSelect(0);
                break;
        }
        free(InPacketBuffer);
    }
}

void NegotiateModulePosition(void) {
    BYTE    LocStatus;

    // the CORE can take up to 25mS to start up, so give it some time
    DelayMs(50);

    // do a GETVER to verify we're actually connected
    // also make sure protocol version is at least what we need
    SPISlaveSelect(1);
    putcSPI2(CORE_CMD_GETVER);
    getcSPI2(); // throw away the result
    putcSPI2(0xFF);
    CoreProtoVer = getcSPI2();
    SPISlaveSelect(0);
    if(CoreProtoVer < CORE_MIN_PROTO_VER || CoreProtoVer == 255) {
        // CORE is not connected, or firmware on it is too old
        ModuleState = MODSTATE_FAULT;
        // ModuleSlot is displayed on the LED, so use it as an error code
        ModuleSlot = (CoreProtoVer==0 || CoreProtoVer==255 ? 0 : 0);
        while(1)
            LEDTask();
    }

    SPISlaveSelect(1);
    putcSPI2(CORE_CMD_GETLOC);
    getcSPI2(); // throw away the result
    putcSPI2(0xFF);
    LocStatus = getcSPI2();
    SPISlaveSelect(0);
    ModuleSlot = (LocStatus & 0b00001110) >> 1;
    if(LocStatus & 0b00000001)
        ModuleState = MODSTATE_OUTMOD;
    else
        ModuleState = MODSTATE_INMOD;
}

static void SPISlaveSelect(BYTE selected) {
    // wait until any transmissions are done before changing the nSS state
    while(SPI2STATbits.SPIBUSY) {}
    DelayMs(1);  // FIXME: just here for debugging
    if(selected)
        PORTClearBits(SPI_NSS_PORT, SPI_NSS_PIN);
    else
        PORTSetBits(SPI_NSS_PORT, SPI_NSS_PIN);
}