/* 
 * File:   StatusLEDs.h
 * Author: sarahemm
 *
 * Created on July 1, 2012, 10:30 AM
 */

#ifndef STATUSLEDS_H
#define	STATUSLEDS_H

#ifdef	__cplusplus
extern "C" {
#endif

BYTE NumericLEDSegs[16];
BYTE NumericLEDPorts[8];
BYTE NumericLEDPins[8];

void SetStatusLED(BYTE);
void setNumericLED(BYTE);
void LEDInit(void);
void LEDTask(void);

// possible colours for the main status LED
#define LED_COLOUR_RED          0x01
#define LED_COLOUR_GREEN        0x02
#define LED_COLOUR_YELLOW       0x03

// main status LED, bicolour red/green
#define LED_R_PORT		IOPORT_B
#define LED_R_PIN		BIT_13
#define LED_G_PORT		IOPORT_B
#define LED_G_PIN		BIT_12

// info display, 7 segment w/ DP
#define LEDSEG_A_PORT           IOPORT_B
#define LEDSEG_A_PIN            BIT_4
#define LEDSEG_B_PORT           IOPORT_B
#define LEDSEG_B_PIN            BIT_5
#define LEDSEG_C_PORT           IOPORT_E
#define LEDSEG_C_PIN            BIT_1
#define LEDSEG_D_PORT           IOPORT_E
#define LEDSEG_D_PIN            BIT_2
#define LEDSEG_E_PORT           IOPORT_E
#define LEDSEG_E_PIN            BIT_3
#define LEDSEG_F_PORT           IOPORT_B
#define LEDSEG_F_PIN            BIT_3
#define LEDSEG_G_PORT           IOPORT_B
#define LEDSEG_G_PIN            BIT_2
#define LEDSEG_DP_PORT          IOPORT_E
#define LEDSEG_DP_PIN           BIT_4

#ifdef	__cplusplus
}
#endif

#endif	/* STATUSLEDS_H */

