#include <TCPIP Stack/Tick.h>
#include <StrichLuxIOETH.h>
#include <StatusLEDs.h>

void SetStatusLED(BYTE colour) {
if(colour & LED_COLOUR_RED)
        PORTSetBits(LED_R_PORT, LED_R_PIN);
    else
        PORTClearBits(LED_R_PORT, LED_R_PIN);
    
    if(colour & LED_COLOUR_GREEN)
        PORTSetBits(LED_G_PORT, LED_G_PIN);
    else
        PORTClearBits(LED_G_PORT, LED_G_PIN);
}

void SetNumericLED(BYTE number) {
    BYTE    LitSegs;
    BYTE    i;

    LitSegs = NumericLEDSegs[number];
    for(i=0; i<8; i++) {
        if(LitSegs & 1<<i)
            PORTClearBits(NumericLEDPorts[i], NumericLEDPins[i]);
        else
            PORTSetBits(NumericLEDPorts[i], NumericLEDPins[i]);
    }

}

void LEDInit(void) {
    BYTE i;

    // set up the 7 segment LED decoder array
    NumericLEDSegs[0x00] = 0b00111111;
    NumericLEDSegs[0x01] = 0b00000110;
    NumericLEDSegs[0x02] = 0b01011011;
    NumericLEDSegs[0x03] = 0b01001111;
    NumericLEDSegs[0x04] = 0b01100110;
    NumericLEDSegs[0x05] = 0b01101101;
    NumericLEDSegs[0x06] = 0b01111101;
    NumericLEDSegs[0x07] = 0b00000111;
    NumericLEDSegs[0x08] = 0b01111111;
    NumericLEDSegs[0x09] = 0b01101111;
    NumericLEDSegs[0x0A] = 0b01110111;
    NumericLEDSegs[0x0B] = 0b01111100;
    NumericLEDSegs[0x0C] = 0b00111001;
    NumericLEDSegs[0x0D] = 0b00111110;
    NumericLEDSegs[0x0E] = 0b01111001;
    NumericLEDSegs[0x0F] = 0b01110001;

    // set up the arrays of ports and pins for the numeric display
    NumericLEDPorts[0] = LEDSEG_A_PORT;
    NumericLEDPorts[1] = LEDSEG_B_PORT;
    NumericLEDPorts[2] = LEDSEG_C_PORT;
    NumericLEDPorts[3] = LEDSEG_D_PORT;
    NumericLEDPorts[4] = LEDSEG_E_PORT;
    NumericLEDPorts[5] = LEDSEG_F_PORT;
    NumericLEDPorts[6] = LEDSEG_G_PORT;
    NumericLEDPorts[7] = LEDSEG_DP_PORT;
    NumericLEDPins[0] = LEDSEG_A_PIN;
    NumericLEDPins[1] = LEDSEG_B_PIN;
    NumericLEDPins[2] = LEDSEG_C_PIN;
    NumericLEDPins[3] = LEDSEG_D_PIN;
    NumericLEDPins[4] = LEDSEG_E_PIN;
    NumericLEDPins[5] = LEDSEG_F_PIN;
    NumericLEDPins[6] = LEDSEG_G_PIN;
    NumericLEDPins[7] = LEDSEG_DP_PIN;

    // set up all the TRISes
    PORTSetPinsDigitalOut(LED_R_PORT, LED_R_PIN);
    PORTSetPinsDigitalOut(LED_G_PORT, LED_G_PIN);
    for(i=0; i<8; i++)
        PORTSetPinsDigitalOut(NumericLEDPorts[i], NumericLEDPins[i]);
}

void LEDTask(void) {
    // update the red/green LED with the module role
    switch(ModuleState) {
        case MODSTATE_INIT:
            if(TickGet() / TICK_SECOND % 2)
                SetStatusLED(LED_COLOUR_GREEN);
            else
                SetStatusLED(LED_COLOUR_RED);
            break;
        case MODSTATE_INMOD:
            SetStatusLED(LED_COLOUR_GREEN);
            break;
        case MODSTATE_OUTMOD:
            SetStatusLED(LED_COLOUR_YELLOW);
            break;
        default:
            SetStatusLED(LED_COLOUR_RED);
    }
    // update the 7-segment display with the slot
    // TODO: later this should display a lot more info, IP and such
    SetNumericLED(ModuleSlot);
}