; ECH 0.1, like ECHO, but don't print a trailing newline
; Copyright (C) 2018, Seth Simon (sethsimon@sdf.org)
;
; This program is free software: you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation, either version 3 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program.  If not, see <https://www.gnu.org/licenses/>.
;
    org     0x100
    cpu     8086
fakestart:
    jmp     start
; Since no help is offered if the argument is "/?", 'type'ing the
; file should provide some information:
times $ - fakestart db 8    ; Backspace over music/faces/etc
db "ECH 0.1, like ECHO, but don't print a trailing newline.",13,10
db "Copyright (C) 2018, Seth Simon (sethsimon@sdf.org).",13,10
db 13,10
db "This program comes with ABSOLUTELY NO WARRANTY. This is free",13,10
db "software, and you are welcome to redistribute it under certain",13,10
db "conditions; see the GNU GPLv3 for details.",13,10
db 13,10
db "Usage: ech [arguments]"
db 0x1a

start:
    ; Command tail is a Pascal-style string at 0x80, with an 0xd
    ; appended (not included in the length)
    cld
    mov     ch, -1
    mov     di, 0x81
    mov     al, ' '
    repe    scasb
    lea     si, [di - 1]        ; SI is first nonspace

    mov     al, 0xd
    repne   scasb
    dec     di
    jmp     .trimbottom
.trim:
    mov     byte [di], 0xd
.trimbottom:
    dec     di
    cmp     byte [di], ' '
    je      .trim

    jmp     .loopbottom
.loop:
    xchg    ax, dx
    mov     ah, 2
    int     0x21
.loopbottom:
    lodsb
    cmp     al, 0xd
    jne     .loop
    ret

