#!/usr/pkg/bin/tclsh
#
# Blopher - Converts a Blosxom based Blog into a Gopher readable Phlog
#
# Copyright (C) 2011  Jeff Parent <jecxjo@sdf.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
# 
# Version: 0.0.1
# 

#### Configuration Parameters ####
set blogTitle "Blog Title"
set blogDir "/var/blog"
set entryExtension "*.txt"

#####################################################################
######## Application Code - No need to edit below this point ########
#####################################################################

set version "0.0.1"
set ending "		error.host	1"

proc findFiles { basedir pattern } {
  set basedir [string trimright [file join [file normalize $basedir] { }]]
  set fileList {}

  foreach fileName [glob -nocomplain -type {f r} -path $basedir $pattern] {
    lappend fileList $fileName
  }

  foreach dirName [glob -nocomplain -type {d r} -path $basedir *] {
    set subDirList [findFiles $dirName $pattern]
    if { [llength $subDirList] > 0 } {
      foreach subDirFile $subDirList {
        lappend fileList $subDirFile
      }
    }
  }
  return $fileList
}

proc sortFiles { fileList } {
  proc compareFileTimes { first second } {
    set one [file mtime $first]
    set two [file mtime $second]

    if { $one > $two } { return 1 }
    if { $one < $two } { return -1 }
    return 0
  }
  set sortedList [lsort -decreasing -command compareFileTimes $fileList]
    return $sortedList
}

proc HMparse_html {html {cmd HMtest_parse} {start hmstart}} {
  regsub -all \{ $html {\&ob;} html
  regsub -all \} $html {\&cb;} html
  set w " \t\r\n"        ;# white space
  proc HMcl x {return "\[$x\]"}
  set exp <(/?)([HMcl ^$w>]+)[HMcl $w]*([HMcl ^>]*)>
  set sub "\}\n$cmd {\\2} {\\1} {\\3} \{"
  regsub -all $exp $html $sub html
  eval "$cmd {$start} {} {} \{$html \}"
  eval "$cmd {$start} / {} {}"
}

proc HMtest_parse {tag state props body} {
  if {$state == ""} {
    set msg "Start $tag"
    if {$props != ""} {
      set msg "$msg with args: $props"
    }
    set msg "$msg\n$body"
  } else {
    set msg "End $tag"
  }
  puts $msg
}

proc tagConvert {tag state props body} {
	global ending
	set endTag 0

  if {$state == ""} {
    switch $tag {
      "hmstart" {
        set msg "$body"
      }
      "br" {
        set msg "\n$body"
      }
      "a" {
        set msg ""
      }
      "img" {
        set msg ""
      }
      "b" {
        set msg "*$body"
      }
      "p" {
        set msg "\n$body"
      }
      default {
        set msg ""
      }
    }
  } else {
    switch $tag {
      "hmstart" {
        set msg "--------------------\n"
				set endTag 1
      }
      "br" {
        set msg "\n$body"
      }
      "a" {
        set msg ""
      }
      "img" {
        set msg ""
      }
      "b" {
        set msg "*$body"
      }
      "p" {
        set msg "\n$body"
      }
      default {
        #set msg "</$tag>$body"
        set msg ""
      }
    }
  }

	if {$endTag == 0} {
		set msg [string map {"\n" "		error.host	1\ni"} "$msg"]
	} else {
		set msg [string map {"\n" "		error.host	1\n"} "$msg"]
	}
	
  puts -nonewline "$msg"
}

proc displayEntry { entry } {
  set writeDate [clock format [file mtime $entry] -format %x]
  set entryFile [open "$entry" r]
  set title [gets $entryFile]
	global ending

  puts "i$ending"
  puts "i$title - $writeDate$ending"
  puts "i$ending"
	puts -nonewline "i"
  set entryBody [read $entryFile]

  HMparse_html $entryBody tagConvert

  #puts "--------------------$ending"
}

set blogEntries [findFiles $blogDir $entryExtension]

set sortedEntries [sortFiles $blogEntries]


puts "i$blogTitle$ending"
puts "i--------------------$ending"

foreach entry $sortedEntries {
  displayEntry $entry
}

puts "i$ending"
puts "i$ending"
puts "1Powered by Blopher ($version)	/users/jecxjo/projects/blopher	sdf.org	70"
