/*
 * Decompiled with CFR 0.152.
 */
package org.qcontinuum.gpstrack;

import henson.midp.Float;
import org.qcontinuum.astro.Astrometric;
import org.qcontinuum.astro.EarthPosition;
import org.qcontinuum.astro.EclipticPosition;
import org.qcontinuum.astro.EquitorialPosition;
import org.qcontinuum.astro.HorizontalPosition;
import org.qcontinuum.astro.UtcDate;
import org.qcontinuum.gpstrack.Gps;
import org.qcontinuum.gpstrack.GpsTrack;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AstroInformation
implements Runnable {
    private HorizontalPosition a;
    private HorizontalPosition b = null;
    private Float a;
    private EarthPosition a = null;

    public AstroInformation() {
        new Thread(this).start();
    }

    public HorizontalPosition getSunPosition() {
        return this.a;
    }

    public HorizontalPosition getMoonPosition() {
        return this.b;
    }

    public Float getMoonPhase() {
        return this.a;
    }

    public void run() {
        Thread.currentThread();
        try {
            while (true) {
                Thread.sleep(this.a == null ? 5000L : 60000L);
                Gps gps = GpsTrack.getGps();
                if (gps == null || !gps.getFix()) continue;
                EarthPosition earthPosition = gps.getEarthPosition();
                UtcDate utcDate = gps.getUTCDate();
                if (this.a != null && this.a.getDistance(earthPosition).Less(100000L)) continue;
                this.recalculate(earthPosition, utcDate);
                this.a = earthPosition;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void recalculate(EarthPosition earthPosition, UtcDate utcDate) {
        Float float_ = utcDate.getMJD();
        EclipticPosition eclipticPosition = Astrometric.sunPosition(float_);
        EquitorialPosition equitorialPosition = eclipticPosition.toEquitorialPosition();
        this.a = equitorialPosition.toHorizontalPosition(earthPosition, float_);
        EclipticPosition eclipticPosition2 = Astrometric.moonPosition(float_);
        EquitorialPosition equitorialPosition2 = eclipticPosition2.toEquitorialPosition();
        this.b = equitorialPosition2.toHorizontalPosition(earthPosition, float_);
        Float float_2 = eclipticPosition.getLongitude().Sub(eclipticPosition2.getLongitude());
        this.a = Float.cos(Float.PI.Sub(float_2)).Add(new Float(1L)).Div(new Float(2L));
    }
}

