/*
 * CryptoStream.java
 *
 * Created on den 21 mars 2006, 21:20
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package ftpmid;
import java.io.*;
import org.bouncycastle.crypto.StreamBlockCipher;
import org.bouncycastle.crypto.StreamCipher;
//import org.bouncycastle.crypto.engines.AESLightEngine;
//import org.bouncycastle.crypto.engines.AESEngine;
//import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
//import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.DataLengthException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;

/**
 *
 * @author ERASBED
 */
public class CryptoStream implements FtpFilterStream {
    private final static boolean DEBUG = false;
    private final static int KEY_SIZE = 128;
    private final static int RANDOM_BLOCK_SIZE = 16; // in bytes = 128 bits
    private final static int PREFERRED_BUFFER_SIZE = 4096;
    private final static int MIN_PWD_LENGTH = 6;
    private final static String PWD_TOO_SHORT = "Password need to be at least 6 characters long";
    private final static String CRYPTO_FILE_SUFFIX = ".mcrp";
    private final static String NOT_ENCRYPTED = "Not an encrypted file.";
    private final static String COULD_NOT_DECRYPT = "Could not decrypt file. Either this is not an encrypted file or file is encrypted with another password.";
    private final static String DIRECTORY_ERROR = "Can not encrypt/decrypt a directory";
    private final static String CRYPTO_ENGINE_ERROR = "Error initiating cryptographic engine";
    
//    private KeyParameter key = null;
//    private AESLightEngine blockCipher = null;
    private BlowfishEngine blockCipher = null;
    private CFBBlockCipher cfbCipher = null;
    private StreamCipher streamCipher = null;
    private boolean encrypt;
//    private FileSystem fileSystem = null;
    private OutputStream outputStream = null;
    private byte[] cipherData = null;
    private String pwd = null;
    private boolean alreadyReset = false;
    private boolean newFile = true;
    private SecureRandom mSecureRandom = null;
    private int randomBlockSize;
    
//    private FileSystemLocal localFileSystem = null;
    
    public CryptoStream(String pwd, boolean encrypt) throws FtpErrorException  {
        
        this.encrypt = encrypt;
        this.pwd = pwd;
        if (pwd.length() < MIN_PWD_LENGTH)
            throw new FtpErrorException(PWD_TOO_SHORT);
    }
    
    public void init() throws FtpErrorException {
        try {
            /* create the CipherParameters */
            byte[] salt = {0x03, 0x53, 0x24, 0x78, 0x03, 0x43, 0x17, 0x41};
            PBEParametersGenerator g = new PKCS5S2ParametersGenerator();
            g.init(PBEParametersGenerator.PKCS5PasswordToBytes(pwd.toCharArray()),salt,32);
            CipherParameters key = g.generateDerivedParameters( KEY_SIZE );
            
            mSecureRandom = new SecureRandom();
            
            // Create the cipher.
//            key = new KeyParameter(pwd.getBytes());
//            blockCipher = new AESLightEngine();
            blockCipher = new BlowfishEngine();
//            randomBlockSize = blockCipher.getBlockSize();
            randomBlockSize = RANDOM_BLOCK_SIZE;
//            System.out.println("blockCipher.getBlockSize() = "+blockCipher.getBlockSize());
            cfbCipher = new CFBBlockCipher(blockCipher, 8);
            streamCipher = new StreamBlockCipher(cfbCipher);
            
            cipherData = new byte[PREFERRED_BUFFER_SIZE];
            streamCipher.init(encrypt, key);
            alreadyReset = true;
        } catch (Exception e) {
            if (DEBUG) {
                System.out.println(e.getMessage());
                System.out.println(e.toString());
                e.printStackTrace();
            }
            throw new FtpErrorException(CRYPTO_ENGINE_ERROR);
        }
    }
    
    public void revert() {
        // ugly fix. Correct later
        encrypt = true;
//        encrypt = !encrypt;
    }
    
    public boolean isReadMode() {
        return false;  // CryptoStream always used in write mode
    }
    
    
//    public void reset(FtpOutputStream outputStream) throws FtpIOException, FtpErrorException {
    public void reset(OutputStream outputStream) throws IOException {
        java.lang.System.gc();
        if (!alreadyReset)
            streamCipher.reset();
        else
            alreadyReset = false;
        this.outputStream = outputStream;
        
        if (encrypt) {
            writeRandomBitsAndPwd();
        } else {
            newFile = true;
        }
    }
    
    private void writeRandomBitsAndPwd() throws IOException {
        
        // Create an IV of random data.
        
        byte[] iv = new byte[randomBlockSize];
        try {
            mSecureRandom.nextBytes(iv);
        } catch (Exception e) {
            if (DEBUG) {
                System.out.println(e.getMessage());
                System.out.println(e.toString());
                e.printStackTrace();
            }
            throw new IOException(CRYPTO_ENGINE_ERROR);
        }
        
        // Concatenate the IV and the message.
//        byte[] pwdBytes = pwd.getBytes("UTF8");
        byte[] pwdBytes = pwd.getBytes();
        int length = randomBlockSize + pwdBytes.length;
        byte[]  finalByteArray = new byte[length];
        System.arraycopy(iv, 0, finalByteArray, 0, iv.length);
        System.arraycopy(pwdBytes, 0, finalByteArray, iv.length, pwdBytes.length);
        
        // Encrypt and write the finalByteArray
        write(finalByteArray, 0, length);
        
    }
    
    private String readRandomBitsAndPwd() throws FtpErrorException, FtpIOException {
        return null;
    }
    
    
    
    public FtpItem getFilteredFtpItem(FtpItem f) throws FtpErrorException {
        FtpItem newItem;
        if (f.isDirectory()) {
            throw new FtpErrorException(DIRECTORY_ERROR);
        }
        
        if (!encrypt) {
            if (!isEncrypted(f)) {
                throw new FtpErrorException(NOT_ENCRYPTED);
            }
            newItem = new FtpItem(f.name.substring(0, f.name.length() - CRYPTO_FILE_SUFFIX.length()), FtpListResult.FILE);
        } else {
            newItem = new FtpItem(f.name+CRYPTO_FILE_SUFFIX, FtpListResult.FILE);
        }
        return newItem;
    }
    
    public static boolean isEncrypted(FtpItem ftpItem) {
        return ftpItem.name.endsWith(CRYPTO_FILE_SUFFIX);
    }
    
    public void write(byte b[],int off,int len) throws IOException {
        try {
            if (DEBUG)
                System.out.println("CryptoEngine.write() About to process bytes. b.length="+b.length+" len="+len+" cipherData.length="+cipherData.length);
            streamCipher.processBytes(b, off,len, cipherData, 0);
            
        /* If decrypting a file and this is the first time we are getting a byte array from the
         * encrypted file (i.e it's a new file) then discard the random bits and read and compare
         * the password
         */
            int length = 0;
            if (!encrypt && newFile) {
                byte[] pwdBytes = pwd.getBytes();
                length = randomBlockSize + pwdBytes.length;
                if (length > len)
                    throw new IOException(COULD_NOT_DECRYPT);
                else {
                    String storedPwd = new String(cipherData, randomBlockSize, pwdBytes.length);
                    if (!storedPwd.equals(pwd))
                        throw new IOException(COULD_NOT_DECRYPT);
                }
                newFile = false;
            }
            if (DEBUG)
                System.out.println("CryptoEngine.write() About to write chipher text. b.length="+b.length+" len="+len+" length="+length+" cipherData.length="+cipherData.length);
            outputStream.write(cipherData, length, len-length);
            if (DEBUG)
                System.out.println("CryptoEngine.write() Just wrote a chipher text");
        } catch (DataLengthException e) {
            if (DEBUG) {
                System.out.println(e.getMessage());
                System.out.println(e.toString());
                e.printStackTrace();
            }
            throw new IOException(CRYPTO_ENGINE_ERROR);
        }
    }
    
    public void close() throws IOException {
        outputStream.close();
    }
    
    public void flush() throws IOException {
        outputStream.flush();
    }
    
    public int getPrefferedBufferSize() {
        return PREFERRED_BUFFER_SIZE;
    }
    
    public int read(byte b[], int off, int len) throws IOException {
        // CryptoStream only used in write mode
        return 0;
    }
    
    public void reset(InputStream in) throws IOException {
        // CryptoStream only used in write mode
    }
}
