/*
 * CryptoStream.java
 *
 * Created on den 21 mars 2006, 21:20
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package ftpmid;
import java.io.*;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.StreamBlockCipher;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.AESLightEngine;
//import org.bouncycastle.crypto.engines.AESEngine;
//import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.DataLengthException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.macs.HMac;

/**
 *
 * @author ERASBED
 */
public class CryptoStream implements FtpFilterStream {
    private final static boolean DEBUG = false;//true;
    private final static int KEY_SIZE = 128;
    private final static int RANDOM_BLOCK_SIZE = 16; // in bytes = 128 bits
    private final static int PREFERRED_BUFFER_SIZE = 4096;
    private final static int MIN_PWD_LENGTH = 6;
    private final static String PWD_TOO_SHORT = "Password need to be at least 6 characters long";
    private final static String CRYPTO_FILE_SUFFIX = ".mcrp";
    private final static String NOT_ENCRYPTED = "Not an encrypted file.";
    private final static String COULD_NOT_DECRYPT = "Could not decrypt file. Either this is not an encrypted file or file is encrypted with another password.";
    private final static String DIRECTORY_ERROR = "Can not encrypt/decrypt a directory";
    private final static String CRYPTO_ENGINE_ERROR = "Error initiating cryptographic engine";
    
//    private KeyParameter key = null;
//    private AESLightEngine blockCipher = null;
//    private BlowfishEngine blockCipher = null;
    private BlockCipher blockCipher = null;
    private CFBBlockCipher cfbCipher = null;
    private StreamCipher streamCipher = null;
    private boolean encrypt;
//    private FileSystem fileSystem = null;
    private OutputStream outputStream = null;
    private byte[] cipherData = null;
    private String pwd = null;
    private boolean alreadyReset = false;
    private boolean newFile = true;
    private SecureRandom mSecureRandom = null;
    private int algorithm = -1;
    private int randomBlockSize;

    private int flagSize;
    private int flagOffset;
    private int flagMacSize;
    
//    private FileSystemLocal localFileSystem = null;
    
    public CryptoStream(String pwd, boolean encrypt) throws FtpErrorException  {
        
        this.encrypt = encrypt;
        this.pwd = pwd;
        if (pwd.length() < MIN_PWD_LENGTH)
            throw new FtpErrorException(PWD_TOO_SHORT);
    }
    
    public CryptoStream(String pwd, boolean encrypt,int algorithm) 
	throws FtpErrorException  {
        this(pwd,encrypt);
        this.algorithm = algorithm;
    }

    private boolean initStreamCipher() {

	switch (algorithm) {
	case 0:
	    blockCipher = new BlowfishEngine();
	    break;
	case 1:
	    blockCipher = new AESLightEngine();
	    break;
	case 2:
	    blockCipher = new TwofishEngine();
	    break;
	default:
	    //throw exception
	    //return false;
	    blockCipher = new BlowfishEngine();
	}
	cfbCipher = new CFBBlockCipher(blockCipher, 8);
	streamCipher = new StreamBlockCipher(cfbCipher);
	/* create the CipherParameters */
	byte[] salt = {0x03, 0x53, 0x24, 0x78, 0x03, 0x43, 0x17, 0x41};
	PBEParametersGenerator g = new PKCS5S2ParametersGenerator();
	g.init(PBEParametersGenerator.PKCS5PasswordToBytes(pwd.toCharArray()),
	       salt,32);
	CipherParameters key = g.generateDerivedParameters( KEY_SIZE );
	streamCipher.init(encrypt, key);
	return true;

    }

    private boolean initStreamCipher(int overrideAlgo) {
	if (overrideAlgo == algorithm)
	    return true;
	int tmp=algorithm;
	algorithm=overrideAlgo;
	boolean retVal=initStreamCipher();
	algorithm=tmp;
	return retVal;
    }

    public void init() throws FtpErrorException {
        try {
            
            mSecureRandom = new SecureRandom();
            
            // Create the cipher.
	    initStreamCipher();

            randomBlockSize = RANDOM_BLOCK_SIZE;
	    flagOffset=6;
	    flagSize=4;
	    flagMacSize=randomBlockSize-flagOffset-flagSize;

            cipherData = new byte[PREFERRED_BUFFER_SIZE];
            alreadyReset = true;
        } catch (Exception e) {
            if (DEBUG) {
                System.out.println(e.getMessage());
                System.out.println(e.toString());
                e.printStackTrace();
            }
            throw new FtpErrorException(CRYPTO_ENGINE_ERROR);
        }
    }
    
    public void revert() {
        // ugly fix. Correct later
        encrypt = true;
//        encrypt = !encrypt;
    }
    
    public boolean isReadMode() {
        return false;  // CryptoStream always used in write mode
    }
    
    
//    public void reset(FtpOutputStream outputStream) throws FtpIOException, FtpErrorException {
    public void reset(OutputStream outputStream) throws IOException {
        java.lang.System.gc();
        if (!alreadyReset)
            streamCipher.reset();
        else
            alreadyReset = false;
        this.outputStream = outputStream;
        
        if (encrypt) {
            writeRandomBitsAndPwd();
        } else {
            newFile = true;
        }
    }

    private void mix(byte [] inOut,byte [] key,int length) {
	int i,a,b,c;
	for (i=0;i<length;i++) {
	    a=(int)inOut[0] & 0xff;
	    b=(int)inOut[1] & 0xff;
	    c=(int)(inOut[1]&inOut[2] ^ inOut[1]&inOut[3] ^ inOut[2]&inOut[3])
		& 0xff;
	    a ^= c;
	    b = (256+a-b) & 255;
	    b=((b>>>3) | (b<<5)) & 255;
	    inOut[0]=(byte)a;
	    a=(int)inOut[2] & 0xff;
	    inOut[2]=(byte)b;
	    b=(int)inOut[3] & 0xff;
	    c= (((a^b)+1)*(256-((int)key[i]&0xff))) % 257;
	    c -= 1;
	    a ^= c;
	    b ^= c;
	    inOut[1]=(byte)a;
	    inOut[3]=(byte)b;
	}

    }

    private void remix(byte [] inOut, byte [] key,int length) {
	int i,a,b,c;
	for (i=length-1;i>=0;i--) {
	    a=(int)inOut[1] & 0xff;
	    b=(int)inOut[3] & 0xff;
	    c = a^b;
	    c = ((c+1)*(256-((int)key[i]&0xff))) % 257;
	    c -= 1;
	    a ^= c;
	    b ^= c;
	    inOut[3]=(byte)b;
	    b = (int)inOut[2] & 0xff;
	    inOut[2]=(byte)a;
	    b = ((b>>>5) | (b<<3)) & 255;
	    a = (int)inOut[0] & 0xff;
	    b = (256+a-b) & 255;
	    inOut[1]=(byte)b;
	    c=(int)(inOut[1]&inOut[2] ^ inOut[1]&inOut[3] ^ inOut[2]&inOut[3])
		& 0xff;
	    a ^= c;
	    inOut[0] = (byte)a;
	}

    }

    private void writeRandomBitsAndPwd() throws IOException {
        
        // Create an IV of random data.
        
      int i;
        byte[] iv = new byte[randomBlockSize];
        byte[] ov = new byte[randomBlockSize];
	byte[] flags = new byte[flagSize+flagMacSize];
        try {
	  mSecureRandom.nextBytes(iv);
	  streamCipher.processBytes(iv, 0,flagOffset, ov, 0);
	  streamCipher.reset();
	  flags[3] = (byte)algorithm;
	  mix(flags,ov,flagOffset);
	  byte kb[]=
	      PBEParametersGenerator.PKCS12PasswordToBytes(pwd.toCharArray());
	  System.arraycopy(flags,0,ov,0,flagSize);
	  mix(ov,kb,kb.length);
	  System.arraycopy(ov,0,flags,flagSize,flagSize);
	  mix(ov,kb,kb.length);
	  System.arraycopy(ov,0,flags,2*flagSize,flagMacSize-flagSize);

	  for (i=0;i<flagSize+flagMacSize;i++) {
	    streamCipher.processBytes(iv, 0,i+1+flagOffset, ov, 0);
	    iv[i+flagOffset] ^= (byte)(ov[i+flagOffset] ^ flags[i]);
	    streamCipher.reset();
	  }

        } catch (Exception e) {
            if (DEBUG) {
                System.out.println(e.getMessage());
                System.out.println(e.toString());
                e.printStackTrace();
            }
            throw new IOException(CRYPTO_ENGINE_ERROR);
        }

        if (DEBUG) {
	  System.out.println("flags:");
	  System.out.write(flags);
	}
        // Concatenate the IV and the message.
//        byte[] pwdBytes = pwd.getBytes("UTF8");
        byte[] pwdBytes = pwd.getBytes();
        int length = randomBlockSize + pwdBytes.length;
        byte[]  finalByteArray = new byte[length];
        System.arraycopy(iv, 0, finalByteArray, 0, iv.length);
        System.arraycopy(pwdBytes, 0, finalByteArray, iv.length, pwdBytes.length);
        
        // Encrypt and write the finalByteArray
        write(finalByteArray, 0, length);
        
    }
    
    private String readRandomBitsAndPwd() throws FtpErrorException, FtpIOException {
        return null;
    }
    
    
    
    public FtpItem getFilteredFtpItem(FtpItem f) throws FtpErrorException {
        FtpItem newItem;
        if (f.isDirectory()) {
            throw new FtpErrorException(DIRECTORY_ERROR);
        }
        
        if (!encrypt) {
            if (!isEncrypted(f)) {
                throw new FtpErrorException(NOT_ENCRYPTED);
            }
            newItem = new FtpItem(f.name.substring(0, f.name.length() - CRYPTO_FILE_SUFFIX.length()), FtpListResult.FILE);
        } else {
            newItem = new FtpItem(f.name+CRYPTO_FILE_SUFFIX, FtpListResult.FILE);
        }
        return newItem;
    }
    
    public static boolean isEncrypted(FtpItem ftpItem) {
        return ftpItem.name.endsWith(CRYPTO_FILE_SUFFIX);
    }
    
    public void write(byte b[],int off,int len) throws IOException {
        try {
            if (DEBUG)
                System.out.println("CryptoEngine.write() About to process bytes. b.length="+b.length+" len="+len+" cipherData.length="+cipherData.length);

	    streamCipher.processBytes(b, off,len, cipherData, 0);

        /* If decrypting a file and this is the first time we are getting a byte array from the
         * encrypted file (i.e it's a new file) then check the flags and flag         * mac
         */
            int length = 0;

            if (!encrypt && newFile) {

                length = randomBlockSize;
                if (length > len)
                    throw new IOException(COULD_NOT_DECRYPT);

		byte[] flags = new byte[flagSize+flagMacSize];
		byte[] ov = new byte[flagSize+flagMacSize];
		System.arraycopy(b,flagOffset,flags,0,flagSize);
		remix(flags,b,flagOffset);
		System.arraycopy(b,flagOffset,ov,0,flagSize);
		System.arraycopy(b,flagOffset+flagSize,flags,
				 flagSize,flagMacSize);
		if (DEBUG) {
		    System.out.println("Decrypt flags:");
		    System.out.write(flags);
		    System.out.println(";");
		}
		char pca[]=pwd.toCharArray();
		byte kb[]=PBEParametersGenerator.PKCS12PasswordToBytes(pca);
		mix(ov,kb,kb.length);
		System.arraycopy(ov,0,ov,flagSize,flagSize);
		mix(ov,kb,kb.length);
		System.arraycopy(ov,0,ov,2*flagSize,flagMacSize-flagSize);
		System.arraycopy(flags,0,ov,0,flagSize);
                boolean macTest=true;
                for  (int i=0;i<flags.length;i++)
                    if (ov[i] != flags[i]) {
                        macTest=false;
                        break;
                    }
//		boolean macTest=java.util.Arrays.equals(ov,flags);
		if (macTest) {
		    initStreamCipher((int)(flags[3]&15));
		    streamCipher.processBytes(b, off,len, cipherData, 0);
		}
		if (DEBUG) {
		    if (macTest)
			System.out.println("Flag mac OK");
		    else {
			System.out.println("Flag mac fail!");
			System.out.println("Decrypt flags mac:");
			System.out.write(ov,0,flagSize);
			System.out.println(";");
		    }
		}

            
        /* If decrypting a file and this is the first time we are getting a byte array from the
         * encrypted file (i.e it's a new file) then read and compare
         * the password
         */
                byte[] pwdBytes = pwd.getBytes();
		String storedPwd = new String(cipherData, randomBlockSize, pwdBytes.length);
                length = randomBlockSize + pwdBytes.length;
                if (length > len)
                    throw new IOException(COULD_NOT_DECRYPT);


		if (DEBUG)
		    System.out.println("StoredPwd:"+storedPwd);
		if (!storedPwd.equals(pwd))
		    throw new IOException(COULD_NOT_DECRYPT);
                newFile = false;
            }
            if (DEBUG)
                System.out.println("CryptoEngine.write() About to write cipher text. b.length="+b.length+" len="+len+" length="+length+" cipherData.length="+cipherData.length);
            outputStream.write(cipherData, length, len-length);
            if (DEBUG)
                System.out.println("CryptoEngine.write() Just wrote a cipher text");
        } catch (DataLengthException e) {
            if (DEBUG) {
                System.out.println(e.getMessage());
                System.out.println(e.toString());
                e.printStackTrace();
            }
            throw new IOException(CRYPTO_ENGINE_ERROR);
        }
    }
    
    public void close() throws IOException {
        outputStream.close();
    }
    
    public void flush() throws IOException {
        outputStream.flush();
    }
    
    public int getPrefferedBufferSize() {
        return PREFERRED_BUFFER_SIZE;
    }
    
    public int read(byte b[], int off, int len) throws IOException {
        // CryptoStream only used in write mode
        return 0;
    }
    
    public void reset(InputStream in) throws IOException {
        // CryptoStream only used in write mode
    }
}
