#include "../config.h"
#ifndef HAVE_SCANDIR
/* Copyright (c) CNIDR (see ../COPYRIGHT) */

/*
**  SCANDIR
**  Scan a directory, collecting all (selected) items into a an array.
*/

#include "../ir/cdialect.h"
/* #include <sys/types.h> */
#include <stdio.h>
#include "pdftw.h"

#ifdef	RCSID
static char RCS[] = "$Header: /usr/local/ls6/src+data/src/freeWAIS-0.2-sf/lib/RCS/scandir.c,v 1.1 1994/04/29 23:36:56 pfeifer Exp pfeifer $";
#endif	/* RCSID */

/* Initial guess at directory size. */
#define INITIAL_SIZE	20

/*
extern char		*malloc();
extern char		*realloc();
extern char		*strcpy();
*/
int
scandir(name, list, selector, sorter)
    char		  *name;
    struct dirent		***list;
    int			 (*selector)();
    int			 (*sorter)();
{
    register struct dirent	  **names;
    register struct dirent	  *entp;
    register DIR	  *dirp;
    register int	   i;
    register int	   size;

    /* Get initial list space and open directory. */
    size = INITIAL_SIZE;
    names = (struct dirent **)malloc(size * sizeof names[0]);
    if (names == NULL)
	return -1;
    dirp = opendir(name);
    if (dirp == NULL)
	return -1;

    /* Read entries in the directory. */
    for (i = 0; entp = readdir(dirp); )
	if (selector == NULL || (*selector)(entp)) {
	    /* User wants them all, or he wants this one. */
	    if (++i >= size) {
		size <<= 1;
		names = (struct dirent **)
		    realloc((char *)names, size * sizeof names[0]);
		if (names == NULL) {
		    closedir(dirp);
		    return -1;
		}
	    }

	    /* Copy the entry. */
#ifdef DIRSIZ
	    names[i - 1] = (struct dirent *)malloc(DIRSIZ(entp));
#else
	    names[i - 1] = (struct dirent *)malloc(sizeof(struct dirent) 
					        + strlen(entp->d_name)+1);
#endif
	    if (names[i - 1] == NULL) {
		closedir(dirp);
		return -1;
	    }
	    names[i - 1]->d_ino = entp->d_ino;
	    names[i - 1]->d_reclen = entp->d_reclen;
#ifndef DIRENT
	    names[i - 1]->d_namlen = entp->d_namlen;
#endif
	    (void)strcpy(names[i - 1]->d_name, entp->d_name);
	}

    /* Close things off. */
    names[i] = NULL;
    *list = names;
    closedir(dirp);

    /* Sort? */
    if (i && sorter)
	qsort((char *)names, i, sizeof names[0], sorter);

    return i;
}
#endif /* HAVE_SCANDIR */
