/*                             -*- Mode: C -*- 
 * query_y.y -- 
 * ITIID           : $ITI$ $Header $__Header$
 * Author          : Ulrich Pfeifer
 * Created On      : Tue Feb 15 16:11:56 1994
 * Last Modified By: Ulrich Pfeifer
 * Last Modified On: Fri Apr 29 22:47:00 1994
 * Update Count    : 247
 * Status          : Unknown, Use with caution!
 */

%{
#include "cutil.h"
#include <stdio.h>
/* #include <string.h> */
#include <ctype.h>
/*
extern char *malloc();
extern char *calloc();
*/
#define YYSTYPE yystype
#define strcatXC(A,B)  strcatCC((A),(B)),free(A)
#define strcatCX(A,B)  strcatCC((A),(B)),free(B)
#define strcatXX(A,B)  strcatCC((A),(B)),free(A),free(B)
#define strcatXXC(A,B,C) strcatCCC((A),(B),(C)),free(A),free(B)
#define strcatCCX(A,B,C) strcatCCC((A),(B),(C)),free(C)
#define strcatXXX(A,B,C) strcatCCC((A),(B),(C)),free(A),free(B),free(C)
#define strcatXCX(A,B,C) strcatCCC((A),(B),(C)),free(A),free(C)
#define strcatCCXX(A,B,C,D) strcatCCCC((A),(B),(C),(D)),free(C),free(D)
#define strcatXCXX(A,B,C,D) strcatCCCC((A),(B),(C),(D)),free(A),free(C),free(D)

extern int yylineno;
extern char yytext[];
#ifdef YYBISON
int yydebug;
#else
extern int yydebug;
#endif
static int yyverbose = 0;
static int yyboolean = 0;
static int numeric_field = 0;
static int global_dct_exists = 0;
char *current_field;
char *yybuf;
char *yyresultstring;
#define MAX_NUM_FIELDS 100
char *field_name_array[MAX_NUM_FIELDS];
static long fields_found_this_query = 0;

extern long number_of_operands; /* defined in field_search.c */
/* char** field_name_array = NULL; */

static char * strcatCC _AP((char *w, char *wl));
static char * strcatCCC _AP((char *w, char *wl, char *op));
static char * strcatCCCC _AP((char *w, char *wl, char *op1, char *op2));
%}
%token WORD
%token PHONIX SOUNDEX
%token OR
%token AND
%token NOT

%union {
   int  ival;
   char *sval;
   }
%%
query           : expression 
{
  yyresultstring = $<sval>1;    /* who calls free ? (up) */
#ifdef YYDEBUG
  if (yydebug) fprintf(stderr,"query->%s<-\n",yyresultstring);
#endif
}
                ;

or              : %prec OR
                | OR
                ;

and             : AND { $<sval>$ = "and"; }
                | NOT { $<sval>$ = "not"; }
                ;

expression      : term
                {
                  $<sval>$ = $<sval>1;
                }
                | expression or term
                {
                  if (yyboolean) {
                    ++number_of_operands;
                    $<sval>$ = strcatXXC($<sval>1, $<sval>3, "or");
                  } else {
                    $<sval>$ = strcatXX($<sval>1, $<sval>3);
                  }
                }
                ;

term            : factor
                {
                  $<sval>$ = $<sval>1;
                }
                | term and factor
                {
                  ++number_of_operands;
                  $<sval>$ = strcatXXC($<sval>1, $<sval>3, $<sval>2);
                }
                ;

factor          : WORD 
                {
                  if (yyverbose) {
                    $<sval>$ = strcatCCX("text", "=", $<sval>1);
                    global_dct_exists = 1;
                  } else {
                    $<sval>$ = $<sval>1;
                  }
                }
                | phonsound WORD
                {
		  if (yyverbose) {
                    $<sval>$ = strcatXCXX("text", "=", $<sval>1, $<sval>2);
		  } else {
		    $<sval>$ = strcatXX($<sval>1, $<sval>2);
		  }
		}
                | '(' expression ')'
                {
                  $<sval>$ = $<sval>2;
                }
                | WORD '=' {current_field = $<sval>1;numeric_field = 0;} 
                          '(' s_expression ')'
                {
                  insert_field(current_field);
                  $<sval>$ = $<sval>5;
                  free(current_field);
                }
                | WORD '=' {current_field = $<sval>1;numeric_field = 0;}  WORD
                {
                  if (yyverbose) {
                    insert_field(current_field);
                    $<sval>$ = strcatXCX(current_field, "=", $<sval>4);
                  } else {
                    $<sval>$ = $<sval>4;
                    free(current_field);
                  }
                }
                | WORD '=' {current_field = $<sval>1;numeric_field = 0;} phonsound WORD
                {
                  if (yyverbose) {
                    insert_field(current_field);
                    $<sval>$ = strcatXCXX(current_field, "=", $<sval>4, $<sval>5);
                  }else {
                    $<sval>$ = strcatXX($<sval>4, $<sval>5);
                    free(current_field);
                  }
                }
                | WORD relop {current_field = $<sval>1;numeric_field = 1;}  WORD
                {
                  if (yyverbose) {
                    /* was soll hier eigentlich passieren ?
                       "py == 1990" => "py=" in die feldliste
                                       "py == 1990"
                       "py < 1990"  => "py" in die feldliste
                                       "py < 1990"
                       "py > 1990"  => "py" in die feldliste
                                       "py > 1990"
                    */
                    if(!strcmp($<sval>2, ">")) {
                      insert_field_p(current_field, ">");
                    }
                    else if(!strcmp($<sval>2, "<")) {
                      insert_field_p(current_field, "<");
                    }
                    else if(!strcmp($<sval>2, "==")) {
                      insert_field_p(current_field, "=");
                    }
                    else insert_field(current_field);
                    /* up: relop is static, so do not free it !! */
                    $<sval>$ = strcatXCX(current_field, $<sval>2, $<sval>4);
                  } else {
                    $<sval>$ = $<sval>4;
                    free(current_field);
                  }
                  /* up do no free current_field twice */
                }
                ;
relop           : '=' '=' { $<sval>$ = "=="; }
                | '<'     { $<sval>$ = "<"; }
                | '>'     { $<sval>$ = ">"; }
                ;
phonsound       : PHONIX
                | SOUNDEX
                ;
s_expression    : s_term 
                {
                  $<sval>$ = $<sval>1   ;
                }
                | s_expression or s_term
                {
                  if (yyboolean) {
                    ++number_of_operands;
                    $<sval>$ = strcatXXC($<sval>1, $<sval>3, "or");
                  } else {
                    $<sval>$ = strcatXX($<sval>1, $<sval>3);
                  }
                }
                ;

s_term          : s_factor 
                {
                  $<sval>$ = $<sval>1;
                }
                | s_term and s_factor 
                {
                  ++number_of_operands;
                  $<sval>$ = strcatXXC($<sval>1, $<sval>3, $<sval>2);
                }
                ;

s_factor        : WORD
                {
                  if (yyverbose) {
                    if(numeric_field) 
                      $<sval>$ = strcatCCX(current_field, "==", $<sval>1);
                    else $<sval>$ = strcatCCX(current_field, "=", $<sval>1);
                  } else {
                    $<sval>$ = $<sval>1;
                  }
                }
                | phonsound WORD
                {
                  if (yyverbose) 
                    $<sval>$ = strcatCCXX(current_field, "=", $<sval>1, $<sval>2);
                  else $<sval>$ = strcatXX($<sval>1, $<sval>2);
                }
                | '(' s_expression ')'
                {
                  $<sval>$ = $<sval>2;
                }
                ;
%%

yyerror(s)
char *s;
{
   fprintf(stderr,"line %d: syntax error at or near string \"%s\"\n",
           yylineno, yytext);
   fprintf(stderr,"%s\n", s);
}

yywrap()
{
   return(1);
}

static char *strcatCC(w, wl)
char *w, *wl;
{
   char *wln;
   int len;

   len = strlen(w) + strlen(wl) + 2;
   wln = (char *)malloc(len);

   wln = strcpy(wln, w);
   wln = strcat(wln, " ");
   wln = strcat(wln, wl);

   return(wln);
}

static char *strcatCCC(w, wl, op)
char *w, *wl, *op;
{
   char *wln;
   int len;

   len = strlen(w) + strlen(wl) + strlen(op) + 3;
   wln = (char *)malloc(len);

   wln = strcpy(wln, w);
   if ((*wl == '=') || (*wl == '<') || (*wl == '>')) {
     /* no blank */
   } else {
     wln = strcat(wln, " ");
   }
   wln = strcat(wln, wl);
   wln = strcat(wln, " ");      
   wln = strcat(wln, op);

   return(wln);
}

static char *strcatCCCC(w, wl, op1, op2)
char *w, *wl, *op1, *op2;
{
   char *wln;
   int len;

   len = strlen(w) + strlen(wl) + strlen(op1) + strlen(op2) + 3;
   wln = (char *)malloc(len);

   wln = strcpy(wln, w);
   if ((*wl == '=') || (*wl == '<') || (*wl == '>')) {
     /* no blank */
   } else {
     wln = strcat(wln, " ");
   }
   wln = strcat(wln, wl);
   wln = strcat(wln, " ");      
   wln = strcat(wln, op1);
   wln = strcat(wln, " ");
   wln = strcat(wln, op2);

   return(wln);
}

int is_duplicate_field(field_name)
     char* field_name;
{
  long i = 0;
  long len = strlen(field_name);

  for (i=0;i<fields_found_this_query;i++)
    if (!strncmp(field_name, field_name_array[i], len))
      return(1); /* it is duplicate */

  return(0); /* not duplicate and field_name can inserted. */
}

#define MAX_WORD_LENGTH 20
int insert_field_p(field_name,c)
     char* field_name;
     char* c;
{
  char field_name_p[MAX_WORD_LENGTH];
  strncpy(field_name_p,field_name,MAX_WORD_LENGTH);
  strncat(field_name_p,c,MAX_WORD_LENGTH);
  return(insert_field(field_name_p));
}

int insert_field(field_name)
     char* field_name;
{
  long i = 0;
  long len = strlen(field_name);

  if (fields_found_this_query > MAX_NUM_FIELDS) {
    /* overflow: should be handled with realloc ? */
    return(-1);
  }
  if (!is_duplicate_field(field_name)) {
      /* dont know why not use strdup (up)?
         field_name_array[fields_found_this_query] = strdup(field_name); 
         */
    field_name_array[fields_found_this_query] =
      (char*)malloc((size_t)((MAX_WORD_LENGTH + 1) * sizeof(char)));
    /* warn if malloc failed !! (up)*/
    strncpy(field_name_array[fields_found_this_query],field_name,MAX_WORD_LENGTH);
    fields_found_this_query++;
  }
  return(0);
}


char* analyse_string(string, number_of_fields, global_dictionary_exists)
     char* string;
     long* number_of_fields;
     int* global_dictionary_exists;
{
  int result;

  fields_found_this_query = 0;
  yyverbose = 0;
  numeric_field = 0;
  yydebug = 0;
  yybuf   = string;

  if (strchr(string,'=')) 
    yyverbose++;
  else  if (strchr(string,'>')) 
    yyverbose++;
  else if (strchr(string,'<')) yyverbose++;

  yyboolean = yyverbose || (strstr(string," and ") || strstr(string," AND ")||
        strstr(string," not ") || strstr(string," NOT "));

  if (!yyparse()) {
    field_name_array[fields_found_this_query] = NULL;
#ifdef YYDEBUG
    if (yydebug) {
      int i;
      fprintf(stderr,"Found %d fields\n", fields_found_this_query);
      for (i=0;i<fields_found_this_query;i++) {
        fprintf(stderr,"feld %d %s\n", i, 
                (field_name_array[i]==NULL)?"(nil)":field_name_array[i]);
      }
      sleep(2);
    }
#endif
    *number_of_fields = fields_found_this_query;
    *global_dictionary_exists = global_dct_exists;
    global_dct_exists = 0;
    return(yyresultstring);
  } else {
    *number_of_fields = 0;
    field_name_array[0] = NULL;
    return(NULL);
  }
}


#ifdef TEST_QUERY
long number_of_operands = 0;

int main _AP((int argc, char *argv[]));

main(argc,argv)
int argc;
char *argv[];
{
  long dummy;
  if (argc ==1) {
    char s[80];
    fprintf(stderr, ">");
    fgets(s,79,stdin);
    printf("%s -> %s\n", s, analyse_string(s, &dummy, &dummy));
  } else {
    if (argc != 2) {
      fprintf(stderr, "USAGE: %s <query>\n", argv[0]);
      exit(1);
    }
    printf("%s -> %s\n", argv[1], analyse_string(argv[1], &dummy, &dummy));
  }
  exit(0);
}
#endif
