%{
/*                               -*- Mode: C -*- 
 * qyery_l.l -- 
 * ITIID           : $ITI$ $Header $__Header$
 * Author          : Ulrich Pfeifer
 * Created On      : Tue Feb 15 16:03:22 1994
 * Last Modified By: Ulrich Pfeifer
 * Last Modified On: Fri Jul 22 17:15:47 1994
 * Update Count    : 32
 * Status          : Unknown, Use with caution!
 */


/* HISTORY 
 * 23-Mar-1994		Ulrich Pfeifer	
 *    Last Modified: Wed Mar 23 11:09:53 1994 #29 (Ulrich Pfeifer)
 *    Added flex support
 * 10-Mar-1994		Ulrich Pfeifer	
 *    Support for literal searches
 */

#include "query_token.h"
#include "cutil.h"

#undef  ECHO
#define ECHO 
/*
[Oo][Rr]
[Nn][Oo][Tt] 
*/
extern char* yybuf;
#ifdef FLEX_SCANNER
int yylineno = 0;
#undef yywrap
#define yywrap() (yyrestart(yyin),1)

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
                  { \
                  int c = *(yybuf++); \
                  if (c=='\n') yylineno++; \
                  result = (c == '\0') ? YY_NULL : (buf[0] = c, 1); \
                  }
#else
#undef input
#define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):*(yybuf++))==10?(yylineno++,yytchar):yytchar)=='\0'?0:yytchar)
#endif
%}
WORD  [^ \t\n=()<>]+
%%
"and"|"AND"|"And" { ECHO; return(AND); }
"or"|"OR"|"Or"    { ECHO; return(OR); }
"not"|"NOT"|"Not" { ECHO; return(NOT); }
[()=<>]           { ECHO; return(yytext[0]); }
[ \t\n]           { ECHO; }
"phonix"          { ECHO; yylval.sval = s_strdup(yytext); return(PHONIX);}
"soundex"         { ECHO; yylval.sval = s_strdup(yytext); return(SOUNDEX);}
{WORD}            { ECHO; yylval.sval = s_strdup(yytext); return(WORD);}
\'[^']*\'         { ECHO; yylval.sval = s_strdup(yytext); return(WORD);}
\"[^"]*\"         { ECHO; yylval.sval = s_strdup(yytext); return(WORD);}
%%
