/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Brewster@think.com
*/

/* Copyright (c) CNIDR (see ../COPYRIGHT) */


/* Change log:
 * $Log: macver.c,v $
 * Revision 1.3  1994/07/22  12:25:20  pfeifer
 * Renamed logfile to waislogfile and log_file_name to wais_log_file_name
 * to avoid clashes when linking with gopher and other systems
 *
 * Revision 1.2  1994/03/08  21:06:37  pfeifer
 * Patchlevel 04
 *
 * Revision 1.1  1993/02/16  15:05:35  freewais
 * Initial revision
 *
 * Revision 1.2  92/02/12  13:36:08  jonathan
 * Added "$Log: macver.c,v $
 * Revision 1.3  1994/07/22  12:25:20  pfeifer
 * Renamed logfile to waislogfile and log_file_name to wais_log_file_name
 * to avoid clashes when linking with gopher and other systems
 *
 * Revision 1.2  1994/03/08  21:06:37  pfeifer
 * Patchlevel 04
 *
 * Revision 1.1  1993/02/16  15:05:35  freewais
 * Initial revision
 *" so RCS will put the log message in the header
 * 
*/

#include "irverify.h"
#include "panic.h"
#include "irfiles.h"

/*----------------------------------------------------------------------*/
/* Class definitions */

#include <CApplication.h>
#include <CFile.h>
#include <CView.h>
#include <CWindow.h>
#include <CDesktop.h>
#include <CDirector.h>
#include "CDynamicError.h"

extern	CApplication	*gApplication;

struct CVerifyApp : CApplication 
{
  void	IVerifyApp(void);
};

void CVerifyApp::IVerifyApp(void)
{
  CApplication::IApplication(4, 20480L, 2048L);
  gError->Dispose(); /* get rid if the CError that IApplication defined */
  gError = new(CDynamicError); /* make our own error handler */
}

/*----------------------------------------------------------------------*/
/* Gets a full filename from the mac file objects.
 * getwd was taken from utils.c from the 
 * document retrieval system.
 */

#include <HFS.H>
#include <string.h>
/* for file manipulation routines */
typedef enum file_style {MAC_FILE_STYLE, UNIX_FILE_STYLE} file_style;
#include <FileMgr.h>

static char 
*getwd(file_style style)
/* This function returns the unix style path name which is set by any of the SF
   routines (using the global vars).  The code is from the net, I have no idea
   who the author might be.  He/She does include the following note:
   
  		Note that it is perfectly legal for a Macintosh owner to create a
		directory hierarchy where the length of full path names of the deepest
		files exceeds 255 bytes; since the file system never manipulates full
		pathnames internally (it only ever sees them when passed as parameters),
		it doesn't and needn't check.  However, this poses an ethical problem if
		you are constructing full pathnames: my code simply bombs if it would
		construct a pathname >255 bytes, and if I increased the buffer size, the
		resulting pathnames are useless except for documentation purposes (since
		the file system can't have string parameters >255 bytes).
 */
{
	CInfoPBRec d;
	static char ret[255];
	char nm[50], tmp[255];
	long cur_dir = CurDirStore; /* mac global var */
	long cur_vol = 0 - SFSaveDisk; /* mac global var */
	
	ret[0] = '\0';
	d.dirInfo.ioDrDirID = cur_dir;
	for(;;) {
		d.dirInfo.ioCompletion = 0;
		d.dirInfo.ioNamePtr = (StringPtr) nm;
		d.dirInfo.ioVRefNum = cur_vol;
		d.dirInfo.ioFDirIndex = -1;

		PBGetCatInfo(&d,0);
/*		if(d.ioResult != noErr) return(0); this is not defined in lightspeed's headers */
		PtoCstr((char *) nm);
		strcpy(tmp,ret);
		if (style == UNIX_FILE_STYLE)
		  strcpy(ret,"/");
		else 
		  strcpy(ret,":");
		strcat(ret,nm);
		strcat(ret,tmp);
		if(d.dirInfo.ioDrDirID == 2) break;	/* home directory */
		d.dirInfo.ioDrDirID = d.dirInfo.ioDrParID;
	} 
	/* if its MAC style, remove the leading colon */
	if (style == MAC_FILE_STYLE)
	  return(ret+1);
	else
	  return(ret);
}

/*----------------------------------------------------------------------*/
/* Gets a filename from the user (one that exists already) */
 
static boolean 
get_filename(char* prompt, char *filename)
{
   SFReply	macSFReply;
   Point pos;
   pos.h = pos.v = 100;
   CtoPstr(prompt);
   SFGetFile(pos, (StringPtr)prompt, 
			 NULL, -1, NULL, NULL, &macSFReply);
   PtoCstr(prompt);
   if(macSFReply.good)
    { /* then we have a gotten a good file.
	   * put together the full filename
       */
		 
      strcpy(filename, getwd(MAC_FILE_STYLE));
      strcat(filename, ":");
	  PtoCstr((char *)macSFReply.fName);
	  strcat(filename, (char *)macSFReply.fName);
	  CtoPstr((char *)macSFReply.fName);
	  return(true);
	 }
	else
	  return(false);
}

/*----------------------------------------------------------------------*/

FILE *waislogfile = NULL;

void
main()
{
  char index_filename[MAX_FILE_NAME_LEN + 1]; 
  database* db = NULL;

freopen("stdout","w",stdout);

  gApplication = new(CVerifyApp);
  ((CVerifyApp *)gApplication)->IVerifyApp();
  
  if(get_filename("Index to verify:",index_filename) == false)
    return;
    
  *(strrchr(index_filename,'.')) = '\0'; 
  printf("verifying:  %s\n",index_filename);
    
  db = openDatabase(index_filename,false,true);
  if (db == NULL)
	panic("unable to open the database\n");
	
  print_dictionary(db);
  printf("\n\n---------------------------------------------------------\n\n");
  printIndex(db);
  printf("\n\n---------------------------------------------------------\n\n");
  printIndexUsingDictionary(db);
  
  closeDatabase(db);
}

/*----------------------------------------------------------------------*/
