%{
/*                               -*- Mode: C -*- 
 * field_l.l -- 
 * ITIID           : $ITI$ $Header $__Header$
 * Author          : Ulrich Pfeifer
 * Created On      : Tue Feb 15 16:03:22 1994
 * Last Modified By: Ulrich Pfeifer
 * Last Modified On: Thu Jun 16 19:26:56 1994
 * Update Count    : 200
 * Status          : Unknown, Use with caution!
 */


/* HISTORY 
 * 10-Mar-1994		Ulrich Pfeifer	
 *    added support for backslash escaped '/'.
 */

#include "field_token.h"
#include "cutil.h"
#ifdef FLEX_SCANNER
int yylineno = 0;
#undef yywrap
#define yywrap() (1)
/*
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
             { \
                  int c = getc(yyin); \
                  if (c=='\n') yylineno++; \
                  result = (((char) c) == EOF) ? YY_NULL : (buf[0] = c, 1); \
             }
*/
#endif


#undef  ECHO
#define ECHO 
%}
WORD  [^ \t\n=()/]+
%%
"/"[^/]*"/" { ECHO; 
	      if (yytext[yyleng-2] == '\\') { /* escaped '/' */
		int i, escap_number = 0;
		for(i = yyleng-2; i > 0; i--) {
		  if(yytext[i] == '\\') ++escap_number;
		  else break;
		} 
		if(escap_number % 2 != 0) {
		  yymore();
		  unput(yytext[yyleng-1]);/* yes yyless() is better */ 
		} else {
		  yylval.sval = strdup(yytext);
		  return(REGEXP);
		}
	      } else {
		yylval.sval = strdup(yytext);
		{ char *s = yylval.sval, *t = yylval.sval;
		  while (*s) { 
		    if (*s == '\\') {
		      if (s[1] == '/') {
			s+=1; /* escaped '/' */
		      } else if (s[1] == '\\') { 
			s+=1; /* double \\ */
		      } else if (s[1] >= 'A' && s[1] <= 'Z') { 
			s[1] = s[1]-'A'+1;  /* map of ASCII character set */
			s+=1;
		      }	else if (s[1] == 'n') {
			s[1] = 'J' - 'A' + 1; /* newline */
			s+=1;
		      } else {
			s+=1;
		      }
		    }
		    *(t++) = *(s++);
		  }
		  *t = *s; /* should be '\0' */
		  /* fprintf(stderr,"\nregexp:%s:\n", yylval.sval); */
		  return(REGEXP); 
		}
	      }
	    }
[0-9]+            { ECHO; yylval.ival = atoi(yytext); return(INT); }
"<field>"         { ECHO; return(FIELD); }
"<end>"           { ECHO; return(END); }
"<numeric>"       { ECHO; return(NUMERIC); }
"<headline>"      { ECHO; return(HEADLINE); }
"<layout>"        { ECHO; return(LAYOUT); }
"stemming"        { ECHO; return(STEMMING); }
[ \t\n]           { ECHO; }
"SOUNDEX"         { /* tung: it is very bad style to use the strings here! use a enum (up) */
                    ECHO; yylval.sval = strdup(yytext); return(ISOUNDEX); }
"PHONIX"          { ECHO; yylval.sval = strdup(yytext); return(IPHONIX); }
"TEXT"            { ECHO; yylval.sval = strdup(yytext); return(ITEXT); }
"LOCAL"           { ECHO; return(LOCAL); }
"IGNORE"          { ECHO; return(IGNORE); }
"GLOBAL"          { ECHO; return(GLOBAL); }
"BOTH"            { ECHO; return(BOTH); }
"<record-end>"    { ECHO; return(RECORD_END); }
"<date>"          { ECHO; /* yylval.sval = strdup(yytext); (up) */ return(DATE); }
"day"             { ECHO; /* yylval.sval = strdup(yytext); (up) */ return(DAY); }
"month"           { ECHO; /* yylval.sval = strdup(yytext); (up) */ return(MONTH); }
"year"            { ECHO; /* yylval.sval = strdup(yytext); (up) */ return(YEAR); }
"string"          { ECHO; /* yylval.sval = strdup(yytext); (up) */ return(STRING); }
{WORD}            { ECHO; yylval.sval = strdup(yytext); return(WORD); }
