/*                               -*- Mode: C -*- 
 * ctype.h -- 
 * ITIID           : $ITI$ $Header $__Header$
 * Author          : Dmitry Kryukov <dima@ulysses.stack.serpukhov.su>
 * Created On      : Wed Mar 23 09:39:11 1994
 * Last Modified By: Ulrich Pfeifer
 * Last Modified On: Mon Jul 11 10:47:51 1994
 * Update Count    : 45
 * Status          : Unknown, Use with caution!
 */

#ifndef _CTYPE_H_
#define _CTYPE_H_

#define	_U	0x01
#define	_L	0x02
#define	_N	0x04
#define	_S	0x08
#define	_P	0x10
#define	_C	0x20
#define	_X	0x40
#define	_B	0x80

#ifndef CTYPE_C
#ifdef STDC_HEADERS
extern const char _ctype__[];
#else
extern char _ctype__[];
#endif /* STDC_HEADERS */
#endif /* CTYPE_C */

#define	isalnum(c)	((_ctype__ + 1)[(unsigned char)c] & (_U|_L|_N))
#define	isalpha(c)	((_ctype__ + 1)[(unsigned char)c] & (_U|_L))
#define	isascii(c)	((unsigned)(c) <= 0177)
#define	isblank(c)	((c) == '\t' || (c) == ' ')
#define	iscntrl(c)	((_ctype__ + 1)[(unsigned char)c] & _C)
#define	isdigit(c)	((_ctype__ + 1)[(unsigned char)c] & _N)
#define	isgraph(c)	((_ctype__ + 1)[(unsigned char)c] & (_P|_U|_L|_N))
#define	islower(c)	((_ctype__ + 1)[(unsigned char)c] & _L)
#define	isprint(c)	((_ctype__ + 1)[(unsigned char)c] & (_P|_U|_L|_N|_B))
#define	ispunct(c)	((_ctype__ + 1)[(unsigned char)c] & _P)
#define	isspace(c)	((_ctype__ + 1)[(unsigned char)c] & _S)
#define	isupper(c)	((_ctype__ + 1)[(unsigned char)c] & _U)
/*
#define	isxdigit(c)	((_ctype__ + 1)[(unsigned char)c] & (_N|_X))
*/
#define	isxdigit(c)	((_ctype__ + 1)[(unsigned char)c] & _X)
#define	toascii(c)	((c) & 0177)

/***********************************************************************/
/* in cyrillic we have low symbols from 0xc0 to 0xdf and upper symbols */
/*                       from 0xe0 to 0xff                             */
/***********************************************************************/
/*
#define index(s,c) \
({ \
     unsigned char * _index_; \
     for (_index_=s; *_index_ && *_index_ != c; _index_++); \
     (*_index_ == c)? _index_ : NULL; \
})
*/
extern unsigned char _lchars_[];
extern unsigned char _uchars_[];
/*
#define	tolower(c) \
({ \
	int __tolower_c = (unsigned char)(c); \
\
	isupper(__tolower_c) ? \
	    ( isascii(__tolower_c) ? __tolower_c - 'A' + 'a' : \
	    _lchars_[(int)(index(_uchars_,__tolower_c)-(char *)_uchars_)]) : \
	    __tolower_c; \
})
*/
/*
#define	toupper(c) \
({ \
	int __toupper_c = (unsigned char)(c); \
\
	islower(__toupper_c) ? \
	    ( isascii(__toupper_c) ? __toupper_c - 'a' + 'A' : \
	    _uchars_[(int)(index(_lchars_,__toupper_c) - (char *)_lchars_ )]) : \
	    __toupper_c; \
})
*/

#define	tolower(c) \
	(isupper((unsigned char)(c)) ? \
	    ( isascii((unsigned char)(c)) ? ((unsigned char)(c) - 'A' + 'a') : \
	    (islower((unsigned char)(c)) ? (unsigned char)(c) : \
             _lchars_[(int)(index(_uchars_,(unsigned char)(c)) - \
                            (char *)_uchars_)])) \
         : (unsigned char)(c))

#define	toupper(c) \
        (islower((unsigned char)(c)) ? \
	    ( isascii((unsigned char)(c)) ? ((unsigned char)(c) - 'a' + 'A') : \
	    (isupper((unsigned char)(c)) ?(unsigned char)(c) : \
             _uchars_[(int)(index(_lchars_,(unsigned char)(c)) - \
                           (char *)_lchars_ )])) :  (unsigned char)(c))

#endif /* !_CTYPE_H_ */

