
/* Copyright (c) CNIDR (see file COPYRIGHT, included in this distribution) */

/* config.c: 
 *  creates a header file with details on a machine's representation of 
 *  numbers, alignment requirements, etc, etc.
 */

#include <stdio.h>
#include <sys/time.h>

#define SHORT_CODE 0
#define INT_CODE   1
#define LONG_CODE  2
#define CHAR_CODE  3

typedef struct _short_test {
  char c;
  unsigned short s;
} short_test;

typedef struct _long_test {
  char c;
  unsigned long l;
} long_test;

typedef struct _int_test {
  char c;
  unsigned int i;
} int_test;


int main() 
{

  short_test st;
  long_test lt;
  int_test it;

  int four_byte;
  int two_byte;
  int one_byte;

  unsigned int i,*ip;
  unsigned long l,*lp;
  unsigned short s,*sp;
  char c;
  unsigned char *cp;

  printf("#ifndef CONFIG_H\n");
  printf("#define CONFIG_H\n");
  printf("#include \"Defaults.tmpl\"\n");
  if(sizeof(char) == 1) {
    printf("#define ONE_BYTE char\n");
    one_byte = CHAR_CODE;
  } else {
    fprintf(stderr,
	    "Error: chars are %d bytes long. Can't define ONE_BYTE\n",sizeof(char));
    exit(1);
  }

  if(sizeof(int) == 2) {
    printf("#define TWO_BYTE int\n");
    two_byte = INT_CODE;
  } else {
    if(sizeof(short) == 2) {
      printf("#define TWO_BYTE short\n");
      two_byte = SHORT_CODE;
    } else {
      fprintf(stderr,"Error: don't know how to define TWO_BYTE\n");
      exit(1);
    }
  }

  if(sizeof(int) == 4) {
    printf("#define FOUR_BYTE int\n");
    four_byte = INT_CODE;
  } else {
    if(sizeof(long) == 4) {
      printf("#define FOUR_BYTE long\n");
      four_byte = LONG_CODE;
     } else {
       fprintf(stderr,"Error: don't know how to define FOUR_BYTE\n");
     }
  }
    
      
  if(two_byte == SHORT_CODE) {
    printf("#define TWO_BYTE_ALIGN %d\n",(int)(&st.s)-(int)(&st.c));
  } else {
    if (two_byte == INT_CODE) {
      printf("#define TWO_BYTE_ALIGN %d\n",(int)(&it.i)-(int)(&it.c));
    }
  }
  if(four_byte == INT_CODE) {
    printf("#define FOUR_BYTE_ALIGN %d\n",(int)(&it.i)-(int)(&it.c));
  } else {
    if(four_byte == LONG_CODE) {
      printf("#define FOUR_BYTE_ALIGN %d\n",(int)(&lt.l)-(int)(&lt.c));
    }
  }

  l=0xdeadbeef;

  
  cp=(unsigned char*)&l;

  if(*cp == 0xde) {
    printf("#ifndef BIGENDIAN\n#define BIGENDIAN\n#endif\n");
  } else {
    if(*cp == 0xef) {
      printf("#ifndef  LITTLEENDIAN\n#define LITTLEENDIAN\n#endif\n");
      } else {
	fprintf(stderr,"Error: can't find out byte order\n");
	exit(1);
      }
  }
  printf("#define FILE_WRITE_DATE_SIZE %d\n",  sizeof(time_t));
  printf("#endif /* CONFIG_H */\n");
  exit(0);
}
  
