<?php

// /-------------------------------------------------\
// | ############################################### |
// | # ------------------------------------------- # |
// | # --- Picy - a simple PHP folder gallery ---- # |
// | # ---            CONFIGURATOR            ---- # |
// | # ------------------------------------------- # |
// | ############################################### |
// | #             2004 - Adrian Stutz            # |
// | #       This script is licensed unter a       # |
// | #          creative Commons License.          # |
// | #    http://creativecommons.org/licenses     # |
// | #              /by-nc-sa/2.0/de/              # |
// | #           adrian.stutz@gmail.com            # |
// | ############################################### |
// | #              Table of Contents:             # |
// | #            0. Settings (line 16)            # |
// | #              1. Init (line 30)              # |
// | #              2. Main (line 61)              # |
// | #            3. Settings (line 108)           # |
// | #        4. Edit / New Theme (line 173)       # |
// | #          5. Delete Theme (line 243)         # |
// | #         6. Install Theme (line 284)         # |
// | #         7. Delete Picture (line 365)        # |
// | #        8. Install Picture (line 405)        # |
// | #        9. Install Picture (line 494)        # |
// | #           10. Functions (line 574)          # |
// | ############################################### |
// \-------------------------------------------------/

// ---------------------------------------------------
// -- 0. SETTINGS ------------------------------------
// ---------------------------------------------------

// Use external settings? (Will be create when you first run this script)
$cset['sext'] = true;
// Settings file path
$cset['sfile'] = 'picy_conf.set.php';
// --- The following settings are only used when sext = false ---
// Password needed to run this script
$cset['password'] = sha1 ('picy');
// Filename of the picy script
$cset['script'] = 'picy.php';
// Filename where to changes are written to. Existing files will be overwritten!
$cset['output'] = 'picy.php';
// Make backup before writing? (Of the 'script' file, useful when 'output' is the same as 'script')
// Backups will overwrite themselves so make sure you check that everything is correct after every write!
$cset['backup'] = true;

// ---------------------------------------------------
// -- 1. INIT ----------------------------------------
// ---------------------------------------------------

$picy_cversion = 'v0.2';
$c_compat = array ('0.6','0.7');
session_start ();

// Look for settings if external
if ($cset['sext'] == true) {
	if (!file_exists ($cset['sfile'])) {
		// Install script
		if (!isset ($_POST['isub'])) {
			// Display install form
			if (!is_writable (dirname($cset['sfile'])))
				error ('Folder is not writeable - won\'t be able to create the settings file.');
			cheader ('.desctr {
				background-color: #fff;
				text-align: left;
				color: #666;
			}
			.nametd {
				width: 100px;
				text-align: left;
			}');
			$b = '';
			if ($cset['backup'])
				$b = ' checked';
			print '<p class="title">Install:</p>'."\n";
			print 'picy configurator is set to store it\'s settings externally.<br />Please povide following options for the ';
			print 'settings file and to finish installtion.<br />';
			print 'You won\'t be able to modify this settings after you saved them!<br /><br />';
			print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
			print '<table style="width: 500px;">'."\n";
			print '<tr><td colspan="2" class="desctr">Password will be stored SH1 encrypted. This way the password can ';
			print 'be verified but it will be impossible to guess the original password.</td></tr>'."\n";
			print '<tr><td style="width: 100px;">Password:</td>'."\n";
			print '<td><input type="text" name="password" style="width: 400px;"></td></tr>'."\n";
			print '<tr><td colspan="2" class="desctr">Path to the script file. This file will be parsed and ';
			print 'changes made based on it.</td></tr>'."\n";
			print '<tr><td style="width: 100px;">Script file:</td>'."\n";
			print '<td><input type="text" name="script" value="'.$cset['script'].'" style="width: 400px;"></td></tr>'."\n";
			print '<tr><td colspan="2" class="desctr">This is the file the changed script will be written to. This can be ';
			print 'the same as the script file. Note that if this is not the same file as the input script file, ';
			print 'changes will not appear in the configurator until you replace the input script file with the new output.</td></tr>'."\n";
			print '<tr><td style="width: 100px;">Output file:</td>'."\n";
			print '<td><input type="text" name="output" value="'.$cset['output'].'" style="width: 400px;"></td></tr>'."\n";
			print '<tr><td colspan="2" class="desctr">Backup the input script file before writing. This makes sense if the output ';
			print ' file is the same as the input script file.</td></tr>'."\n";
			print '<tr><td style="width: 100px;"></td>'."\n";
			print '<td style="text-align: left;"><input type="checkbox" name="backup"'.$b.'> Create Backup</td></tr>'."\n";
			print '<tr><td colspan="2"><input type="submit" name="isub" value="Save"></td></tr>';
			print '</table></form>'."\n";
			cfooter ();
			exit;
		} else {
			// Verify input
			if (strlen(trim($_POST['password'])) < 4)
				error ('Password has to be at least four characters long.');
			if (trim ($_POST['script']) == '')
				error ('Script field is empty.');
			if (trim ($_POST['output']) == '')
				error ('Output field is empty.');
			if (!file_exists ($_POST['script']))
				error ('Couldn\'t find script file.');
			// Prepare
			$sarr['password'] = sha1($_POST['password']);
			$sarr['script'] = $_POST['script'];
			$sarr['output'] = $_POST['output'];
			$sarr['backup'] = false;
			if (isset ($_POST['backup']))
				$sarr['backup'] = true;
			// Write
			$set = fopen ($cset['sfile'],'w+');
			$out = serialize ($sarr);
			$out = "<?php\nhash=".md5($out."\n")."\n".$out."\n?>";
			$err = fwrite ($set,$out);
			if ($err === false)
				error ('Couldn\'t write settings.');
			fclose ($set);
			chmod ($cset['sfile'],0444);
			cheader ();
			print 'Settings written, please reload.';
			cfooter ();
			exit;
		}
	} else {
		// Load settings
		$set = fopen ($cset['sfile'],'r');
		// First line is '<?php' -> discard
		$line = fgets ($set);
		// Get hash
		$line = fgets ($set);
		$matches = array ();
		if (!preg_match ('/hash=([0-9a-zA-Z]{32})/',$line,$matches))
			error ('Settings file corrupted. (1)');
		$hash = $matches[1];
		// Get serialized array
		$line = fgets ($set);
		// Check hash
		if (md5 ($line) != $hash)
			error ('Settings file corrupted. (2)');
		// Load
		$cset = unserialize ($line);
		if ($cset === false)
			error ('Could not read settings.');
		fclose ($set);
	}
}

// Password changed?
if ($cset['password'] == sha1('picy'))
	error ('Password not changed. Please set a new password.');

// Login
if (!isset ($_SESSION['pwd']) || $_SESSION['pwd'] != $cset['password']) {
	if (!isset ($_POST['logsub'])) {
		cheader ();
		print 'Please log in:'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'">';
		print '<table style="width: 300px; text-align: left; margin: 5px auto 5px auto; border: 1px solid #ccc; padding: 5px;">'."\n";
		print '<tr><td>Password:</td>'."\n";
		print '<td><input type="password" name="pwd" style="width: 200px;" /></td></tr>'."\n";
		print '<tr><td colspan="2" style="text-align: right;"><input type="submit" name="logsub" value="Login" /></td></tr>';
		print '</table></form>';
		cfooter ();
		exit;
	} else {
		if (sha1 ($_POST['pwd']) != $cset['password'])
			error ('Login failed.');
		$_SESSION['pwd'] = sha1 ($_POST['pwd']);
	}
}

if (isset ($_GET['logout'])) {
	session_destroy ();
	cheader ();
	print 'You have been logged out.<br /><a href="'.$cset['script'].'">picy Main</a>';
	cfooter ();
	exit;
}

// ---------------------------------------------------
// -- 2. MAIN ----------------------------------------
// ---------------------------------------------------

parse_file ();

if (!isset ($_GET['func'])) {

	cheader ();
	
	if (!is_writable ($cset['output']))
		print '<b>Note:</b> The output script path is not writeable.<br />Picy Configuratoer propably won\'t be able to save changes.<br />';
	if (!is_writable (dirname($cset['script'])) && $cset['backup'])
		print '<b>Note:</b> The script directory is not writeable.<br />Picy Configurator ppropably won\'t be able to make a backup.<br />';
	
	print '<br /><a href="'.$_SERVER['PHP_SELF'].'?func=settings">Change Settings</a><br />'."\n";
	print '<a href="'.$_SERVER['PHP_SELF'].'?func=rawsettings">Raw Settings</a><br />'."\n";
	print '<a href="'.$_SERVER['PHP_SELF'].'?func=thmsetup">Theme Setup</a><br />'."\n";
	print '<a href="'.$_SERVER['PHP_SELF'].'?func=htfile">Create htaccess file</a><br />'."\n";
	print '<br /><hr class="line">'."\n";
	print '<table style="width: 100%"><tr><td style="width: 50%; vertical-align: top;">'."\n";
	print '<h2 class="subtitle">Installed Themes:</h2>'."\n";
	for ($i=0;$i<count($themes);$i++) {
		print $themes[$i]['name'].' ('.$themes[$i]['short'].')<br />';
		print '<a href="'.$_SERVER['PHP_SELF'].'?func=ethm&id='.$i.'">[Edit]</a> ';
		print '<a href="'.$_SERVER['PHP_SELF'].'?func=dthm&id='.$i.'">[Delete]</a> ';
		print '<a href="'.$_SERVER['PHP_SELF'].'?func=expthm&id='.$i.'">[Export]</a> ';
		print '<br />'."\n";
	}
	print '<br /><a href="'.$_SERVER['PHP_SELF'].'?func=newthm">[New Theme]</a> ';
	print '<a href="'.$_SERVER['PHP_SELF'].'?func=instthm">[Install Theme]</a>'."\n";
	print '</td><td style="width: 50%; vertical-align: top;">'."\n";
	print '<h2 class="subtitle">Installed Pictures:</h2>'."\n";
	for ($i=0;$i<count($pictures);$i++) {
		print '<a href="'.$cset['script'].'?dp='.$pictures[$i]['name'].'">'.$pictures[$i]['name'].'</a> ('.$pictures[$i]['type'].') ';
		print '<a href="'.$_SERVER['PHP_SELF'].'?func=dpic&id='.$i.'">[Delete]</a>';
		print '<br />'."\n";
	}
	print '<br /><a href="'.$_SERVER['PHP_SELF'].'?func=instpic">[Install Pictures]</a>'."\n";
	print '</td></tr></table>'."\n";
	print '<br /><hr class="line">'."\n";
	print '<span style="padding: 40px; font-size: 10px;">'."\n";
	print '<b>Note:</b> This script modifies the picy script file. Any settings / themes / pictures in the '."\n";
	print 'script file could get lost and the script as whole become unusable. Make sure that the script and '."\n";
	print 'output paths are set correctly. This script will write to those paths and whatever could be there '."\n";
	print 'will be overwritten.</span><br /><br />'."\n";
	cfooter ();

} elseif ($_GET['func'] == 'settings') {
	
	// ---------------------------------------------------
	// -- 3. SETTINGS ------------------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['ssub'])) {
		
		// Load settings
		$set = array ();
		eval ($raw_settings);
		
		cheader ('.desctr {
			background-color: #fff;
			text-align: left;
			color: #666;
		}
		.nametd {
			width: 100px;
			text-align: left;
		}
		.titletr td {
			padding-bottom: 10px;
		}');
		print '<p class="subtitle">Settings</p>'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func=settings">';
		print '<table style="width: 100%;">'."\n";
		
		// Image Types
		print '<tr><td class="desctr" colspan="2">Image extensions that will be displayed in picy (typically images). ';
		print 'Enter them in lowercase and separated with a comma.</td></tr>'."\n";
		print '<tr><td class="nametd">Image Types:</td>'."\n";
		print '<td><input type="text" name="img_types" value="'.implode(',',$set['img_exts']).'" style="width: 400px;"></td></tr>'."\n";
		
		// Hotlink protection
		if ($set['img_hotprot']) {
			$c[$set['img_hp_type']] = ' selected';
		} else {
			$c['none'] = ' selected';
		}
		print '<tr><td class="desctr" colspan="2">Activate hotlink protection. You still have to lock the images from ';
		print 'being accessed directly (e.g. through htaccess files). Also, for all image types there has to be a ';
		print 'suitable MIME type set in mime_types.</td></tr>'."\n";
		print '<tr><td class="nametd">Hotlink Prot.:</td>'."\n";
		print '<td style="text-align: left;"><select name="img_hotprot">';
		print '<option value="none"'.$c['none'].'>None</option><option value="session"'.$c['session'].'>Session</option>';
		print '<option value="mysql"'.$c['mysql'].'>MySQL</option><option value="file"'.$c['file'].'>Filesystem</option>';
		print '</slect></td></tr>'."\n";
		
		// MIME Types
		$temp = array ();
		foreach ($set['mime_types'] as $ext => $type) {
			$temp[] = $ext.':'.$type; }
		print '<tr><td class="desctr" colspan="2">MIME types used when tunneling images (hotlink protection).<br />';
		print 'Format: extension:mime-type,extension2,mime-type2,...</td></tr>'."\n";
		print '<tr><td class="nametd">Image Types:</td>'."\n";
		print '<td><input type="text" name="mime_types" value="'.implode(',',$temp).'" style="width: 400px;"></td></tr>'."\n";
		
		// Pictures per page:
		print '<tr><td class="desctr" colspan="2">The number of pictures displayed per page. This can be changed ';
		print 'individually using ?pp=x in the url. Set both min and max to the standard value to disable.</td></tr>'."\n";
		print '<tr><td class="nametd">Pages:</td>'."\n";
		print '<td style="text-align: left;">Standard: <input type="text" name="pp_std" value="'.$set['pics_pp'].'" style="width: 20px;"> ';
		print 'Min: <input type="text" name="pp_min" value="'.$set['pp_range'][0].'" style="width: 20px;"> ';
		print 'Max: <input type="text" name="pp_max" value="'.$set['pp_range'][1].'" style="width: 20px;"></td></tr>'."\n";
		
		// Folders
		$temp = '';
		if ($set['all_folders'])
			$temp = ' checked';
		print '<tr><td class="desctr" colspan="2">Show all folders in the picy gallery instead of only those with a .pcx ';
		print 'extension? The extension can still be used to override the theme.</td></tr>'."\n";
		print '<tr><td class="nametd"></td>'."\n";
		print '<td style="text-align: left;"><input type="checkbox" name="folders"'.$temp.'> Show All Folders</td></tr>'."\n";
		
		// Thumbnails
		$temp = '';
		if ($set['make_thmbs'])
			$temp = ' checked';
		print '<tr><td class="desctr" colspan="2">Create thumbnails? picy will automatically create thumbnails for ';
		print 'any image it encounters. Thumbnails only need to be created once.</td></tr>'."\n";
		print '<tr><td class="nametd"></td>'."\n";
		print '<td style="text-align: left;"><input type="checkbox" name="thumbnails"'.$temp.'> Create Thumbnails</td></tr>'."\n";
		
		// Thumbnail size
		print '<tr><td class="desctr" colspan="2">Target size in pixel for created thumbnails.<br />';
		print 'Format: WidthxHeigth</td></tr>'."\n";
		print '<tr><td class="nametd">Thumbnail Size:</td>'."\n";
		print '<td><input type="text" name="tmb_size" value="'.implode('x',$set['tmb_size']).'" style="width: 400px;"></td></tr>'."\n";
		
		print '<tr><td colspan="2"><input type="submit" name="ssub" value="Save">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($settings)).'"></td></tr>'."\n";
		print '</table></form>'."\n";
		cfooter ();
		
	} else {
		
		// Verify data
		$upd = array ();
		
		// Image Types
		$upd['img_exts'] = 'array (\''.str_replace (',','\',\'',$_POST['img_types']).'\')';
		
		// Hotlink protection
		if ($_POST['img_hotprot'] == 'none') {
			$upd['img_hotprot'] = 'false';
			$upd['img_passthru'] = 'false';
		} else {
			$upd['img_hotprot'] = 'true';
			$upd['img_passthru'] = 'true';
			$upd['img_hp_type'] = "'".$_POST['img_hotprot']."'";
		}
		
		// MIME Types
		$temp = explode (',',$_POST['mime_types']);
		for ($i=0;$i<count($temp);$i++) {
			$temp2 = explode (':',$temp[$i]);
			$temp3[] = "'".$temp2[0]."'=>'".$temp2[1]."'";
		}
		$upd['mime_types'] = "array (".implode(',',$temp3).")";
		
		// Pictures per page
		if (!is_numeric ($_POST['pp_std']) || $_POST['pp_std'] < 1)
			error ('No sane value for Pages: Standard.');
		if (!is_numeric ($_POST['pp_max']) || $_POST['pp_max'] < 1)
			error ('No sane value for Pages: Max.');
		if (!is_numeric ($_POST['pp_min']) || $_POST['pp_min'] < 1)
			error ('No sane value for Pages: Min.');
		$upd['pics_pp'] = $_POST['pp_std'];
		$upd['pp_range'] = "array (".$_POST['pp_min'].",".$_POST['pp_max'].")";
		
		// Folders
		if (isset ($_POST['folders'])) {
			$upd['all_folders'] = 'true';
		} else {
			$upd['all_folders'] = 'false';
		}
		
		// Thumbnails
		if (isset ($_POST['thumbnails'])) {
			$upd['make_thmbs'] = 'true';
		} else {
			$upd['make_thmbs'] = 'false';
		}
		
		// Thumbnail size
		$temp = explode ('x',$_POST['tmb_size']);
		if (count ($temp) != 2 || !is_numeric ($temp[0]) || !is_numeric ($temp[1]))
			error ('Thumbnail sizes not sane.');
		
		// Write changes to array
		reset ($settings);
		for ($i=0;$i<count($settings);$i++) {
			if (isset ($upd[$settings[$i]['name']])) {
				$settings[$i]['value'] = $upd[$settings[$i]['name']];
			}
		}
		
		// Save
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
		
	}

} elseif ($_GET['func'] == 'thmsetup') {
	
	// ---------------------------------------------------
	// -- 3. THEME SETUP ---------------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['tssub'])) {
		
		$set = array ();
		eval ($raw_settings);
		
		cheader ('.desctr {
			background-color: #fff;
			text-align: left;
			color: #666;
		}
		.nametd {
			width: 100px;
			text-align: left;
		}
		.titletr td {
			padding-bottom: 10px;
		}');
		print '<p class="subtitle">Theme Setup</p>'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func=thmsetup">';
		print '<table style="width: 100%;">'."\n";
		
		print '<tr><td class="desctr" colspan="2">The standard theme. This can be overwritten using ?thm=x in the URL (if enabled) ';
		print 'or the extension .pcx on folders.</td></tr>'."\n";
		print '<tr><td class="nametd">Standard:</td>'."\n";
		print '<td><input type="text" name="cthm" value="'.$set['cthm'].'" style="width: 400px;"></td></tr>'."\n";
		
		$c = '';
		if ($set['user_thm'])
			$c = ' checked';
		print '<tr><td class="desctr" colspan="2">If enabled, the theme can be changed using ?thm=x in the URL.</td></tr>'."\n";
		print '<tr><td class="nametd"></td>'."\n";
		print '<td style="text-align: left;"><input type="checkbox" name="user_thm"'.$c.'> Theme URL-overrideable</td></tr>'."\n";
		print '<tr><td class="desctr" colspan="2">Theme used for IE users instead of the standard one. Leave empty to disable.</td></tr>'."\n";
		print '<tr><td class="nametd">IE Theme:</td>'."\n";
		print '<td style="text-align: left;"><input type="text" name="ie_override" value="'.$set['iethm'].'" style="width: 400px;"></td></tr>'."\n";
		
		print '</table><hr class="line">'."\n";
		print '<table style="width: 100%">'."\n";
		print '<tr class="desctr"><td colspan="2">In order to be used by picy, a theme has to be listed in the theme array ';
		print 'and then can be used with the array index. A theme can either be an external file or embedded in the picy script.<br />';
		print 'Set type to empty to remove an entry.</td></tr>';
		
		for ($i=0;$i<count($set['themes']);$i++) {
			
			$int = ''; $ext = '';
			if ($set['themes'][$i][0] == THM_INT) {
				$int = ' selected';
			} else {
				$ext = ' selected';
			}
			
			print '<tr style="background-color: #fff;"><td style="width: 20px">'.$i.':</td>'."\n";
			print '<td>Type: <select name="'.$i.'type"><option value="none"></option><option value="1"'.$int.'>Internal</option>'."\n";
			print '<option value="0"'.$ext.'>External</option></select>'."\n";
			print 'Path/Name: <input type="text" name="'.$i.'pn" value="'.$set['themes'][$i][1].'" style="width: 260px;"></tr>';
			
		}
		
		print '<tr style="background-color: #fff;"><td style="width: 20px">'.$i.':</td>'."\n";
		print '<td>Type: <select name="newtype"><option value="none"></option><option value="1">Internal</option>'."\n";
		print '<option value="0">External</option></select>'."\n";
		print 'Path/Name: <input type="text" name="newpn" style="width: 260px;"></tr>';
		print '</table><br />';
		
		print '<input type="submit" name="tssub" value="Save">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($settings)).'">'."\n";
		print '</form>'."\n";
		cfooter ();
		
	} else {
		
		// function to locate theme in array
		function theme_exists ($sname) {
			global $themes;
			for ($i=0;$i<count($themes);$i++) {
				if ($themes[$i]['short'] == $sname)
					return true;
			}
			return false;
		}
		
		// Verify and save changes
		if (!is_numeric ($_POST['cthm']))
			error ('Standard theme index has to be a number.');
		
		if (isset ($_POST['user_thm'])) {
			$upd['user_theme'] = 'true';
		} else {
			$upd['user_theme'] = 'false';
		}
		
		if (trim ($_POST['ie_override']) != '' && !is_numeric ($_POST['ie_override']))
			error ('The IE Theme field must contain a number or be empty.');
		
		if (trim ($_POST['ie_override']) != '') {
			$upd['iethm'] = $_POST['ie_override'];
		 } else {
		 	$upd['iethm'] = 'false';
		 }
		
		// Loop through theme array
		$i = 0;
		$parts = array ();;
		while (isset ($_POST[$i.'type'])) {
			if ($_POST[$i.'type'] != 'none') {
				$out = 'array (';
				if ($_POST[$i.'type'] == 1) {
					if (!theme_exists ($_POST[$i.'pn']))
						error ('Internal theme "'.$_POST[$i.'pn'].'" not found.');
					$out .= 'THM_INT,';
				 } else {
				 	if (!file_exists ($_POST[$i.'pn']))
						error ('External theme "'.$_POST[$i.'pn'].'" not found.');
				 	$out .= 'THM_EXT,';
				 }
				 $out .= "'".$_POST[$i.'pn']."')";
				 $parts[] = $out;
			}
			$i++;
		}
		// New Theme entry
		if ($_POST['newtype'] != 'none') {
			$out = 'array (';
			if ($_POST['newtype'] == 1) {
				if (!theme_exists ($_POST['newpn']))
					error ('Internal theme "'.$_POST['newpn'].'" not found.');
				$out .= 'THM_INT,';
			 } else {
				if (!file_exists ($_POST['newpn']))
					error ('External theme "'.$_POST['newpn'].'" not found.');
				$out .= 'THM_EXT,';
			 }
			 $out .= "'".$_POST['newpn']."')";
			 $parts[] = $out;
		}
		// Finalize
		$upd['themes'] = "array (".implode(',',$parts).")";
		
		if ($_POST['cthm'] > count($parts)-1)
			error ('Standard theme index is non-existant.');
		$upd['cthm'] = $_POST['cthm'];
		
		// Write changes to array
		reset ($settings);
		for ($i=0;$i<count($settings);$i++) {
			if (isset ($upd[$settings[$i]['name']])) {
				$settings[$i]['value'] = $upd[$settings[$i]['name']];
			}
		}
		
		// Save
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
	}
	
} elseif ($_GET['func'] == 'rawsettings') {
	
	// ---------------------------------------------------
	// -- 3. RAW SETTINGS --------------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['ssub'])) {
		
		cheader ('.desctr {
			background-color: #fff;
			text-align: left;
			color: #666;
		}
		.nametd {
			width: 100px;
			text-align: left;
		}
		.titletr td {
			padding-bottom: 10px;
		}');
		print '<p class="subtitle">Settings</p>'."\n";
		print '<span style="font-size: 10px;"><b>Note:</b> All settings need to be '."\n";
		print 'parseable by PHP.<br />Don\'t leave any field empty. Use empty string (\'\') or 0 instead.</span><br /><br />'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func=rawsettings">'."\n";
		print '<table style="width: 100%;">'."\n";
		for ($i=0;$i<count($settings);$i++) {
			if (!isset ($settings[$i]['group'])) {
				print '<tr class="desctr"><td colspan="2">'.nl2br($settings[$i]['desc']).'</td></tr>'."\n";
				print '<tr class="opttr"><td class="nametd">'.$settings[$i]['name'].':</td>';
				print '<td><input type="text" value="'.$settings[$i]['value'].'" name="val'.$i.'" style="width: 100%;" />';
				print '<input type="hidden" name="name'.$i.'" value="'.$settings[$i]['name'].'" /></td></tr>'."\n";
				print '<tr><td colspan="2"><hr class="line"></td></tr>';
			} else {
				print '<tr class="titletr"><td colspan="2" class="subtitle">--- '.$settings[$i]['group'].' ---</td></tr>';
			}
		}
		print '<tr><td colspan="2"><input type="submit" name="ssub" value="Save">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($settings)).'"></td></tr>'."\n";
		print '</table></form>'."\n";
		cfooter ();
		
	} else {
		
		// check hash
		if (md5(serialize($settings)) != $_POST['hash'])
			error ('The picy script file has been modified - settings cannot be saved.');
		
		// undo magic quotes
		if (get_magic_quotes_gpc ()) {
			foreach ($_POST as $key => $val) {
				$_POST[$key] = stripslashes ($val);
			}
		}
		
		for  ($i=0;$i<count($settings);$i++) {
			$settings[$i]['value'] = $_POST['val'.$i];
		}
		
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
	
	}
	
} elseif ($_GET['func'] == 'ethm' || $_GET['func'] == 'newthm') {
	
	// ---------------------------------------------------
	// -- 4. EDIT / NEW THEME ----------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['tsub'])) {
		
		$title = array ('ethm'=>'Edit','newthm'=>'New');
		
		// load data
		if ($_GET['func'] == 'ethm') {
			if (!isset ($themes[$_GET['id']]))
				error ('Theme not found.');
			$name = $themes[$_GET['id']]['name'];
			$short = $themes[$_GET['id']]['short'];
			$data = $themes[$_GET['id']]['data'];
		} else {
			$name = '';
			$short = '';
			$data = '';
		}
		
		cheader ('.nametd {
			width: 100px;
			text-align: left;
		}');
		print '<p class="subtitle">'.$title.' Theme</p>'."\n";
		print '<span style="font-size: 10px;"><b>Note:</b> Theme data has to standard PHP code. A syntax ';
		print 'error will stop picy from running.</span><br /><br />'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func='.$_GET['func'].'&id='.$_GET['id'].'">'."\n";
		print '<table style="width: 100%;">'."\n";
		print '<tr class="opttr"><td class="nametd">Name:</td>';
		print '<td><input type="text" value="'.$name.'" name="name" style="width: 100%;" /></td></tr>'."\n";
		print '<tr class="opttr"><td class="nametd">Short Name:</td>';
		print '<td><input type="text" value="'.$short.'" name="short" style="width: 100%;" /></td></tr>'."\n";
		print '<tr><td colspan="2"><textarea name="data" style="width: 100%; height: 300px;">'.$data.'</textarea></td></tr>';
		print '<tr><td colspan="2"><input type="submit" name="tsub" value="Save">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($themes)).'"></td></tr>'."\n";
		print '</table></form>'."\n";
		cfooter ();
		
	} else {
		
		// check hash
		if (md5(serialize($themes)) != $_POST['hash'])
			error ('The picy script file has been modified - theme cannot be saved.');
		
		// undo magic quotes
		if (get_magic_quotes_gpc ()) {
			foreach ($_POST as $key => $val) {
				$_POST[$key] = stripslashes ($val);
			}
		}
		
		if ($_GET['func'] == 'ethm') {
			$themes[$_GET['id']]['name'] = $_POST['name'];
			$themes[$_GET['id']]['short'] = $_POST['short'];
			$themes[$_GET['id']]['data'] = $_POST['data'];
		} else {
			$themes[] = array ('name'=>$_POST['name'],'short'=>$_POST['short'],'data'=>$_POST['data']);
		}
		
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
		
	}
	
} elseif ($_GET['func'] == 'dthm') {
	
	// ---------------------------------------------------
	// -- 5. DELETE THEME --------------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['tsub'])) {
		
		if (!isset ($themes[$_GET['id']]))
			error ('Theme not found.');
		
		cheader ('.nametd {
			width: 100px;
			text-align: left;
		}');
		print '<p class="subtitle">Delete Theme</p>'."\n";
		print '<span style="font-size: 10px;"><b>Note:</b> Make sure the theme you delte is not in use.<br />';
		print 'The main theme ($set[\'cthm\']) should not be deleted.</span><br /><br />'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func='.$_GET['func'].'&id='.$_GET['id'].'">'."\n";
		print 'Do you really want to delete the theme <b>"'.$themes[$_GET['id']]['name'].'"</b>?<br /><br />'."\n";
		print '<input type="submit" name="tsub" value="Yes!">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($themes)).'">'."\n";
		print '</form>'."\n";
		cfooter ();
		
	} else {
		
		// check hash
		if (md5(serialize($themes)) != $_POST['hash'])
			error ('The picy script file has been modified - theme cannot be saved.');
		
		unset ($themes[$_GET['id']]);
		$themes = array_values ($themes);
		
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
		
	}

} elseif ($_GET['func'] == 'expthm') {
	
	// ---------------------------------------------------
	// -- 5. EXPORT THEME --------------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['tsub'])) {
		
		if (!isset ($themes[$_GET['id']]))
			error ('Theme not found.');
		cheader ('.nametd {
			width: 100px;
			text-align: left;
		}');
		print '<p class="subtitle">Delete Theme</p>'."\n";
		print '<span style="font-size: 10px;"><b>Note:</b> Make sure the output path is writeable.</span><br /><br />'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func='.$_GET['func'].'&id='.$_GET['id'].'">'."\n";
		print 'Output path (with filename):<br ><input type="text" name="path" style="width: 400px;"><br />'."\n";
		print '<br /><input type="submit" name="tsub" value="Export">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($themes)).'">'."\n";
		print '</form>'."\n";
		cfooter ();
		
	} else {
		
		if (file_exists ($_POST['path']))
			error ('Output file already exists.');
		
		$file = fopen ($_POST['path'],'w+');
		if ($file === false)
			error ('Couldn\'t open file for writing.');
		
		$out = "<?php\n";
		$out .= "// <!! short=".$themes[$_GET['id']]['short'].";name=".$themes[$_GET['id']]['name']."; !!>\n\n";
		$out .= $themes[$_GET['id']]['data']."\n\n?>";
		
		$err = fwrite ($file,$out);
		if (!$err)
			error ('Couldn\'t write to output.');
		
		fclose ($file);
		
		cheader ();
		print 'Theme exported to "'.$_POST['path'].'".';
		cfooter ();
		
	}
	
} elseif ($_GET['func'] == 'instthm') {
	
	// ---------------------------------------------------
	// -- 6. INSTALL THEME -------------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['tsub'])) {
		
		cheader ('.nametd {
			width: 100px;
			text-align: left;
		}');
		print '<p class="subtitle">Delete Theme</p>'."\n";
		print '<span style="font-size: 10px;"><b>Note:</b> The file specified has to be a valid picy theme file.</span><br /><br />'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func='.$_GET['func'].'&id='.$_GET['id'].'">'."\n";
		print 'Relative path to the theme file:<br />'."\n";
		print '<input type="text" name="path" style="width: 350px;"><br /><br />';
		print '<input type="submit" name="tsub" value="Install">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($themes)).'">'."\n";
		print '</form>'."\n";
		cfooter ();
		
	} else {
		
		// check hash
		if (md5(serialize($themes)) != $_POST['hash'])
			error ('The picy script file has been modified - theme cannot be saved.');
		
		// undo magic quotes
		if (get_magic_quotes_gpc ()) {
			foreach ($_POST as $key => $val) {
				$_POST[$key] = stripslashes ($val);
			}
		}
		
		if (!file_exists ($_POST['path']))
			error ('Couldn\'t find theme file.');
		
		if (!is_readable ($_POST['path']))
			error ('File is not readable.');
		
		$file = fopen ($_POST['path'],'r');
		
		if ($file === false)
			error ('Couldn\' open file.');
		
		$matches = array ();
		for ($i=0;$i<3;$i++) {
			if (preg_match ('/\/\/ <!! short=([^;]+);name=([^;]+); !!>/',fgets($file),$matches))
				break;
		}
		
		if (count ($matches) == 0)
			error ('Not valid picy theme file.');
		
		$data = '';
		while (!feof ($file)) {
			$data .= fgets ($file);
		}
		
		// remove last ? >
		$tmp = explode ('?>',$data);
		if (trim ($tmp[count($tmp)-1]) != '')
			error ('Error parsing theme file.');
		array_pop ($tmp);
		$data = implode ('?>',$tmp);
		
		for ($i=0;$i<count($themes);$i++) {
			if ($themes[$i]['short'] == $matches[1])
				error ('Theme with this short name already exists.');
		}
		
		$themes[] = array ('name'=>$matches[2],'short'=>$matches[1],'data'=>$data);
		
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
		
	}
	
} elseif ($_GET['func'] == 'dpic') {
	
	// ---------------------------------------------------
	// -- 7. DELETE PICTURE ------------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['tsub'])) {
		
		if (!isset ($pictures[$_GET['id']]))
			error ('Picture not found.');
		
		cheader ('.nametd {
			width: 100px;
			text-align: left;
		}');
		print '<p class="subtitle">Delete Picture</p>'."\n";
		print '<img src="'.$cset['script'].'?dp='.$pictures[$_GET['id']]['name'].'" alt="Picture" /><br /><br />';
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func='.$_GET['func'].'&id='.$_GET['id'].'">'."\n";
		print 'Do you really want to delete the picture <b>"'.$pictures[$_GET['id']]['name'].'"</b>?<br /><br />'."\n";
		print '<input type="submit" name="tsub" value="Yes!">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($pictures)).'">'."\n";
		print '</form>'."\n";
		cfooter ();
		
	} else {
		
		// check hash
		if (md5(serialize($pictures)) != $_POST['hash'])
			error ('The picy script file has been modified - picture cannot be saved.');
		
		unset ($pictures[$_GET['id']]);
		$pictures = array_values ($pictures);
		
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
		
	}

} elseif ($_GET['func'] == 'instpic') {
	
	// ---------------------------------------------------
	// -- 8. INSTALL PICTURE -----------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['tsub'])) {
		
		cheader ('.nametd {
			width: 100px;
			text-align: left;
		}');
		print '<p class="subtitle">Install Picture</p>'."\n";
		print '<span style="font-size: 10px;"><b>Note:</b> The script will guess the right MIME types from the ';
		print 'file extension<br /> for JPEG, GIF and PNG files. Other types you have to enter yourself.<br />';
		print 'It shouldn\'t be necessary to specify a mime type for uploaded pictures.</span><br /><br />'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func='.$_GET['func'].'&id='.$_GET['id'].'" enctype="multipart/form-data">'."\n";
		print 'Relative path to the picture (URL is also possible):<br />'."\n";
		print '<input type="text" name="path" style="width: 350px;" /><br />'."\n";
		print '-- or --<br />upload one:<br />'."\n";
		print '<input type="file" name="file"><br /><br />'."\n";
		print 'Name: <input type="text" name="name" style="width: 200px;" /><br />'."\n";
		print 'MIME-Type: <input type="text" name="mime" style="width: 200px;" /><br /><br />'."\n";
		print '<input type="submit" name="tsub" value="Install">';
		print '<input type="hidden" name="hash" value="'.md5(serialize($themes)).'">'."\n";
		print '</form>'."\n";
		cfooter ();
		
	} else {
		
		// check hash
		if (md5(serialize($themes)) != $_POST['hash'])
			error ('The picy script file has been modified - picture cannot be saved.');
		
		// undo magic quotes
		if (get_magic_quotes_gpc ()) {
			foreach ($_POST as $key => $val) {
				$_POST[$key] = stripslashes ($val);
			}
		}
		
		if (trim ($_GET['path']) == '' && !isset ($_FILES['file']))
			error ('Neither path specified nor file uploaded.');
		
		// guess mime type for non-uploaded files
		if (trim ($_POST['path']) != '') {
			$ext = strtolower (preg_replace ('/(.*)(\.)([^.]+)$/','\3',basename($_POST['path'])));
			$types = array ('jpg'=>'image/jpeg','jpeg'=>'image/jpeg','gif'=>'image/gif','png'=>'image/png');
			if (!array_key_exists ($ext,$types) && trim ($_POST['mime']) == '')
				error ('Couldn\'t guess MIME type. Please specify one.');
			
			if (isset ($types[$ext])) {
				$mime = $types[$ext];
			} else {
				$mime = $_POST['mime'];
			}
		} else {
			if ($_FILES['file']['size'] == 0)
				error ('File upload failed.');
			$mime = $_FILES['file']['type'];
			$_POST['path'] = $_FILES['file']['tmp_name'];
		}
		
		if (trim ($_POST['name']) == '')
			error ('No name specified.');
		
		$data = '';
		$file = fopen ($_POST['path'],'rb');
		
		if ($file === false)
			error ('Couldn\'t open file.');
		
		while (!feof ($file) && $data !== false) {
			$data .= fread ($file,2048);
		}
		fclose ($file);
		
		if (trim ($data) == '')
			error ('Couldn\'t read picture.');
		
		$pictures[] = array ('name'=>$_POST['name'],'type'=>$mime,'data'=>base64_encode($data));
		
		write_file ();
		cheader ();
		print 'Changes have been saved to '.$cset['output'];
		cfooter ();
		
	}

} elseif ($_GET['func'] == 'htfile') {
	
	// ---------------------------------------------------
	// -- 9. INSTALL PICTURE -----------------------------
	// ---------------------------------------------------
	
	if (!isset ($_POST['hsub'])) {
		
		cheader ();
		print '<p class="subtitle">Create .htaccess File</p>'."\n";
		print '<span style="font-size: 10px;"><b>Note:</b> ';
		print 'With .htaccess files (on an Apache server) you can block images from being accessed directly. '."\n";
		print 'Any file ending with a file extension you specify will be blocked (e.g. entering '."\n";
		print 'http://www.yourhost.com/picydir/pic.jpg would result in an "403 forbidden" page). Since picy is able to '."\n";
		print 'tunnel pictures, they will still appear in picy. Use this together with picy\'s hotlink protection '."\n";
		print ' (otherwise it\'s not that useful).<br />'."\n";
		print '<b>Any existing htaccess file will be overwritten!</b></span><br /><br />'."\n";
		print '<form method="post" action="'.$_SERVER['PHP_SELF'].'?func=htfile">'."\n";
		print '<div style="text-align: left; margin: 0px auto 0px auto; width: 100px;">'."\n";
		print '<input type="checkbox" name="jpg" value="true"> jpg, jpeg<br />'."\n";
		print '<input type="checkbox" name="gif" value="true"> gif<br />'."\n";
		print '<input type="checkbox" name="png" value="true"> png'."\n";
		print '</div><br /><br />'."\n";
		print 'Others (separate them with "|"):<br />'."\n";
		print '<input type="text" name="others" style="width: 225px;"><br /><br />'."\n";
		print 'Folder (relative path):<br />'."\n";
		print '<input type="text" name="folder" style="width: 225px;"><br /><br />'."\n";
		print '<input type="submit" name="hsub" value="Create">'."\n";
		print '</form>'."\n";
		cfooter ();
		
	} else {
		
		if (trim ($_POST['folder']) == '')
			error ('No output folder specified.');
		
		if (!isset ($_POST['jpg']) &&
			!isset ($_POST['gif']) &&
			!isset ($_POST['png']) &&
			trim ($_POST['others']) == '')
			error ('Nothing selected.');
		
		if (!is_dir ($_POST['folder']))
			error ('Not a folder.');
		
		if (!is_writable ($_POST['folder']))
			error ('Cannot write to that folder. chmod it to 777.');
		
		$formats = array ();
		if (isset ($_POST['jpg'])) {
			$formats[] = 'jpg';
			$formats[] = 'jpeg'; }
		if (isset ($_POST['gif']))
			$formats[] = 'gif';
		if (isset ($_POST['png']))
			$formats[] = 'png';
		if (trim ($_POST['others']) != '')
			$formats[] = $_POST['others'];
		
		$formats = implode ('|',$formats);
		
		$htdata = '<FilesMatch "\.('.$formats.')$">'."\n";
		$htdata .= 'order allow,deny'."\n";
		$htdata .= 'deny from all'."\n";
		$htdata .= '</FilesMatch>';
		
		$file = fopen ($_POST['folder'].'/.htaccess','w+');
		
		if ($file === false)
			error ('Couldn\'t open folder.');
		
		if (!fwrite ($file,$htdata))
			error ('Couldn\'t write to folder.');
		
		cheader ();
		print '.htaccess file has been written in '.$_POST['folder'];
		cfooter ();
		
	}
	
}

// ---------------------------------------------------
// -- 10. FUNCTIONS ----------------------------------
// ---------------------------------------------------

function error ($txt) {
	cheader ();
	print 'Error: '.$txt;
	cfooter ();
	exit;
}

function parse_file () {
	global $cset,$settings,$themes,$pictures,$raw_settings,$buffer,$c_compat;
	
	// Try to open script file
	if (!file_exists ($cset['script']))
		error ('picy script not found.');
	
	if (!is_readable ($cset['script']) && !is_writable ($cset['script']))
		error ('Not enough permission to access script.');
	
	$script = fopen ($cset['script'],'r');
	
	if (!$script)
		error ('Failed to open script file.');
	
	// Verify script
	$ps = false;
	$matches = array ();
	$buffer = '';
	for ($i=1;$i<=3 && !feof($script);$i++) {
		$line = fgets ($script);
		$buffer .= $line;
		if (preg_match ('/<!! picy_version=(\d+\.\d+); !!>/',$line,$matches)) {
			$ps = true;
			break;
		}
	}
	
	if (!$ps)
		error ('No valid picy script file.');
	
	$script_version = $matches[1];
	
	if (!in_array ($script_version,$c_compat))
		error ('This script only works with picy versions '.implode(', ',$c_compat));
	
	// Parse
	$matches = array ();
	$curr = 'normal';
	$types = array ('settings','themes','pictures');
	$settings = array ();
	$spos = 0;
	$themes = array ();
	$tpos = 0;
	$cthm = '';
	$pictures = array ();
	$ppos = 0;
	$cpic = '';
	$raw_settings = '';
	
	while (!feof ($script)) {
		
		// Read line
		$line = fgets ($script);
		
		if ($curr == 'normal') {
			
			// Check for start tag
			if (preg_match ('/^\/\/ <!! type=([^;]+);/',$line,$matches)) {
				if (!in_array ($matches[1],$types))
					error ('Not a valid type: '.$matches[1]);
				$curr = $matches[1];
				$buffer .= '<!! '.$matches[1].' !!>';
			} else {
				$buffer .= $line;
			}	
			
		} else {
			
			// Check for end tag
			if (preg_match ('/^\/\/ !!>/',$line,$matches)) {
				$curr = 'normal';
				continue;
			}
			
			if ($curr == 'settings') {
				
				// parse settigs
				if (trim($line) == "") {
					continue;
				} elseif (preg_match ('/\/\/ [#]{2} (.+) [#]{2,}/',$line,$matches)) {
					$settings[$spos]['group'] = $matches[1];
					$spos++;
				} elseif (preg_match ('/\/\/[ 	]+(.+)$/',$line,$matches)) {
					$settings[$spos]['desc'] .= $matches[1]."\n";
				} elseif (preg_match ('/\$set\[\'([^\']+)\'\] = ([^;]+);/',$line,$matches)) {
					$settings[$spos]['name'].= $matches[1];
					$settings[$spos]['value'] = $matches[2];
					$spos++;
				} else {
					error ("Couldn't parse settings line:\n<br />".$line);
				}
				
				$raw_settings .= $line;
				
			} elseif ($curr == 'themes') {
				
				// parse themes
				if (trim($line) == "") {
					continue;
				} elseif ($cthm == '') {
					if (preg_match ('/^\/\/ <! short=([^;]+);name=([^;]+);/',$line,$matches)) {
						$cthm = $matches[1];
						$themes[$tpos]['short'] = $matches[1];
						$themes[$tpos]['name'] = $matches[2];
					}
				} elseif (preg_match ('/^\/\/ !>/',$line)) {
					$cthm = '';
					$tpos++;
				} else {
					$themes[$tpos]['data'] .= $line;
				}
			
			} elseif ($curr == 'pictures') {
				
				// parse images
				if (trim($line) == "") {
					continue;
				} elseif ($cpic == '') {
					if (preg_match ('/^\/\/ <! name=([^;]+);/',$line,$matches)) {
						$cpic = $matches[1];print $name;
						$pictures[$ppos]['name'] = $matches[1];
					}
				} elseif (preg_match ('/^\/\/ !>/',$line)) {
					$cpic = '';
					$ppos++;
				} elseif (preg_match ('/[	 ]*header[ ]?\(\'Content-type: ([^\']+)\'\);/',$line,$matches)) {
					$pictures[$ppos]['type'] = $matches[1];
				} elseif (preg_match ('/[	 ]*print base64_decode[ ]?\(\'([^\']+)\'\);/',$line,$matches)) {
					$pictures[$ppos]['data'] = $matches[1];
				} else {
					error ("Couldn't parse pictures line:\n<br />".$line);
				}
			
			} else {
				error ('No handler defined for type '.$curr);
			}
			
		}
		
	}
}

function write_file () {
	
	global $cset,$settings,$themes,$pictures,$raw_settings,$buffer;
	
	$s_out = '';
	$t_out = '';
	$p_out = '';
	
	// generate file contents
	// settings:
	for ($i=0;$i<count($settings);$i++) {
		if (!isset ($settings[$i]['group'])) {
			if (trim ($settings[$i]['desc']) != '')
				$s_out .= "\n// ".preg_replace ("/[\n\r]+(?!$)/","\n// ",$settings[$i]['desc']);
			$s_out .= "\n\t\$set['".$settings[$i]['name']."'] = ".$settings[$i]['value'].";";
		} else {
			$s_out .= "\n\n// ## ".$settings[$i]['group']." ##########################################\n";
		}
	}
	$s_out = "// <!! type=settings;".$s_out."\n\n// !!>\n";
	
	// themes
	if (count ($themes) != 0) {
		$ec = "\t";
		for ($i=0;$i<count($themes);$i++) {
			$t_out .= $ec."if (\$tname == '".$themes[$i]['short']."') {\n\n";
			$t_out .= "// <! short=".$themes[$i]['short'].";name=".$themes[$i]['name'].";\n\n";
			$t_out .= $themes[$i]['data'];
			$t_out .= "\n\n// !>\n\n";
			$ec = "\t} else";
		}
		$t_out .= "\t}";
		$t_out = "// <!! type=themes;\n\n".$t_out."\n\n// !!>\n";
	}
	
	// pictures
	if (count ($pictures) != 0) {
		$ec = "\t";
		for ($i=0;$i<count($pictures);$i++) {
			$p_out .= $ec."if (\$p == '".$pictures[$i]['name']."') {\n";
			$p_out .= "// <! name=".$pictures[$i]['name'].";\n";
			$p_out .= "\theader ('Content-type: ".$pictures[$i]['type']."');\n";
			$p_out .= "\tprint base64_decode ('".$pictures[$i]['data']."');\n";
			$p_out .= "// !>\n";
			$ec = "\t} else";
		}
		$p_out .= "\t}";
		$p_out = "// <!! type=pictures;\n\n".$p_out."\n\n// !!>\n";
	}
	
	// put together
	$buffer = str_replace ('<!! settings !!>',$s_out,$buffer);
	$buffer = str_replace ('<!! themes !!>',$t_out,$buffer);
	$buffer = str_replace ('<!! pictures !!>',$p_out,$buffer);
	
	// make backup?
	if ($cset['backup']) {
		if (!copy ($cset['script'],$cset['script'].'.bck'))
			error ('Couldn\'t create backup.');
	}
	
	// write
	$file = fopen ($cset['output'],'w+');
	
	if ($file === false)
		error ('Couldn\'t open output file for writing.');
	
	$err = fwrite ($file,$buffer);
	
	if ($err === false)
		error ('Couldn\'t write to output file.');
	
	fclose ($file);
	
}

function cheader ($classes='') {
	global $picy_cversion;
	
	print '<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>picy configurator - '.$picy_cversion.'</title>
<link rel="shortcut icon" href="'.$_SERVER['PHP_SELF'].'?dp=icon" />
<style type="text/css">
<!--
body {
	font-family: Verdana; 
	font-size: 12px;
	color: #000; 
	background-color: #fff;
	text-align: center;
}
a:Link {
	text-decoration: none;
	color: #5555bb;
}
a:Visited {
	text-decoration: none;
	color: #bb5555;
}
a:Hover {
	text-decoration: underline;
}
.title {
	font-weight: bold;
	font-size: 16px;
}
.subtitle {
	font-weight: bold;
	font-size: 14px;
}
#pictbl {
	margin: 0px auto 0px auto;
	border: 1px solid #666;
	padding: 5px;
	background-color: #fafafa;
	clear: both;
}
.line {
	border: 0px solid;
	border-top: 1px dashed #999;
}
#links {
	float: right;
	border: 1px solid #999;
	border-top: none;
	background-color: #fafafa;
	padding: 2px 10px;
}
'.$classes.'
-->
</style>
</head>

<body>
<p class="title">picy configurator</p>
<div style="width: 525px; margin: 0px auto 0px auto;">
<div id="pictbl">';
}

function cfooter () {
	global $picy_cversion,$cset;
	
	print '</div>
	<div id="links"><a href="'.$_SERVER['PHP_SELF'].'">Main</a> | <a href="'.$cset['script'].'">picy Main</a></div></div>
<p style="font-size: 10px; color: #999;"><br />picy configurator - '.$picy_cversion.'</p>
</body>
</html>';
}

?>