<?php
// <!! picy_version=0.7; !!>
// /-------------------------------------------------\
// | ############################################### |
// | # ------------------------------------------- # |
// | # --- Picy - a simple PHP folder gallery ---- # |
// | # ------------------------------------------- # |
// | ############################################### |
// | #       http://picy.infinitesimal.org/        # |
// | ############################################### |
// | #             2004 - Adrian Stutz            # |
// | #       This script is licensed unter a       # |
// | #          creative Commons License.          # |
// | #    http://creativecommons.org/licenses     # |
// | #              /by-nc-sa/2.0/de/              # |
// | #           adrian.stutz@gmail.com            # |
// | ############################################### |
// | #              Table of Contents:             # |
// | #            0. Settings (line 49)            # |
// | #              1. Init (line 114)             # |
// | #           2. Redirects (line 187)           # |
// | #         3. Misc Functions (line 217)        # |
// | #      4. Final Theme Function (line 262)     # |
// | #   5. Create Thumbnail Function (line 292)   # |
// | #        6. Is_pic Function (line 417)        # |
// | #       7. Get_files Function (line 436)      # |
// | #       8. Fill_info Function (line 470)      # |
// | #              9. Main (line 559)             # |
// | #      10. Compile Main Output (line 601)     # |
// | #         11. Image Viewer (line 726)         # |
// | #    12. Tunnel Picture Function (line 902)   # |
// | #     13. Warning For Ie Users (line 1023)    # |
// | #  14. Pictures Stored Interally (line 1041)  # |
// | #            15. Themes (line 1073)           # |
// | ############################################### |
// \-------------------------------------------------/

// Pre-init defenitions
define ('THM_INT',true,false);
define ('THM_EXT',false,false);

// Use following code to set the table picy_hp up:
/*
CREATE TABLE `picy` (
  `ip` tinytext NOT NULL,
  `key` tinytext,
  `pic` tinytext,
  PRIMARY KEY  (`ip`(11))
);
*/

// ---------------------------------------------------
// -- 0. SETTINGS ------------------------------------
// ---------------------------------------------------

// <!! type=settings;

// ## GENERAL ##########################################

// File extensions used for picy. All files with those extensions will show up in the gallery (should all be lowercase).
// - Options: jpg, gif, png, tiff, bmp, psd, ...
	$set['img_exts'] = array ('jpg','gif','png');
// Pass images thru picy?
// - Options: true or false
	$set['img_passthru'] = false;
// mime types used for those file extensions (used only if image passthru is enabled)
// - Options: all extensions used for $img_ext, find official mime types @ http://www.iana.org/assignments/media-types/image/
	$set['mime_types'] = array ('jpg'=>'image/jpeg','gif'=>'image/gif','png'=>'image/png');
// Secure passed pictures from hotlinking? (thumbnails and pics small than thumbnails will be excluded from this)
// - Options: true or false
	$set['img_hotprot'] = false;
// Hotlinking protection type
// - Options: 'file', 'mysql' or 'session'
	$set['img_hp_type'] = 'session';

// ## View ##########################################

// Display how many pictures per page?
// - Options: Positive non-decimal number from 1 to uselessly large
	$set['pics_pp'] = 9;
// Range for user selectable number of pics per page, set to 'array ($set['pics_pp'],$set['pics_pp']);' to disable.
// - Options: Two positive non-decimal numbers from 1 to uselessly large. First number must be smaller as or equal to the second
	$set['pp_range'] = array (3,30);
// Use internal picy viewer? If not, the picture will be shown normally (like entering it directly into the browser)
// - Options: true or false
	$set['use_viewer'] = true;
// Pad Strings to x chars where apropriate
// - Options: Positive non-decimal number from 1 to uselessly large
	$set['padlen'] = 18;
// Theme-override for IE users.
// - Options: false to turn it off or a theme index number
	$set['iethm'] = false;
// Theme type and name. You can specify more use them one subgalleries (.pcx, while x is the numerical index of the theme)
// - Options: array (x,y) where x is either THM_INT for internal and THM_EXT for external themes and y the name for filename
	$set['themes'] = array (array (THM_INT,'std'),array (THM_INT,'html401'));
// Standard theme to use
// - Options: Array index of the theme, positive non-decimal number including 0
	$set['cthm'] = 0;
// Theme user selectable (using thm=x in the url)
// - Options: true or false
	$set['user_thm'] = true;
// Display all folders in the gallery regardless of their extension?
// - Options: true or false
	$set['all_folders'] = false;

// ## Thumbnails ##########################################

// Create thumbnails? This will automatically try to create a thumbnail once a picture without one is found.
// - Options: true or false
	$set['make_thmbs'] = true;
// Thumbnail size. Aspect ratio will be retained, those are max values.
// - Options: array (x,y) where x is thumbnail width and y height.
	$set['tmb_size'] = array (150,150);
// What thumbnail creation method to use? If the array has more than one value, the latter one will be used if the first fails.
// - Options: 'gd' for internal php library (JPEG and PNG support, only GIF read support for PHP < 5 [see $set['gif_convto'] option]).'magick' for ImageMagick. 
// Has to be installed and proper path provided ($set['magick_path']). [http://www.imagemagick.org/]
	$set['tmb_method'] = array ('magick','gd');
// Path to the ImageMagick executables.
// - Options: String or empty string ('') if ImageMagick is installed global
	$set['magick_path'] = '';
// Normally, ImageMagick will create thumbnails in the same format as the original picture. If you want different formats for thumbnailsyou can specify them here.
// e.g. array ('gif'=>'png','tiff'=>'jpg'); would create png thumbnails for gif and jpg for tiff images.
// - Options: 'x'=>'y' where x is extension defined in $set['img_exts'] and y extension supported by ImageMagick
	$set['conv_types'] = array ();
// If you're using a GD version without GIF write support, you can specify here, what format thumbnails should be created in for GIF images.
// - Options: 'png' or 'jpeg'.
	$set['gif_convto'] = 'png';

// ## MySQL ##########################################

// MySQL options used for mysql image hotlinking (has to be activated by $set['img_hotprot'] and $img_ht_type.

	$set['mq_server'] = 'localhost';
	$set['mq_user'] = '';
	$set['mq_password'] = '';
	$set['mq_db'] = '';

// !!>

// ---------------------------------------------------
// -- 1. INIT ----------------------------------------
// ---------------------------------------------------

$picy_version = 'v0.7';
$msgs = array ();
$pics = array ();
// type names
$types = array (1 => 'GIF', 2 => 'JPG', 3 => 'PNG', 4 => 'SWF', 5 => 'PSD', 6 => 'BMP',
				7 => 'TIFF (intel byte order)', 8 => 'TIFF (motorola byte order)', 
				9 => 'JPC', 10 => 'JP2', 11 => 'JPX', 12 => 'JB2', 13 => 'SWC',
				14 => 'IFF', 15 => 'WBMP', 16 => 'XBM');
// load current folder
$folder = dirname ($_SERVER['SCRIPT_FILENAME']).'/';
$picy_root = dirname ($_SERVER['SCRIPT_FILENAME']);

// not root folder?
if (isset ($_GET['f']) && trim ($_GET['f']) != '') {
	// compile new path
	$fpath = str_replace ('..','',$_GET['f']);
	// enforce trailing slash
	if (substr ($fpath,-1) != '/')
		$fpath .= '/';
	$folder .= $fpath;
} else {
	$fpath = '';
}

// valid folder?
if (!file_exists ($folder) || !is_dir ($folder)) {
	$msgs[] = 'No valid directory.';
	error ();
}

// set theme
if ($fpath != '' && preg_match ('/(\.pc)(\d{1,2})$/',basename ($fpath))) {
	$set['cthm'] = preg_replace ('/(.*)(\.pc)(\d{1,2})$/','\3',basename ($fpath));
	if (!isset ($set['themes'][$set['cthm']])) {
		$set['cthm'] = 0;
		$msgs[] = 'Theme not found.';
	}
}

// prepare pass vars
$qps = array();
$passvars = array ('f','pp','offset','warnok');
foreach ($passvars as $pv) {
	if (isset ($_GET[$pv]))
		$qps[$pv] = $_GET[$pv];
}

// pp in range?
if (isset ($_GET['pp'])) {
	if ($_GET['pp'] < $set['pp_range'][0]) {
		$msgs[] = 'Pics per page value out of range (can be no less than '.$set['pp_range'][0].')';
		$set['pics_pp'] = $set['pp_range'][0];
	} elseif ($_GET['pp'] > $set['pp_range'][1]) {
		$msgs[] = 'Pics per page value out of range (can be no more than '.$set['pp_range'][1].')';
		$set['pics_pp'] = $set['pp_range'][1];
	} else {
		$set['pics_pp'] = (int)$_GET['pp'];
	}
}

// ie users
if ($set['iethm'] !== false 
	&& !isset ($_GET['warnok']) && !isset ($_GET['dp'])
	&& strpos ($_SERVER['HTTP_USER_AGENT'],'MSIE') !== false 
	&& strpos ($_SERVER['HTTP_USER_AGENT'],'Opera') === false) {
	$set['cthm'] = $set['iethm'];
}

// select theme
if ($set['user_thm'] && isset ($_GET['thm'])) {
	$set['cthm'] = (int)$_GET['thm'];
	if (!isset ($set['themes'][$set['cthm']])) {
		$set['cthm'] = 0;
		$msgs[] = 'Theme not found.';
	}
}

// ---------------------------------------------------
// -- 2. REDIRECTS -----------------------------------
// ---------------------------------------------------

// redirect for picture output
if (isset ($_GET['dp'])) {
	pass_pic ($_GET['dp']);
	exit;
}

// redirect for picture tunnel
if (isset ($_GET['pic'])) {
	tunnel_pic ($_GET['pic']);
	exit;
}

// redirect for viewer
if (isset ($_GET['view'])) {
	show_viewer ($_GET['view']);
	exit;
}

// ---------------------------------------------------
// -- 3. MISC FUNCTIONS ------------------------------
// ---------------------------------------------------

function pad_string ($str,$len=-1) {
	global $set;
	if ($len == -1)
		$len = $set['padlen'];
	if (strlen ($str) > $len) {
		$str = substr ($str,0,$len-3);
		$str .= '...';
	}
	return $str;
}

function make_query ($args) {
	global $qps;
	$temp = array_merge ($qps,$args);
	$qstr = '';
	foreach ($temp as $key => $var) {
		if ($var !== false)
			$qstr .= '&amp;'.$key.'='.$var;
	}
	return $qstr;
}

function error () {
	print_main ();
	exit;
}

function picy_mysql_conn () {
	global $set,$msgs;
	$connection = mysql_connect($set['mq_server'],$set['mq_user'],$set['mq_password']);
	if (!$connection) {
		$msgs[] = 'MySQL connection failed for picy hotlink protection.';
		error ();
	}
	$db = mysql_select_db($set['mq_db'],$connection);
	if (!$db) {
		$msgs[] = 'Couldn\'t select mysql DB for picy hotlink protection.';
		error ();
	}
}

// ---------------------------------------------------
// -- 4. FINAL THEME FUNCTION ------------------------
// ---------------------------------------------------

function print_main ($mainbit='',$mainwidth=525) {
	
	global $thm, $msgs, $set;
	if (!isset ($thm['html']))
		load_theme ($set['themes'][$set['cthm']][1],$set['themes'][$set['cthm']][0]);
	
	// header + errors
	if (count ($msgs) > 0) {
		$out_temp = array ();
		foreach ($msgs as $msg) {
			$out_temp[] = str_replace ('%%msg%%',$msg,$thm['msgs_bit']);
		}
		$msgbit = str_replace ('%%msgs%%',implode('',$out_temp),$thm['msgs']);
	} else {
		$msgbit = '';
	}
	
	$mainbit = $msgbit.$mainbit;
	
	// final output
	$html = str_replace ('%%res-name%%',basename($folder),$thm['html']);
	$html = str_replace ('%%main-width%%',$mainwidth,$html);
	print str_replace ('%%picy-main%%',$mainbit,$html);
	
}

// ---------------------------------------------------
// -- 5. CREATE THUMBNAIL FUNCTION -------------------
// ---------------------------------------------------

function make_thmb ($pfn) {
	
	global $msgs,$set,$types;
	
	$success = false;
	
	foreach ($set['tmb_method'] as $tm) {
	
		if ($tm == 'gd') {
			
			$info = getimagesize ($pfn);
			// get image types supported
			$gd_info = gd_info ();
			$handlers = array ();
			if ($gd_info['GIF Read Support'])
				$handlers[1] = 'imagecreatefromgif';
			if ($gd_info['JPG Support'])
				$handlers[2] = 'imagecreatefromjpeg';
			if ($gd_info['PNG Support'])
				$handlers[3] = 'imagecreatefrompng';
			$outh = array (1=>'imagegif',2=>'imagejpeg',3=>'imagepng');
			if (!$gd_info['GIF Create Support']) {
				$outh[1] = 'image'.$set['gif_convto'];
				$msgs[] = 'GIF image thumbnails will be converted to '.$set['gif_convto'].'.';
			}
			if (array_key_exists ($info[2],$handlers)) {
				// load image
				$func = $handlers[$info[2]];
				$img = $func ($pfn);
				if ($img == '') {
					$msgs[] = "GD: Image '".basename($pfn)."' could not be opened.";
					continue;
				}
				// determin resize factor
				if ($info[0] > $info[1]) {
					$factor = $set['tmb_size'][0]/$info[0];
				} else {
					$factor = $set['tmb_size'][1]/$info[1];
				}
				if ($factor > 1)
					$factor = 1;
				// thumbnail sizes
				$width = $info[0] * $factor;
				$height = $info[1] * $factor;
				// resize image
				$tmb = imagecreatetruecolor ($width,$height);
				imagecopyresampled ($tmb,$img,0,0,0,0,$width,$height,$info[0],$info[1]);
				// new filename
				$afn = basename ($pfn);
				$type = preg_replace ('/(.*)(\.)([^.]+)$/','\3',$afn);
				$fn = preg_replace ('/(.*)(\.)([^.]+)$/','\1',$afn).'.tmb.'.$type;
				// write thumbnail
				$func = $outh[$info[2]];
				@$func ($tmb,dirname($pfn).'/'.$fn);
				if (!file_exists (dirname($pfn).'/'.$fn)) {
					$msgs[] = "GD: Couldn't write thumbnail for '".$afn."'.";
					continue;
				} else {
					$msgs[] = "'".$afn."': Thumbnail created with GD.";
					$success = true;
					break;
				}
			} else {
				$msgs[] = "GD: Picture format '".$types[$info[2]]."' not supported for thumbnail creation.";
				continue;
			}
			
		} elseif ($tm == 'magick') {
			
			// compile new filename
			$afn = basename ($pfn);
			$type = preg_replace ('/(.*)(\.)([^.]+)$/','\3',$afn);
			if (!isset ($set['conv_types'][$type]))
				$set['conv_types'][$type] = $type;
			$fn = preg_replace ('/(.*)(\.)([^.]+)$/','\1',$afn).'.tmb.'.$set['conv_types'][$type];
			
			// do not upsample
			$info = getimagesize ($pfn);
			// determin resize factor
			if ($info[0] > $info[1]) {
				$factor = $set['tmb_size'][0]/$info[0];
			} else {
				$factor = $set['tmb_size'][1]/$info[1];
			}
			if ($factor > 1)
				$factor = 1;
			// thumbnail sizes
			$width = $info[0] * $factor;
			$height = $info[1] * $factor;
			
			// compile command
			$command = $set['magick_path'].'convert -size '.$width.'x'.$height.' "'.$pfn.'" ';
			$command .= '-resize '.$width.'x'.$height.' +profile "*" ';
			$command .= '"'.dirname($pfn).'/'.$fn.'" 2>&1';
			$error = shell_exec ($command);
			
			if (!file_exists (dirname($pfn).'/'.$fn)) {
				if ($error != '') {
					$msgs[] = "ImageMagick: Couldn't create thumbnail for ".$afn." (".$error.")";
					continue;
				} else {
					$msgs[] = "ImageMagick: Couldn't create thumbnail for ".$afn." (unknown reason).";
					continue;
				}
			}
			
			$msgs[] = "'".$afn."': Thumbnail created with ImageMagick.";
			$success = true;
			break;
		
		} else {
			$msgs[] = "'".$tm."': unkown method for thumbnail creation.";
			continue;
		}
		
	}
	
	return $success;
	
}

// ---------------------------------------------------
// -- 6. IS_PIC FUNCTION -----------------------------
// ---------------------------------------------------

function is_pic ($str,$no_folders=false,$thumbs=false) {
	global $set,$folder;
	if (in_array (preg_replace ('/(.*)(\.)([^.]+)$/','\3',strtolower($str)),$set['img_exts'])
		&& strstr ($str,'.blk.') === false
		&& ($thumbs || strstr ($str,'.tmb.') === false)) {
			return true;
	} elseif (is_dir ($folder.$str) && !$no_folders && 
		(preg_match ('/(\.pc)(\d{1,2})$/',strtolower($str)) || $set['all_folders'])) {
		return true;
	} else {
		return false;
	}
}

// ---------------------------------------------------
// -- 7. GET_FILES FUNCTION --------------------------
// ---------------------------------------------------

function get_files ($path) {
	
	global $msgs;
	
	// Check if folder
	if (!is_dir ($path)) {
		$msgs[] = "'".basename($paht)."': Is not a folder.";
		return false;
	}
	
	// Try to open folder
	$dir = opendir ($path);
	if ($dir === false) {
		$msgs[] = "'".basename($paht)."': Could not be opened.";
		return false;
	}
	
	// Read files into array
	while (($cf = readdir ($dir)) !== false) {
		if ($cf != '..' && $cf != '.') {
			$files[] = $cf;
		}
	}
	
	@natcasesort ($files);
	
	return $files;
	
}

// ---------------------------------------------------
// -- 8. FILL_INFO FUNCTION --------------------------
// ---------------------------------------------------

function fill_info ($pic) {
	
	global $set,
			$folder,
			$fpath,
			$types;
	
	// Check if folder
	if (!is_dir ($folder.$pic)) {
		
		// compile basic info
		$info['ext'] = preg_replace ('/(.*)(\.)([^.]+)$/','\3',$pic);
		$info['name'] = preg_replace ('/(.*)(\.)([^.]+)$/','\1',$pic);
		// special link for viewer
		if ($set['use_viewer']) {
			$info['link'] = $_SERVER['PHP_SELF'].'?'.make_query (array ('view'=>$pic));
		} else {
			$info['link'] = $fpath.$pic;
		}
		// special path for passthru
		if ($set['img_passthru']) {
			$info['path'] = $_SERVER['PHP_SELF'].'?'.make_query (array ('pic'=>$pic));
		} else {
			$info['path'] = $fpath.$pic;
		}
		$info['path_int'] = $folder.$pic;
		
		// get additonal info
		$temp = getimagesize ($folder.$pic);
		$info['size'] = filesize($folder.$pic);
		$info['width'] = $temp[0];
		$info['height'] = $temp[1];
		$info['type'] = $types[$temp[2]];
		
		// check for thumbnail / do we need a thumbnail anyway?
		if ($temp[0] < $set['tmb_size'][0] && $temp[1] < $set['tmb_size'][1]) {
			// special path for passthru
			if (!$set['img_passthru']) {
				$info['thm'] = $fpath.$pic;
			} else {
				$info['thm'] = $_SERVER['PHP_SELF'].'?'.make_query (array ('pic'=>$pic));
			}
		} elseif (file_exists ($folder.$info['name'].'.tmb.'.$info['ext'])) {
			// special path for passthru
			if (!$set['img_passthru']) {
				$info['thm'] = $fpath.$info['name'].'.tmb.'.$info['ext'];
			} else {
				$info['thm'] = $_SERVER['PHP_SELF'].'?'.make_query (array ('pic'=>$info['name'].'.tmb.'.$info['ext']));
			}
		} else {
			// create thumbnail if requested
			if ($set['make_thmbs']) {
				if (make_thmb ($info['path_int'])) {
					// special path for passthru
					if (!$set['img_passthru']) {
						$info['thm'] = $fpath.$info['name'].'.tmb.'.$info['ext'];
					} else {
						$info['thm'] = $_SERVER['PHP_SELF'].'?'.make_query (array ('pic'=>$info['name'].'.tmb.'.$info['ext']));
					}
				} else {
					$info['thm'] = false;
				}
			} else {
				$info['thm'] = false;
			}
		}
		
	} else {
		
		// compile basic info
		$info['ext'] = preg_replace ('/(.*)(\.)([^.]+)$/','\3',$pic);
		$info['name'] = preg_replace ('/(.*)(\.)([^.]+)$/','\1',$pic);
		$info['link'] = $_SERVER['PHP_SELF'].'?'.make_query (array('f'=>$fpath.$pic,'offset'=>false));
		$info['path_int'] = $folder.$pic;
		
		// get additonal info
		$info['type'] = 'Folder';
		$info['thm'] = $_SERVER['PHP_SELF'].'?dp=folder';
		
	}
	
	return $info;
	
}

// ---------------------------------------------------
// -- 9. MAIN ----------------------------------------
// ---------------------------------------------------

// generate hierarchy
$hyr[] = array ('name'=>preg_replace ('/(.*)(\.)([^.]+)$/','\1',basename($picy_root)),'link'=>$_SERVER['PHP_SELF'].'?'.make_query(array('f'=>false,'offset'=>false)));

$parts = explode ('/',$fpath);
$temppath = '';
foreach ($parts as $part) {
	if ($part != '') {
		$temppath .= $part.'/';
		$hyr[] = array ('name'=>preg_replace ('/(.*)(\.)([^.]+)$/','\1',$part),'link'=>($_SERVER['PHP_SELF'].'?'.make_query(array('f'=>$temppath,'offset'=>false))));
	}
}

// open folder
$files = get_files ($folder);

// Offset
if (!isset ($_GET['offset'])) {
	$off = 0;
} else {
	$off = (int)$_GET['offset'];
}

$pics = array ();

// filter pictures
$picfiles = array_filter ($files,'is_pic');
$picfiles = array_values ($picfiles);

// total pictures
$pn = count ($picfiles);

// search for pictures / fill with info
for ($i=$off;$i<count($picfiles) && $i<($off+$set['pics_pp']);$i++) {
	if (is_pic ($picfiles[$i])) {
		$pics[] = fill_info ($picfiles[$i]);
	}
}

// ---------------------------------------------------
// -- 10. COMPILE MAIN OUTPUT ------------------------
// ---------------------------------------------------

load_theme ($set['themes'][$set['cthm']][1],$set['themes'][$set['cthm']][0]);
$mainbit = '';

// pics
if (count ($pics) > 0) {
	
	$info_tags = array ('%%pic-link%%','%%pic-path%%','%%pic-name%%','%%pic-size%%',
						'%%tbl-width%%','%%img-type%%','%%tmb-width%%','%%tmb-height%%',
						'%%pic-width%%','%%pic-height%%');
	$tdbits = array ();
	$rowbits = array ();
	$pagebit = '';
	$tablebit = '';
	$hyrbit = '';
	
	for ($i=0;$i<count($pics);$i++) {
		
		// odd or even row
		if ($i%2 == 1) {
			$c = 'odd';
		} else {
			$c = 'even';
		}
		
		// create fill array
		$tags_data = array ($pics[$i]['link'],
							$pics[$i]['thm'],
							pad_string($pics[$i]['name']),
							number_format($pics[$i]['size']/1024,2,'.','\'').' KB',
							number_format(100/$thm['ppr'],2).'%',
							$pics[$i]['type'],
							$set['tmb_size'][0],
							$set['tmb_size'][1],
							$pics[$i]['width'],
							$pics[$i]['height']);
		
		// perpare thumbnail bit
		if ($pics[$i]['thm'] !== false) {
			$thumbn = $thm['ind_tmbbit'];
		} else {
			$thumbn = $thm['ind_notmbbit'];
		}
		$thumbn = str_replace ($info_tags,$tags_data,$thumbn);
		// prepare info bit
		if (is_dir ($pics[$i]['path_int'])) {
			$info = $thm['ind_folderinfo'];
		} else {
			$info = $thm['ind_picinfo'];
		}
		$info = str_replace ($info_tags,$tags_data,$info);
		// prepare pic bit
		$tmp = str_replace ($info_tags,$tags_data,$thm['ind_pbit']);
		$tmp = str_replace ('%%thumbn%%',$thumbn,$tmp);
		$tdbits[] = str_replace ('%%info%%',$info,$tmp);
		
		// row end?
		if (($i+1) % $thm['ppr'] == 0 || $i+1 == count($pics)) {
			$rowbits[] = str_replace ('%%tds%%',implode('',$tdbits),$thm['ind_row_'.$c]);
			$tdbits = array ();
		}
	}
	
	$tablebit = str_replace ('%%rows%%',implode('',$rowbits),$thm['ind']);
	
	// print pages
	if ($set['pics_pp'] < $pn) {
		// last page
		$lp = ceil(($pn/$set['pics_pp'])-1)*$set['pics_pp'];
		// function for page links
		function obey_limits ($int) {
			global $lp;
			if ($int < 0) {
				return 0;
			} elseif ($int > $lp) {
				return $lp;
			} else {
				return $int;
			}
		}
		// generate page links
		$page_tags = array ('%%first-page%%','%%last-page%%','%%prev-page%%','%%next-page%%');
		$page_bitags = array ('%%page-n-link%%','%%page-n-num%%');
		$tags_data = array ($_SERVER['PHP_SELF'].'?'.make_query(array('offset'=>'0')),
							$_SERVER['PHP_SELF'].'?'.make_query(array('offset'=>$lp)),
							$_SERVER['PHP_SELF'].'?'.make_query(array('offset'=>obey_limits($_GET['offset']-$set['pics_pp']))),
							$_SERVER['PHP_SELF'].'?'.make_query(array('offset'=>obey_limits($_GET['offset']+$set['pics_pp']))));
		
		// output
		$pbits = array ();
		for ($i=1;$i<=ceil($pn/$set['pics_pp']);$i++) {
			$bittags_data = array ($_SERVER['PHP_SELF'].'?'.make_query(array('offset'=>(($i-1)*$set['pics_pp']))),$i);
			$pbits[] = str_replace ($page_bitags,$bittags_data,$thm['pgs_bit']);
		}
		$pagebit = str_replace ($page_tags,$tags_data,$thm['pgs']);
		$pagebit = str_replace ('%%pages%%',implode('',$pbits),$pagebit);
	}
	
	// compile folder hierarchy
	for ($i=0;$i<count($hyr);$i++) {
		$hyrbit .= str_replace (array('%%f-name%%','%%f-link%%'),array($hyr[$i]['name'],$hyr[$i]['link']),$thm['hyrbit']);
	}
	$hyrbit = str_replace ('%%hyr%%',$hyrbit,$thm['hyr']);
	
	$mainbit = $hyrbit.$tablebit.$pagebit;
	
} else {
	
	$hyrbit = '';
	// compile folder hierarchy
	for ($i=0;$i<count($hyr);$i++) {
		$hyrbit .= str_replace (array('%%f-name%%','%%f-link%%'),array($hyr[$i]['name'],$hyr[$i]['link']),$thm['hyrbit']);
	}
	$hyrbit = str_replace ('%%hyr%%',$hyrbit,$thm['hyr']);
	
	$mainbit =  $hyrbit.$thm['ind_nopics'];
	
}

//output
print_main ($mainbit);

// ---------------------------------------------------
// -- 11. IMAGE VIEWER -------------------------------
// ---------------------------------------------------

function show_viewer ($pic) {
	
	// init
	global $folder,$fpath,$msgs,$set,$thm;
	
	// load theme
	load_theme ($set['themes'][$set['cthm']][1],$set['themes'][$set['cthm']][0]);
	
	// init vars
	$info_tags = array ('%%pic-path%%','%%pic-name%%','%%pic-size%%','%%img-type%%','%%folderview%%');
	
	// valid picture?
	if (!is_pic (basename($pic))) {
		$msgs[] = 'No valid picture.';
		error ();
	}
	
	// get folder contents
	$files = get_files ($folder);
	
	// only valid pictures
	// make is_pic function with no folders for callback
	function is_pic_nf (&$str) {
		return is_pic ($str,true);
	}
	// remove non-pic files and folders
	$files = array_filter ($files,'is_pic_nf');
	// reindex array
	$files = array_values ($files);
	
	// look for picture
	if (($pos = array_search ($pic,$files)) === false) {
		$msgs[] = 'Picture not found.';
		error ();
	}
	
	$info_tags = array ('%%pic-path%%','%%pic-link%%','%%pic-path%%','%%pic-name%%','%%pic-size%%',
						'%%img-type%%','%%tmb-width%%','%%tmb-height%%',
						'%%pic-width%%','%%pic-height%%','%%folderview%%');
						
	// compile info for prev and next pic
	if (isset ($files[$pos-1])) {
		$prev = fill_info ($files[$pos-1]);
		$tags_data = array ($prev['path'],
							$prev['link'],
							$prev['thm'],
							pad_string($prev['name']),
							number_format($prev['size']/1024,2,'.','\'').' KB',
							$prev['type'],
							$set['tmb_size'][0],
							$set['tmb_size'][1],
							$prev['width'],
							$prev['height']);
		$prevbit = str_replace ($info_tags,$tags_data,$thm['prevbit']);
	} else {
		$prevbit = '';
	}
	if (isset ($files[$pos+1])) {
		$next = fill_info ($files[$pos+1]);
		$tags_data = array ($next['path'],
							$next['link'],
							$next['thm'],
							pad_string($next['name']),
							number_format($next['size']/1024,2,'.','\'').' KB',
							$next['type'],
							$set['tmb_size'][0],
							$set['tmb_size'][1],
							$next['width'],
							$next['height']);
		$nextbit = str_replace ($info_tags,$tags_data,$thm['nextbit']);
	} else {
		$nextbit = '';
	}
	
	// current pic
	$curr = fill_info ($pic);
	$tags_data = array ($curr['path'],
						$curr['link'],
						$curr['thm'],
						$curr['name'],
						number_format($curr['size']/1024,2,'.','\'').' KB',
						$curr['type'],
						$set['tmb_size'][0],
						$set['tmb_size'][1],
						$curr['width'],
						$curr['height'],
						$_SERVER['PHP_SELF'].'?'.make_query(array('f'=>$fpath)));
	
	// generate key for hotlink protection
	if ($set['img_hotprot']) {
		
		if ($set['img_hp_type'] == 'file') {
			
			// generate key
			$key = substr (md5 (uniqid (rand())),0,10);
			
			// check for file
			if (file_exists ($folder.'picy_key_'.$key.'.pkf')) {
				$msgs[] = 'Key collision error.';
				error ();
			}
			
			// write key
			$keyfile = fopen ($folder.'picy_key_'.$key.'.pkf','w');
			
			if ($keyfile === false) {
				$msgs[] = 'Cannot open dir for writing.';
				error ();
			}
			
			$status = fwrite ($keyfile,time());
			
			if ($status === false) {
				$msgs[] = 'Cannot write file.';
				error ();
			}
			
			fclose ($keyfile);
			
			// pass key
			$tags_data[0] = $curr['path'].'&key='.$key;
			
		} elseif ($set['img_hp_type'] == 'mysql') {
			
			// connect
			picy_mysql_conn ();
			
			// generate key
			$key = substr (md5 (uniqid (rand())),0,10);
			
			// add to database
			$sql = "REPLACE INTO picy (`ip`,`pic`,`key`) VALUES ('".$_SERVER['REMOTE_ADDR']."','".addslashes($pic)."','".$key."')";
			$err = mysql_query ($sql);
			
			if (!$err) {
				$msgs[] = 'A MySQL error occured.';
			}
			
			// pass key
			$tags_data[0] = $curr['path'].'&key='.$key;
			
		} elseif ($set['img_hp_type'] == 'session') {
			
			// start session
			session_start ();
			
			// save into session
			$_SESSION['hp']['ip'] = $_SERVER['REMOTE_ADDR'];
			$_SESSION['hp']['pic'] = $pic;
		
		} else {
			$msgs[] = 'Unkown hotlink protection type.';
			error ();
		}
		
	}
	
	// main width
	if ($curr['width']+26 > 525) {
		$width = $curr['width']+26;
	} else {
		$width = 525;
	}
	
	$picbit = str_replace ($info_tags,$tags_data,$thm['viewer']);
	$picbit = str_replace ('%%prev%%',$prevbit,$picbit);
	$picbit = str_replace ('%%next%%',$nextbit,$picbit);
	
	print_main ($picbit,$width);
	
}

// ---------------------------------------------------
// -- 12. TUNNEL PICTURE FUNCTION --------------------
// ---------------------------------------------------

function tunnel_pic ($pic) {
	
	global $folder, $fpath, $set, $msgs;
	
	// valid picture?
	if (!is_pic (basename($pic),true,true)) {
		$msgs[] = 'No valid picture.';
		error ();
	}
	
	// get folder contents
	$files = get_files ($folder);
	
	// only valid pictures
	// make is_pic function with no folders for callback
	function is_pic_nf (&$str) {
		return is_pic ($str,true,true);
	}
	// remove non-pic files and folders
	$files = array_filter ($files,'is_pic_nf');
	// reindex array
	$files = array_values ($files);
	
	// look for picture
	if (($pos = array_search ($pic,$files)) === false) {
		$msgs[] = 'Picture not found.';
		error ();
	}
	
	// get dimensions
	$temp = getimagesize ($folder.$pic);
	
	// hotlink protection
	if ($set['img_hotprot'] && strstr ($pic,'.tmb.') === false && ($temp[0] > $set['tmb_size'][0] && $temp[1] > $set['tmb_size'][1])) {
		
		// no dir up-s
		$_GET['key'] = str_replace ('..','',$_GET['key']);
		
		if ($set['img_hp_type'] == 'file') {
			
			if (trim ($_GET['key']) == '' || !file_exists ($folder.'picy_key_'.$_GET['key'].'.pkf')) {
				$msgs[] = 'You don\'t have permission to access this file.';
				error ();
			} else {
				unlink ($folder.'picy_key_'.$_GET['key'].'.pkf');
			}
		
		} elseif ($set['img_hp_type'] == 'mysql') {
			
			// open connection
			picy_mysql_conn ();
			
			// look for key
			$sql = "SELECT * FROM picy WHERE ip = '".$_SERVER['REMOTE_ADDR']."' AND pic = '".addslashes($pic)."'";
			$res = mysql_query ($sql);
			
			if (!$res) {
				$msgs[] = 'A MySQL error occured.';
				error ();
			}
			
			if (!mysql_num_rows ($res) == 0) {
				if (mysql_result ($res,0,'key') != $_GET['key']) {
					$msgs[] = 'You don\'t have permission to access this file.';
					error ();
				}
			} else {
				$msgs[] = 'You don\'t have permission to access this file.';
				error ();
			}
			
			// remove key
			$sql = "DELETE * FROM picy WHERE ip = '".$_SERVER['REMOTE_ADDR']."'";
			mysql_query ($sql);
		
		} elseif ($set['img_hp_type'] == 'session') {
			
			// start session
			session_start ();
			
			if (!isset ($_SESSION['hp']) 
				|| $_SESSION['hp']['ip'] != $_SERVER['REMOTE_ADDR'] 
				|| $_SESSION['hp']['pic'] != $pic) {
					unset ($_SESSION['hp']);
					$msgs[] = 'You don\'t have permission to access this file.';
					error ();
			}
			
			unset ($_SESSION['hp']);
			
		} else {
			$msgs[] = 'Unkown hotlink protection type.';
			error ();
		}
		
	}
	
	// get file extension
	$ext = strtolower (preg_replace ('/(.*)(\.)([^.]+)$/','\3',$pic));
	
	if (!isset ($set['mime_types'][$ext])) {
		$msgs[] = 'No suiteable MIME type found.';
		error ();
	}
	
	// tunnel picture
	$file = fopen ($folder.$pic,'rb');
	if ($file === false) {
		$msgs[] = 'Picture couldn\'t be opened.';
		error ();
	}
	
	header ('Content-type: '.$set['mime_types'][$ext]);
	fpassthru ($file);
	fclose ($file);
}

// ---------------------------------------------------
// -- 14. PICTURES STORED INTERALLY ------------------
// ---------------------------------------------------

function pass_pic ($p) {
// <!! type=pictures;

	if ($p == 'folder') {
// <! name=folder;
	header ('Content-type: image/gif');
	print base64_decode ('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');
// !>
	} elseif ($p == 'file') {
// <! name=file;
	header ('Content-type: image/gif');
	print base64_decode ('R0lGODlhHAAoAOYAAAAAANPZ3LeKZlxTT7i5u/P19rKllN/Tu4yAdPWObePm6e/MohISEv///4xtVfW+S8ufdta8oJmZmens7vfmzf3z4N7i5mZmZvi6fEZFSLWcg/zblK+ppdujdYV1aNDGtf397+/s3/SlWJ6IcnJmXvLZvuKnfP3wy7+EYcatlebp7Me8r/fDZ4BsYffUi/qxkfDy9Pemdf3rtXlsZGlfWZmZmY6EfIx7cPf3+ODLtRcXF/KoUpKKhMadfP399s2ohLCNceHYzu3v8ah6WLW2uPznwceRaPDcx76xoP357drEqX5ZQntra5uUjZt+Z921jMHBwf33z8GmjmBXTqSLeby0o+jDmODk59e0k46Hgvznh9alc/ffxujStXRpYvznzvvQevW2UCEhIf336OzRtZh2Xr2+v5WBbIx0YLCRdHx1dPeTbvfm07yXeZqLf//MZuHc1s+iediugvriwMiif4R7duC/mf341rWNbOOvff3u2L2Pbcq6pvbAn8Wbd+/fyiH5BAUUAFAALAAAAAAcACgAAAf/gFCCg4JNAIeIiYqJhINNOgATDZOUlZYNAI1QEgxEkZY4oaKjAZmEEmIEBZ+To66ipacAZgU4rK+4sYU6ULW2E7ijBcMFupxEvpjAwTjEw7FNDL04lJHBzsSlEjrI1NXLrtjZi4rgouLjkRPr7OzC6DDxpQCT5PbkMPP1Pvz9SUk+VvAI0oCfJQD5Du3rxw/gnTxGuoDoVwmAEH22GILYGCIChD0oTHy5ZBEjgI0oNxogwXLAjA8kLyq0NWZMwyQVDHjwYMOGlyoxTWrRIuNOTT1NZtj4sMIDEoPVZNKzFSMGhiIVKuhx46UJDy83+IA4OMFkgrMvvuhh44YGDx4z/xAgGUNW36oHeFnM+XLEBo0sNuLOratw1ZqzCfpwOXBjgJo6JGYMrli2MAARO8I8cFEiBwI0ZzxQ0eAmCwc43+wCYAFmQ1EKfM7geWJngZURGWYQpAtAheoTUe5QyEHHwZI0drBgSTPlwoETJ7586a0PBgAlKdIMAYJHQJkWCG60QOOEyocTXEqUoK7Q+pIlDgTQoROnQxw/bejI+dFDyh8KZPzBHj3W3WPgIb61J8SCDArRTjsqRChhhPo0yOCD7EwYoQIcVmghhhNoqAKHJHq4IIghakhiiQpdCKKIK7JIj4MvqhjjFTjqgyKMN+J4hY4P8tijj0BmaOOKPl5hwRqSRaY4YYwKJLkkkwoFYOWVWGapJZYHdrlIIAA7');
// !>
	} elseif ($p == 'icon') {
// <! name=icon;
	header ('Content-type: image/x-icon');
	print base64_decode ('Qk02BQAAAAAAADYEAAAoAAAAEAAAABAAAAABAAgAAAAAAAABAAASCwAAEgsAAAABAAAyAAAArYeNANXFzADv5ucAxauvAL+YngDNvL8A////AOLT1gC6jJAA3MjNAPn29gCtkp0A1b3AAMixtQDEoqcAzMzMAN7P1QDWw8YA8u3tALaKjgDn2NsAw52jAMurrwDPzNQAyba+AM+/wwDTwMMAsI2VALiQlQDn3N8A0ra6AL2UmgDPydMA5NHTAMKanwDfzc8Azq2yAMautQD18PEA3sXFAManrAC1jZIA8enrALCJjwDl1NYA2czWANHCxQDPsrYA0Le7ALiUmwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABISEiYGBgYGBgYSAhIGBgYIExMfFRUVFRUVKSscFSIiLQEBLS0HBwcHIxoaIyEhIRYWLi0tLRAQLAkFGgwkDC0MDBYtLS0tEBARGREfFB8BFBQfHxUfHxYiHx8OHyoJFhQKHwYvIyEiCgYGDAQQCgQUJh8RJgkJLCofKBUfCgoRFAIfDAoJIx0dHx8fFgoJEhQGJgoJIyMWChIKERQhHwooKDAkHx4eBBUeJB8vFRUoGCUoJBUdBw4NAyQkAwURMCAgIAEeHx8vBQUaGgUuLS4XICAgIAEBGhoaGhoaGgEZCwsLCwsLMRwAACsrKysbKwYGBgYGBgYGBgYGBgYGBgY=');
// !>
	} elseif ($p == 'logo') {
// <! name=logo;
	header ('Content-type: image/gif');
	print base64_decode ('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');
// !>
	} elseif ($p == 'almost-html401') {
// <! name=almost-html401;
	header ('Content-type: image/png');
	print base64_decode ('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');
// !>
	}

// !!>
}

// ---------------------------------------------------
// -- 15. THEMES -------------------------------------
// ---------------------------------------------------

function load_theme ($tname,$internal=THM_INT) {
	
	global $msgs, $thm, $picy_version;
	
	if ($internal == THM_INT) {
		
// <!! type=themes;

	if ($tname == 'std') {

// <! short=std;name=Standard Theme;

// Global Vars
$thm['title'] = 'Picy Gallery';
$thm['ppr'] = 3;
// Header + Body Start
$thm['html'] = '<?xml version="1.0" encoding="iso-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>'.$thm['title'].' - '.$picy_version.'</title>
<link rel="shortcut icon" href="'.$_SERVER['PHP_SELF'].'?dp=icon" />
<style type="text/css">
<!--
body {
	font-family: Verdana; 
	font-size: 12px;
	color: #000; 
	background-color: #fff;
	text-align: center;
}
a:Link {
	text-decoration: none;
	color: #5555bb;
}
a:Visited {
	text-decoration: none;
	color: #bb5555;
}
a:Hover {
	text-decoration: underline;
}
.title {
	font-weight: bold;
	font-size: 16px;
}
.subtitle {
	font-weight: 150;
	font-size: 14px;
}
#pictbl {
	width: 525px;
	margin: 0px auto 0px auto;
	border: 1px solid #666;
	padding: 5px;
	background-color: #fafafa;
	clear: both;
}
#footer {
	margin-top: 40px;
	font-size: 11px;
	width: 100%;
	border-collapse: collapse;
}
#footer td {
	border: 1px solid #ddd;
	padding: 10px;
	width: 33%;
	background-color: #fefefe;
}
#footer td:hover {
	background-color: #eef6ee;
}
#pages {
	float: right;
	border: 1px solid #999;
	border-top: none;
	background-color: #fafafa;
	padding: 2px 10px;
}
.picrodd {
}
.picreven {
}
.pictd {
	margin: 5px;
	padding: 5px;
}
td.pictd:Hover {
	background-color: #eef6ee;
}
.line {
	border: 0px solid;
	border-top: 1px dashed #999;
}
#hyr {
	float: left;
	border: 1px solid #999;
	border-bottom: none;
	padding: 2px 10px;
	margin-bottom: 0px;
}
#errorlist {
	font-size: 10px;
	color: #990000;
}
-->
</style>
</head>
<body>
<p class="title"><img src="'.$_SERVER['PHP_SELF'].'?dp=logo" alt="picy logo" /></p>
<div style="width: %%main-width%%px; margin: 0px auto 0px auto;">
%%picy-main%%
<table id="footer"><tr><td>
<a href="http://validator.w3.org/check?uri=referer">
<img style="border:0;width:88px;height:31px;" src="http://www.w3.org/Icons/valid-xhtml10" alt="Valid XHTML 1.0!" /></a>
<a href="http://jigsaw.w3.org/css-validator/check/referer">
<img style="border:0;width:88px;height:31px;" src="http://jigsaw.w3.org/css-validator/images/vcss" alt="Valid CSS!" /></a>
</td><td>
<a href="http://picy.infinitesimal.org/">Picy</a> '.$picy_version.'<br />
<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/2.0/de/">
<img alt="Creative Commons-Lizenzvertrag" 
src="http://creativecommons.org/images/public/somerights20.gif" style="border: none; margin: 5px;" /></a><br />
 2004 Adrian Stutz
</td><td>
<a href="http://www.spreadfirefox.com/?q=affiliates&amp;id=0&amp;t=86">
<img style="border:0;" alt="Get Firefox!" src="http://spreadfirefox.com/community/images/affiliates/Buttons/125x50/takebacktheweb_125x50.png" /></a>
</td></tr></table>
</div>
</body>
</html>';
// Error Bit
$thm['msgs'] = '<p class="subtitle">Messages:</p>
<lu id="errorlist">
%%msgs%%
</lu><br />'."\n";
$thm['msgs_bit'] = '<li>%%msg%%</li>'."\n";
// Picture Bit
$thm['ind'] = '<table id="pictbl">
%%rows%%
</table>'."\n";
$thm['ind_nopics'] = '<div><br />No pictures found.<br /></div>';
$thm['ind_row_odd'] = '<tr class="picrodd">
%%tds%%
</tr>'."\n";
$thm['ind_row_even'] = '<tr class="picreven">
%%tds%%
</tr>'."\n";
$thm['ind_pbit'] = '<td class="pictd" style="width: %%tbl-width%%; padding: 5px;">%%thumbn%%
<a href="%%pic-link%%">%%pic-name%%</a><br />
%%info%%</td>';
$thm['ind_picinfo'] = '%%img-type%% - %%pic-size%%<br />%%pic-width%%x%%pic-height%%';
$thm['ind_folderinfo'] = 'Folder';
$thm['ind_tmbbit'] = '<a href="%%pic-link%%">
<img src="%%pic-path%%" alt="%%pic-name%%" style="padding: 3px; border: 1px dashed #ddd; margin-bottom: 5px;" /></a><br />';
$thm['ind_notmbbit'] = '<a href="%%pic-link%%">
<img src="'.$_SERVER['PHP_SELF'].'?dp=file" alt="No Thumbnail"  style="padding: 3px; border: 1px dashed #ddd;"/>
</a><br />';
// pages bit
$thm['pgs'] = '<div id="pages"><a href="%%first-page%%"><<</a> | <a href="%%prev-page%%"><</a> | 
%%pages%%
<a href="%%next-page%%">></a> | <a href="%%last-page%%">>></a></div>'."\n";
$thm['pgs_bit'] = '<a href="%%page-n-link%%">%%page-n-num%%</a> | ';
// hierachy bit
$thm['hyr'] = '<div id="hyr">%%hyr%%</div>';
$thm['hyrbit'] = '&#8260; <a href="%%f-link%%">%%f-name%%</a> ';
// viewer bit
$thm['viewer'] = '<table id="pictbl" style=""><tr><td>
<img src="%%pic-path%%" alt="%%pic-name%%" style="padding: 3px; border: 1px dashed #ddd; margin-bottom: 5px;" /><br />
%%pic-name%%<br />
%%img-type%% - %%pic-size%%<br />
%%pic-width%%x%%pic-height%%
</td></tr>
</table>
<div id="pages"><table style="width: 100%"><tr><td style="width: 30%; text-align: left;">%%prev%%</td>
<td style="width: 30%; text-align: center;"><a href="%%folderview%%">Main</a></td>
<td style="width: 30%; text-align: right;">%%next%%</td></tr></table></div>';
$thm['nextbit'] = '<a href="%%pic-link%%">%%pic-name%% >></a>';
$thm['prevbit'] = '<a href="%%pic-link%%"><< %%pic-name%%</a>';


// !>

	} elseif ($tname == 'html401') {

// <! short=html401;name=HTML 4.01 Theme;

// ---------------------------------------------
// ---- Picy - a simple PHP folder gallery -----
// ---------------------------------------------
// Global Vars
$thm['title'] = 'Picy Gallery';
$thm['ppr'] = 3;
// Header + Body Start
$thm['html'] = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title>'.$thm['title'].' - '.$picy_version.'</title>
<link rel="shortcut icon" href="'.$_SERVER['PHP_SELF'].'?dp=icon">
</head>
<body>
<center>
<img src="'.$_SERVER['PHP_SELF'].'?dp=logo" alt="picy logo"><br>
<br>
<table width="%%main-width%%"><tr><td>
%%picy-main%%
</td></tr></table>
<br>
<table width="%%main-width%%" bgcolor="#cccccc" cellspacing="0.5" cellpadding="0"><tr><td>
<table width="100%" cellspacing="1" cellpadding="5"><tr><td bgcolor="#fefefe" align="center" width="33%">
<a href="http://validator.w3.org/check?uri=referer">
<img style="border:0;width:94px;height:38px;" src="'.$_SERVER['PHP_SELF'].'?dp=almost-html401" alt="Almost Valid HTML 4.01!" /></a>
</td><td bgcolor="#fefefe" align="center" width="33%">
<font size="2"><a href="http://picy.infinitesimal.org/" target="_blank">Picy</a> '.$picy_version.'<br />
<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/2.0/de/">
<img alt="Creative Commons-Lizenzvertrag" 
src="http://creativecommons.org/images/public/somerights20.gif" style="border: none; margin: 5px;" /></a><br />
 2004 Adrian Stutz</font>
</td><td bgcolor="#fefefe" align="center" width="33%">
<a href="http://www.spreadfirefox.com/?q=affiliates&amp;id=0&amp;t=86">
<img style="border:0;" alt="Get Firefox!" src="http://spreadfirefox.com/community/images/affiliates/Buttons/125x50/takebacktheweb_125x50.png" /></a>
</td></tr></table></td></tr></table>
</center>
</body>
</html>';
// Error Bit
$thm['msgs'] = '<p class="subtitle">Messages:</p>
<lu id="errorlist">
%%msgs%%
</lu><br />'."\n";
$thm['msgs_bit'] = '<li>%%msg%%</li>'."\n";
// Picture Bit
$thm['ind'] = '<table width="100%" bgcolor="#cccccc" cellspacing="0.5"><tr><td>
<table width="100%" bgcolor="#fafafa" cellpadding="10">
%%rows%%
</table></td></tr></table>'."\n";
$thm['ind_nopics'] = '<br /><center><b>No pictures found.</b></center><br />';
$thm['ind_row_odd'] = '<tr>
%%tds%%
</tr>'."\n";
$thm['ind_row_even'] = '<tr>
%%tds%%
</tr>'."\n";
$thm['ind_pbit'] = '<td width="%%tbl-width%%" align="center"><font size="2">%%thumbn%%
<a href="%%pic-link%%">%%pic-name%%</a><br />
%%info%%</font></td>';
$thm['ind_picinfo'] = '%%img-type%% - %%pic-size%%<br />%%pic-width%%x%%pic-height%%';
$thm['ind_folderinfo'] = 'Folder';
$thm['ind_tmbbit'] = '<a href="%%pic-link%%">
<table bgcolor="#cccccc" cellspacing="0.5"><tr><td>
<table bgcolor="#fefefe" width="100%"><tr><td>
<img src="%%pic-path%%" alt="%%pic-name%%" border="0">
</td></tr></table>
</td></tr></table></a>';
$thm['ind_notmbbit'] = '<a href="%%pic-link%%">
<img src="'.$_SERVER['PHP_SELF'].'?dp=file" alt="No Thumbnail"  style="padding: 3px; border: 1px dashed #ddd;">
</a><br>';
// pages bit
$thm['pgs'] = '<br><table bgcolor="#cccccc" cellspacing="0.5" align="right"><tr><td>
<table bgcolor="#fefefe" width="100%"><tr><td>
<a href="%%first-page%%"><<</a> | <a href="%%prev-page%%"><</a> | 
%%pages%%
<a href="%%next-page%%">></a> | <a href="%%last-page%%">>></a>
</td></tr></table>
</td></tr></table>'."\n";
$thm['pgs_bit'] = '<a href="%%page-n-link%%">%%page-n-num%%</a> | ';
// hierachy bit
$thm['hyr'] = '<table bgcolor="#cccccc" cellspacing="0.5" align="left"><tr><td>
<table bgcolor="#fefefe" width="100%"><tr><td>
 %%hyr%% 
</td></tr></table>
</td></tr></table><br><br>';
$thm['hyrbit'] = '&#8260; <a href="%%f-link%%">%%f-name%%</a> ';
// viewer bit
$thm['viewer'] = '<table bgcolor="#cccccc" cellspacing="0.5" width="100%"><tr><td>
<table style="width: 100%" bgcolor="#fefefe" cellpadding="10"><tr><td align="center">
<img src="%%pic-path%%" alt="%%pic-name%%" style="padding: 3px; border: 1px dashed #ddd; margin-bottom: 5px;" /><br />
%%pic-name%%<br />
%%img-type%% - %%pic-size%%<br />
%%pic-width%%x%%pic-height%%
</td></tr></table>
</td></tr></table>
<br>
<table bgcolor="#cccccc" cellspacing="0.5" width="100%"><tr><td width="33%">
<table style="width: 100%" bgcolor="#fefefe"><tr><td>%%prev%%</td>
<td width="33%" align="center"><a href="%%folderview%%">Main</a></td>
<td width="33%" align="right">%%next%%</td></tr></table>
</td></tr></table>';
$thm['nextbit'] = '<a href="%%pic-link%%">%%pic-name%% >></a>';
$thm['prevbit'] = '<a href="%%pic-link%%"><< %%pic-name%%</a>';


// !>

	}

// !!>

	} elseif ($internal == THM_EXT) {
		
		// external themes
		// only this directory
		$tname = basename ($tname);
		
		// check if exists
		if (!file_exists ($tname)) {
			load_theme ('std');
			$msgs[] = 'External theme not found.';
			error ();
		}
		
		// load theme
		require $tname;
		
		if (!isset ($thm)) {
			load_theme ('std');
			$msgs[] = 'Not a picy theme file.';
			error ();
		}
		
	}
	
}

?>