/* Copyright (c) 1995-1999 NEC USA, Inc.  All rights reserved.               */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("Copyright") included with this distribution.                   */

/*
 * $Id: block.h,v 1.6.4.1 1999/02/03 22:34:48 steve Exp $
 */

#ifndef BLOCK_H
#define BLOCK_H

#if defined(HAVE_FCNTL_H) || defined(HAVE_SYS_FCNTL_H)
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifdef HAVE_SYS_FCNTL_H
#include <sys/fcntl.h>
#endif

/* some nonblock derivative                                                  */
#ifdef O_NONBLOCK
#define S5_NONBLOCK O_NONBLOCK
#elif defined(FNONBLOCK)
#define S5_NONBLOCK FNONBLOCK
#elif defined(FNONBLK)
#define S5_NONBLOCK FNONBLK
#else
#define S5_NONBLOCK 0
#endif

/* some ndelay derivative                                                    */
#ifdef O_NDELAY
#define S5_NDELAY O_NDELAY
#elif defined(FNDELAY)
#define S5_NDELAY FNDELAY
#else
#define S5_NDELAY 0
#endif

/* pick nonblock first when making things nonblocking -- it's posix          */
/* if it doesn't exist, ndelay will work ok...                               */
/* #if S5_NONBLOCK != 0       */
/* #define NBFLAG S5_NONBLOCK */
/* #else                      */
/* #define NBFLAG S5_NDELAY   */
/* #endif                     */

/* this is just to see if it is nonblocking.  We don't care which is set     */
/* #define NBFLAGS (S5_NONBLOCK | S5_NDELAY)                                 */

#define ISNBLOCK(fd)        (fcntl((fd), F_GETFL, 0) & (S5_NONBLOCK | S5_NDELAY))
#define ISBLOCK(fd)         (!ISNBLOCK((fd)))

/* #define GETFLAGS(fd, flags) (flags = fcntl((fd), F_GETFL, 0))                     */

/* #define BLOCK(fd, flags, nflags) do {                                           \ */
/*     GETFLAGS((fd), (flags)); (nflags) = (flags);                                \ */
/*     if (ISNBLOCK((flags))) fcntl((fd), F_SETFL, (nflags) = (flags) & ~NBFLAGS); \ */
/* } while (0) */

/* #define UNBLOCK(fd, flags, nflags) do {                                         \ */
/*     GETFLAGS((fd), (flags)); (nflags) = (flags);                                \ */
/*     if (ISBLOCK((flags))) fcntl((fd), F_SETFL, (nflags) = (flags) | NBFLAG);    \ */
/* } while (0) */

/* #define RSTBLOCK(fd, flags, nflags)                          \ */
/*     if ((flags) != (nflags)) fcntl((fd), F_SETFL, (flags))     */

#else

#define ISNBLOCK(fd)  0
#define ISBLOCK(fd)   1

#endif
#endif
