#!/sys/pkg/bin/perl -w 

# germ- let your ideas germinate.
# (c) 2009, Wesley Teal, wt@sdf.lonestar.org
# distributed under the MIT/X Consortium License, see LICENSE for details

use strict;
use Text::Wrap;
$Text::Wrap::columns=80;
use Fcntl qw(:flock);

$ENV{PATH} = "";
$> = $<;
$) = $(;

# === Configurable Variables ===

# this scripts name, so it can get all self-referential
my $name = "germ.cgi";

# the server that is hosting the script
my $server = "sdf.lonestar.org";

# the port number the server uses; don't change this unless you know its serving
# from a different port
my $port = 70;

# the directory used in gopher links, make sure not to end with a "/"
my $base_dir ="/users/YOUR_NAME";

# full path name to the directory you store your *.post, header.txt, and div.txt
# files in, make sure not to end with a "/"

my $dir = "/ftp/pub$base_dir/dat";

# the maximum number of posts you want displayed per phlog page

my $max_posts = 6;

# === End Configurable Variables ===

my $serv_string = "\tnull\ttext\t70";
my $ver = "germ 0.1.0a";
my $header = "$dir/header.txt";
my $div = "$dir/div.txt";
my $footer = "i$serv_string\r\nipowered by $ver\r\n";
my @archive;

my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst);
my @months = qw(January February March April May June July August September October November December);
my @mins = qw(00 01 02 03 04 05 06 07 08 09);

my @posts = <$dir/*.post>;
my @sortie = sort { -M $a <=> -M $b } @posts;

$max_posts -= 1;
if ($#sortie > $max_posts) {
    until ($#sortie == $max_posts) {
        unshift (@archive, (pop (@sortie)));
    }
}
$max_posts += 1;

if ($#ARGV == 0 && $ARGV[0] =~ /post/) {      # show individual posts/comments
    my $go_string = "\t$base_dir/$name?$ARGV[0]\t$server\t$port";
    my $com_string = "\t$base_dir/$name\t$server\t$port";
    my $cmt = "$ARGV[0].cmt";
    open (FH, "< $header");   
    while (<FH>) {
        chomp $_;
        print "i$_$serv_string\r\n";
    }
    close (FH);
    open (FH, "< $div");
    while (<FH>) {
        chomp;
        print "i$_$serv_string\r\n";
    }
    close (FH);
    print "1Back to Main Page$com_string\r\n";
    print "i$serv_string\r\n";
    open (FH, "< $dir/$ARGV[0]") || die "3No such entry!$serv_string\r\n";
    while (<FH>) {
        chomp;
        print "i$_$serv_string\r\n";
    }
    print "i$serv_string\r\n";
    print "7Leave Comment$com_string\r\n";
    $Text::Wrap::separator = "$serv_string\r\n";
    print wrap("i", "i", "To leave comment enter \"$ARGV[0]\" at the prompt followed by a space and then your comment of 250 words or less."), "$serv_string\r\n";
    $Text::Wrap::separator = "\n";
    open (FH, "< $div");
    while (<FH>) {
        chomp;
        print "i$_$serv_string\r\n";
    }
    if (-e "$dir/$cmt") {
        open (FH, "< $dir/$cmt");
        while (<FH>) {
            chomp;
            print "i$_$serv_string\r\n";
        }
    }
    print $footer;
    print ".\r\n";
    exit;

} elsif ($#ARGV == 0 && $ARGV[0] =~ /^archive\d/) {
    my @num = (split (/\D/, $ARGV[0]));
    my $num = $num[$#num]; 
    my $min = $max_posts * $num - $max_posts;
    my $max = $max_posts * $num - 1;
    if ($max > $#archive) {
        $max = $#archive;
    }

    open (FH, "< $header");   
    while (<FH>) {
        chomp $_;
        print "i$_$serv_string\r\n";
    }
    close (FH);
    open (FH, "< $div");
    while (<FH>) {
        chomp;
        print "i$_$serv_string\r\n";
    }
    close (FH);
    foreach (@archive[$min .. $max]) {
        my @p_name = split /\//;
        my $p = 0;
        until ($p_name[$p] =~ /post$/) {
            $p++;
        }
        my $go_string = "\t$base_dir/$name?$p_name[$p]\t$server\t$port";
        my $mtime = (stat ($_))[9];
        my @date = (($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($mtime));
        if ($min >= 0 && $min <= 9) {
            $min = $mins[$min];
        }
        $year = $year + 1900;
        print "i$year $months[$mon] $mday, $hour:$min$serv_string\r\n";
        print "1View Post$go_string\r\n";
        print "i$serv_string\r\n";
        open (FH, "< $_");
        while (<FH>) { 
            chomp;
            print "i$_$serv_string\r\n";
        }
        close (FH);
        open (FH, "< $div");
        while (<FH>) {
            chomp;
            print "i$_$serv_string\r\n";
        }
        close (FH);
    }
    if ($#archive > $max) {
        $num += 1;
        print "1Older Posts\t$base_dir/$name?archive$num\t$server\t$port\r\n";
        print ".\r\n";
    }
    exit;

}elsif ($#ARGV > 0  && $#ARGV < 250) {
    my $post;
    if ($ARGV[0] =~ /post/) {
        $post = $ARGV[0];
    } else {
        print "3Sorry, please enter the name of the post you wish to comment on.$serv_string\r\n";
    }
    my $comfile = "$dir/$post.cmt";
    my $tmp = "$comfile.tmp";
    my $go_string = "\t$base_dir/$name?$post\t$server\t$port";

    open (NEW, "> $tmp");
    flock (NEW, LOCK_EX);
    my $mtime = (stat ($tmp))[9];
    my @date = (($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($mtime));
    if ($min >= 0 && $min <= 9) {
        $min = $mins[$min];
    }
    $year = $year + 1900;
    print NEW "$year $months[$mon] $mday, $hour:$min\n";
    print NEW wrap ("", "", @ARGV[1 .. $#ARGV]), "\n";
    print NEW "\n---\n\n";
    if (-e $comfile) {
        open (OLD, "< $comfile");
        flock (OLD, LOCK_EX);
        while (my $line = <OLD>) {
            print NEW $line;
        }
        close OLD;
    }

    close NEW;
    rename ($tmp, $comfile) || die "Can't rename!";
    chmod 0644, $comfile;
    print "iYour comment has been posted.$serv_string\r\n";
    print "1View your comment$go_string\r\n";
    print ".\r\n";
    exit;
} elsif ($#ARGV >= 250) {
    print "3Sorry, comment should be less than 250 words$serv_string";
}

open (FH, "< $header");   
while (<FH>) {
    chomp $_;
    print "i$_$serv_string\r\n";
}
close (FH);
open (FH, "< $div");
while (<FH>) {
    chomp;
    print "i$_$serv_string\r\n";
}
close (FH);

foreach (@sortie) {
    my @p_name = split /\//;
    my $p = 0;
    until ($p_name[$p] =~ /post$/) {
        $p++;
    }
    my $go_string = "\t$base_dir/$name?$p_name[$p]\t$server\t$port";
    my $mtime = (stat ($_))[9];
    my @date = (($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($mtime));
    if ($min >= 0 && $min <= 9) {
        $min = $mins[$min];
    }
    $year = $year + 1900;
    print "i$year $months[$mon] $mday, $hour:$min$serv_string\r\n";
    print "1View Post/Comments$go_string\r\n";
    print "i$serv_string\r\n";
    open (FH, "< $_");
    while (<FH>) { 
        chomp;
        print "i$_$serv_string\r\n";
    }
    close (FH);
    open (FH, "< $div");
    while (<FH>) {
        chomp;
        print "i$_$serv_string\r\n";
    }
    close (FH);
}
if ($#archive >= 0) {
    print "1Older Posts\t$base_dir/$name?archive1\t$server\t$port\r\n";
}
print $footer;
print ".\r\n";
