#!/sys/pkg/bin/perl

# germ- let your ideas germinate.
# (c) 2009, Wesley Teal, wt@sdf.lonestar.org
# includes code and comments by slugmax@sdf.org
#
# distributed under the MIT/X Consortium License, see LICENSE for details

use warnings;
use strict;
use Text::Wrap;
$Text::Wrap::columns=80;
use Fcntl qw(:flock);
use POSIX qw(strftime);

# Nix the PATH and prevent SETUID/SETGID
$ENV{PATH} = "";
$> = $<;
$) = $(;

# === Configurable Variables ===

# The directory used in gopher links, make sure not to end with a "/"
my $base_dir ="/users/username";

# Full path name to the directory you store your *.post, header.txt, and div.txt
# files in.  Make sure not to end with a "/"
my $dir = "/ftp/pub$base_dir/dat";

# The maximum number of posts you want displayed per phlog page
my $max_posts = 6;

# Permalink text. Shown as a link to individual posts.  It's a good idea to have
# this end with something about comments so that the comment count isn't just a
# random-seeming number sitting next to this link
my $permalink_text = "View Post/Comments";

# This is the text that will be displayed on the main page when you use the
# "--more--" tag in your posts.
my $more_text = "[Continued...]";

# This is printed after every comment that is left on your gopherlog.  Changing 
# this after you have comments will mess up comment counts, so it's best to 
# change it right away or not at all.  This also divides tags from posts.
my $cmt_div = "---";

# This scripts name, so it can get all self-referential
my $name = "germ.cgi";

# The server that is hosting the script
my $server = "sdf.lonestar.org";

# The port number the server uses; don't change this unless you know its serving
# from a different port
my $port = 70;

# === End Configurable Variables ===

my $txt_string = "\tnull\ttext\t70";
my $ver = "germ 0.3.0a";
my $header = "$dir/header.txt";
my $div = "$dir/div.txt";
my $footer = "i$txt_string\r\nipowered by $ver$txt_string\r\n.\r\n";
my @tag_list;
my @input = <$dir/*.post>;
my @posts = sort { -M $a <=> -M $b } @input;

# show individual posts/comments
if ($#ARGV == 0 && $ARGV[0] =~ /post/) {      
    my $go_string = "\t$base_dir/$name?$ARGV[0]\t$server\t$port";
    my $com_string = "\t$base_dir/$name\t$server\t$port";
    my $post = "$dir/$ARGV[0]";
    my $cmt = "$ARGV[0].cmt";
    &print_file ($header);
    &print_file ($div);
    print "1Back to Main Page$com_string\r\n";
    print "i$txt_string\r\n";
    my $date = strftime ("%Y %B %d, %R", localtime((stat ($post))[9]));

    print "i$date$txt_string\r\n";
    print "i$txt_string\r\n";
    &print_file ($post);
    print "i$txt_string\r\n";
    print "7Leave Comment$com_string\r\n";
    $Text::Wrap::separator = "$txt_string\r\n";
    print wrap("i", "i", "To leave comment enter \"$ARGV[0]\" at the prompt followed by a space and then your comment of 250 words or less."), "$txt_string\r\n";
    $Text::Wrap::separator = "\n";
    if ($tag_list[0]) {
        &print_tags (@tag_list);
    }
    &print_file ($div);
    if (-e "$dir/$cmt") {
        &print_file ("$dir/$cmt");
    }
    print "$footer";
    exit;

#show archives
} elsif ($#ARGV == 0 && $ARGV[0] =~ /^archive\d/) {    
    my $num = $ARGV[0];
    $num =~ s/archive//;
    my $min = $max_posts * $num;
    my $max = $max_posts * $num + $max_posts - 1;
    if ($max > $#posts) {
        $max = $#posts;
    }
    &print_page (@posts[$min .. $max]);
    if ($num == 1) {
        print "1Newer Posts\t$base_dir/$name\t$server\t$port\r\n";
    }elsif ($num > 1) {
        my $prev_page = $num - 1;
        print "1Newer Posts\t$base_dir/$name?archive$prev_page\t$server\t$port\r\n";
    }
    if ($#posts > $max) {
        $num += 1;
        print "1Older Posts\t$base_dir/$name?archive$num\t$server\t$port\r\n";
    }
    print $footer;
    exit;
    
#show files containing a specific tag
} elsif ($#ARGV == 0 && $ARGV[0] =~ /^tag=(\w+)/) {
    my $tag = $ARGV[0];
    my @tag_files;
    $tag =~ s/^tag=//;
    $tag =~ s/_/ /g;
    foreach my $file (@posts) {
        open (FH, "< $file") || print "3Couldn't look for tags in $file$txt_string";
        while (<FH>) {
            if (!/^#tags/i) {
                next;
            } elsif ($. > 2) {
                last;
            } elsif (/\b$tag/i) {
                push (@tag_files, $file);
                last;
            }
        }
        close (FH);
    }
    &print_page (@tag_files);
    print $footer;
    exit;

#get comments
}elsif ($#ARGV > 0  && $#ARGV < 250) {
    my $post;
    if ($ARGV[0] =~ /post/) {
        $post = $ARGV[0];
    } else {
        print "3Sorry, please enter the name of the post you wish to comment on.$txt_string\r\n";
    }
    my $comfile = "$dir/$post.cmt";
    my $tmp = "$comfile.tmp";
    my $go_string = "\t$base_dir/$name?$post\t$server\t$port";

    open (NEW, "> $tmp");
    flock (NEW, LOCK_EX);
    my $date = strftime ("%Y %B %d, %R", localtime((stat ($tmp))[9]));
    print "$date\n";
    print NEW wrap ("", "", @ARGV[1 .. $#ARGV]), "\n";
    print NEW "\n$cmt_div\n\n";
    if (-e $comfile) {
        open (OLD, "< $comfile");
        flock (OLD, LOCK_EX);
        while (my $line = <OLD>) {
            print NEW $line;
        }
        close OLD;
    }

    close NEW;
    rename ($tmp, $comfile) || die "Can't rename $comfile!";
    chmod 0644, $comfile;
    print "iYour comment has been posted.$txt_string\r\n";
    print "1View your comment$go_string\r\n";
    print $footer;
    exit;
} elsif ($#ARGV >= 250) {
    print "3Sorry, comment should be less than 250 words$txt_string\r\n";
}

#print main page
if (($max_posts - 1) > $#posts) {
    $max_posts = $#posts + 1;
}
&print_page (@posts[0 .. ($max_posts - 1)]);
if ($#posts > ($max_posts - 1)) {
    print "1Older Posts\t$base_dir/$name?archive1\t$server\t$port\r\n";
}
print $footer;

#Here there be subroutines

#print individual posts as well as header and div files 
sub print_file {
    my $file = $_[0];
    if (-s $file) {
        open (FH, "< $file") || print "3Can't Open $file!$txt_string\r\n";
        if ($file =~ /txt$/) {
            while (<FH>) {
                chomp; 
                print "i$_$txt_string\r\n";
            }
        } else {
            @tag_list = "";
            while (<FH>) {
                chomp;    
                if ($_ =~ s/^#tags\s+//i) {
                    @tag_list = split (/\s*,\s*/, $_);
                } elsif ( $_ =~ /^[0-9ceghisIMT].+?\t/ ) {
                    print "$_\r\n";
                } elsif ($_ =~ /^--more--$/)  {
                    if ($#ARGV == 0 && $ARGV[0] =~ /post/) {
                        next;
                    } else {
                        print "i$more_text$txt_string\r\n";
                        last;
                    }
                } else {
                    print "i$_$txt_string\r\n";
                } 
            } 
         }
         close (FH);
     }
}

#print pages of posts (main page and archive pages).  Counts comments as well.
sub print_page {
    my @print_list = @_;
    &print_file ($header);
    &print_file ($div);
    foreach my $file (@print_list) {
        my $cmt_count = 0;
        my @p_name = split /\//, $file;
        my $p = 0;
        until ($p_name[$p] =~ /post$/) {
            $p++;
        }
        my $go_string = "\t$base_dir/$name?$p_name[$p]\t$server\t$port";
        my $date = strftime ("%Y %B %d, %R", localtime((stat ($file))[9]));
        
        print "i$date$txt_string\r\n";
        print "i$txt_string\r\n";
        &print_file ($file);
        if (-e "$file.cmt") {
            open (FH, "< $file.cmt") || print "3Can't count comments for $file!$txt_string\r\n";
            while (<FH>) {
                chomp;
                if ($_ =~ /$cmt_div/) {   
                    $cmt_count += 1;
                }
            }
            close (FH);
        }
        print "1$permalink_text($cmt_count)$go_string\r\n";
        if ($tag_list[0]) {
            &print_tags (@tag_list);
        }
        &print_file ($div);
    }
}

#print tag list
sub print_tags {
    my @tags = @_;
    print "i$cmt_div$txt_string\r\n";
    print "iTags:$txt_string\r\n";
    foreach my $tag (@tags) {
        my $tag_link = $tag;
        $tag_link =~ s/\s+/_/g;
        print "1$tag\t$base_dir/$name?tag=$tag_link\t$server\t$port\r\n";
    }
}
