#!/system/bin/sh

## instead of rewriting waver.c to recognize note names just preprocess file.
## note frequencies are equal temperment scale, middle octave.
## see doc/notes.txt
##
## author: Wayne Colvin
## date: Friday June 14th, 2013 (2013-6-14)

cat "$1" | tr "abcdefghijklmnopqrstuvwxyz" "ABCDEFGHIJKLMNOPQRSTUVWXYZ" |
           sed -ne "/^BEGIN=/,/^END=/p" | sed -e "/^BEGIN=/d; /^END=/d" > "$2"

## sharps first

sed -i -e "s/C#/277/g; s/F#/370/g; s/G#/415/g;" "$2"

## now the flats

sed -i -e "s/E_/311/g; s/B_/466/g;" "$2"

## with sharps/flats out of the way regular notes won't get mixed up

sed -i -e "s/C/262/g; s/D/294/g; s/E/330/g" "$2"
sed -i -e "s/F/349/g; s/G/392/g; s/A/440/g; s/B/494/g" "$2"

## note "p" and "r" added for pause/rest, meaning frquency of 0 Hz.
## case insitive since all made uppercase above

sed -i -e "s/P/0/g; s/R/0/g" "$2"

echo -e "\n------------------------------------------------------\n" >> "$2"
echo "This file was autogenerated by 'notes.sh'" >> "$2"
echo "using '$1' as input." >> "$2"
echo -e "\n------------------------------------------------------\n" >> "$2"

cat "$1" | sed -ne "/^COMMENT=/,/^END=/p" >> "$2"

