#!/system/bin/sh

## MHTML web archive lister, *usually* giving descriptive link names.
## those titles sometimes have extra crude in them, sometimes no title...
## makes use of helper script title.sh
## tweak as fits the occassion.
## by Wayne Colvin, 2013 or thereabouts, use as you wish, use at own risk!


SRC="./doc/"
DEST="./doc/"

echo "<html><body><ul>" > "$DEST"/index.html

for i in $(ls -tr "$SRC"/webpages/* | grep '\.[m]\?htm[l]\?$'); do
    echo -n "<li><a href='webpages/$(basename $i)'>" >> "$DEST"/index.html

    ## not all saved webpages have a title or detectable title,
    ## title.sh now modified to return shell false if none found
    
    sh title.sh $i >> "$DEST"/index.html ||
    echo $(basename "$i") >> "$DEST"/index.html
    
    echo "</a></li><br>" >> "$DEST"/index.html;
done

for i in $(ls -tr "$SRC"/*.txt); do
    echo -n "<li><a href='$(basename $i)'>" >> "$DEST"/index.html
    echo $(basename "$i") >> "$DEST"/index.html
    echo "</a></li><br>" >> "$DEST"/index.html;
done

echo "</ul></body></html>" >> "$DEST"/index.html

