#!/usr/bin/php
<?php
// Slight BBS, Basic telnet "BBS" for PHP/Linux (v0.92)
// Inspired by, but not a clone of, bboard on sdf.org
// run from inetd/xinetd on whatever port you'd like

/*
The MIT License (MIT)
Copyright (c) 2016 Joe Lyman (tfurrows@sdf.org)
Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

//// [CONFIGURATION & VARS]

// files and locations
$docRoot = "/srv/bbs/docs";
$boardRoot = "/srv/bbs/boards";
$lastLoginRoot = "/srv/bbs/login";	// directory with last login information for each user
$authValid = "/srv/bbs/validated";	// flatfile for validated email addresses, should be readable only by bbs user, not world readable
$authWaiting = "/srv/bbs/codes";	// flatfile for email addresses with codes, can be world readable or not
$logFile = "/srv/bbs/visits.log";

// ASCII Documents
$startDoc = "welcome";
$helpDoc = "help";
$help2Doc = "help2";
$validateDoc = "validate";
$loginDoc = "login";
$rulesDoc = "rules";

// additional config
$nl = "\r\n"; //  newline
$currentBoard = "GENERAL"; // the board you want them to start in
$hline = str_repeat("-",60).$nl;
$siteBoards = array(
	"FEEDBACK",
	"GUESTBOOK",
	"BUGS",
	"ANNOUNCE"
); // boards that will show at the bottom of the list as "system" boards
$logIgnore = array(
	"192.168.1.1",
	"127.0.0.1",
	"Unknown Host"
); // hosts that will not be logged

// additional variables (non-config)
$colorState = false; // we'll turn it on and set the colors during [INIT]
$fg_color = array();
$bg_color = array();
$color_reset = "";
$loggedIn = "";
$lastLogin = 0;
$reportVersion = "Slight BBS v0.91, 2016 (c) Joe Lyman, MIT License";

//// [INIT]

// stream timeout for telnet users (not CLI)
stream_set_timeout(STDIN, 60);

// Get remote IP/info
if(isset($_SERVER['REMOTE_HOST'])) {
	$remoteIp = $_SERVER['REMOTE_HOST'];
} else {
	$remoteIp = "Unknown Host";
}

// get a list of valid users & their codes
$validEmails = array();
$validUsers = array();
$fp = fopen($authValid,"r");
if($fp) {
	while (($line = fgets($fp)) !== false) {
		$emailCode = explode("|",trim($line));
		$validEmails[] = $emailCode[0];
		$validUsers[$emailCode[0]] = $emailCode[1];
	}
	fclose($fp);
}

// get a list of boards on the system
$boardDirs = glob($boardRoot . '/*' , GLOB_ONLYDIR);
$boardNames = array();
foreach($boardDirs as $boardDir) {
	$boardNames[] = basename($boardDir);
}

// serve up the starting document
color_toggle();
echo $clearScreen;
echo readDoc("$docRoot/$startDoc");
echo $nl;

//// [FUNCTIONS]
function logEntry($entry) {
	global $logFile,$remoteIp,$logIgnore,$nl;

	if(in_array($remoteIp,$logIgnore)) {
		return;
	}

	$logEntry = "[".date("D M j G:i:s T Y")."] -- $entry -- $remoteIp".$nl;
	file_put_contents($logFile,$logEntry, FILE_APPEND | LOCK_EX);
}

function getLine () {
	global $nl;
	// get a line from STDIN, and handle timeout
	$getLine = fgets(STDIN);
	$getLine = rtrim($getLine);

	// timeout
	$timeOutCheck = stream_get_meta_data(STDIN);
	if($timeOutCheck['timed_out']==true) {
		logEntry("Timeout");
		echo "Connection timed out after 60 seconds with no input. Goodbye.".$nl;
		exit;
	}

	return $getLine;
}

function getMultiLines () {
	// multi-line input loop
	// longer timeout here

	global $nl;

	$bodyLine = "";
	$messageBody = "";
	$timesOut = 0;

	while (strtolower($bodyLine) != "/done") {
		$bodyLine = "";
		$bodyLine = fgets(STDIN);
		$bodyLine = rtrim($bodyLine);

		// timeout check
		$timeOutCheck = stream_get_meta_data(STDIN);
		if($timeOutCheck['timed_out']==true) {
			$timesOut++;

			if($timesOut>5) {
				echo $nl."Timed out after a long period of inactivity. Sorry.".$nl;
				exit;
			}
		} else {
			if(strtolower($bodyLine) != "/done") {
				$messageBody [] = $bodyLine;
			}
		}
	}

	return $messageBody;
}

function getMessageList ($board) {
	// build an array list of posts in a board
	//$listPosts = array_reverse(glob($board.'/*', GLOB_ONLYDIR));
	$listPosts = glob($board.'/*', GLOB_ONLYDIR);
	usort($listPosts, create_function('$b,$a', 'return filemtime($a) - filemtime($b);'));

	if(count($listPosts)>0) {
		$postCount = 0;
		$postNumbers = array();

		foreach($listPosts as $post) {
			// assign a number for a post
			$postCount++;
			$postNumbers[$postCount] = $post;
		}

		return $postNumbers;
	} else {
		return 0;
	}
}

function getThreadInfo($post) {
	// get info from a single thread, original post
	$threadInfo = array();

	$postfp = fopen($post."/original",'r');
	$line = fgets($postfp);
	$threadInfo['subject'] = fgets($postfp);
	$threadInfo['author'] = fgets($postfp);
	$threadInfo['date'] = fgets($postfp);
	fclose($postfp);

	// get number of posts in thread
	$threadInfo['count'] = count(glob($post."/*"));

	return $threadInfo;
}

function color_toggle () {
	global $colorState, $color_reset, $fg_color, $bg_color, $clearScreen;

	if(!isset($colorState) || $colorState == false) {
		$colorState = true;
		// Colors are currently OFF, turn them ON
		$clearScreen = "\033[2J\033[H";
		$color_reset = "\033[0m";
		$fg_color['black'] = "\033[0;30m";
		$fg_color['dark_gray'] = "\033[1;30m";
		$fg_color['blue'] = "\033[0;34m";
		$fg_color['light_blue'] = "\033[1;34m";
		$fg_color['green'] = "\033[0;32m";
		$fg_color['light_green'] = "\033[1;32m";
		$fg_color['cyan'] = "\033[0;36m";
		$fg_color['light_cyan'] = "\033[1;36m";
		$fg_color['red'] = "\033[0;31m";
		$fg_color['light_red'] = "\033[1;31m";
		$fg_color['purple'] = "\033[0;35m";
		$fg_color['light_purple'] = "\033[1;35m";
		$fg_color['brown'] = "\033[0;33m";
		$fg_color['yellow'] = "\033[1;33m";
		$fg_color['light_gray'] = "\033[0;37m";
		$fg_color['white'] = "\033[1;37m";

		$bg_color['black'] = "\033[40m";
		$bg_color['red'] = "\033[41m";
		$bg_color['green'] = "\033[42m";
		$bg_color['yellow'] = "\033[43m";
		$bg_color['blue'] = "\033[44m";
		$bg_color['magenta'] = "\033[45m";
		$bg_color['cyan'] = "\033[46m";
		$bg_color['light_gray'] = "\033[47m";
	} else {
		$colorState = false;
		// Colors were ON, turn them OFF
		$color_reset = "";
		$clearScreen = "";
		$fg_color['black']  = '';
		$fg_color['dark_gray']  = '';
		$fg_color['blue']  = '';
		$fg_color['light_blue']  = '';
		$fg_color['green']  = '';
		$fg_color['light_green']  = '';
		$fg_color['cyan']  = '';
		$fg_color['light_cyan']  = '';
		$fg_color['red']  = '';
		$fg_color['light_red']  = '';
		$fg_color['purple']  = '';
		$fg_color['light_purple']  = '';
		$fg_color['brown']  = '';
		$fg_color['yellow']  = '';
		$fg_color['light_gray']  = '';
		$fg_color['white']  = '';

		$bg_color['black']  = '';
		$bg_color['red']  = '';
		$bg_color['green']  = '';
		$bg_color['yellow']  = '';
		$bg_color['blue']  = '';
		$bg_color['magenta']  = '';
		$bg_color['cyan']  = '';
		$bg_color['light_gray']  = '';
	}
}

function ct($text,$color) {
	// COLOR TEXT: return text with ansi foreground color codes wrapped around it
	// todo: support background colors with another parameter
	global $fg_color,$color_reset;
	if(isset($fg_color[$color])) {
		return $fg_color[$color].$text.$color_reset;
	} else {
		return $text;
	}
}

function readDoc($docName) {
	// to replace line endings with whatever is specified in config var
	global $nl;
	$orig_text = file_get_contents($docName);
	$new_text = preg_replace('/\R/u',$nl,$orig_text);
	return $new_text;
}

function setLastLogin($email) {
	// saves last login, or last newscan time, in a file for the use
	// also retrieves the last login time from the file before resetting it
	global $lastLoginRoot,$lastLogin;
	$emailParts = explode("@",$email);
	$loginFile = $lastLoginRoot."/".preg_replace('/[^a-z0-9]/', '', $emailParts[0])."_at_".$emailParts[1];

	if(file_exists($loginFile)) $lastLogin = file_get_contents($loginFile);

	$loginfp = fopen($loginFile,"w");
	fwrite($loginfp,"".time());
	fclose($loginfp);
}


//// [MAIN COMMAND LOOP]
logEntry("Connect");

// initial variables
$data = "";
$data1 = "";
$prompt = "COMMAND (h for help)";
$cmdCount = 0;
$passCommand = "l";	// use: break out of a case but jump into another
			// Set passCommand to something here before the command loop 
			// if you want a default initial command

$passArg = "";		// use: after breaking and jumping, pass yet another item to that case

while($data != "q" && $data != "Q") {
	// Display help offer intelligently

	// the first few times they enter any command, it will give the help prompt
	// after that, it will reset back to the help prompt only if they enter a
	// blank command, then it will show a few more times.

	$cmdCount++;
	if($cmdCount>3) $prompt = "COMMAND"; 

	// Prompt for a command unless one was passed from a case
	if($passCommand == "") {
		echo $nl."[".ct($currentBoard,"cyan")."] $prompt :> ";
		$data = getLine();
	} else {
		$data = $passCommand;
		$passCommand = "";
	}

	// If blank, they may need help.
	if($data == "") {
		$cmdCount = 0;
		$prompt = "COMMAND (h for help)";
	}


	// Pre-process certain commands with [space]<arg> syntax, like "g boardname"
	//if(substr($data,0,2) == "g ") {
	if(preg_match("/([a-z])\ .*?/i",$data)) {
		$passArg = substr($data,2); 
		$data = substr($data,0,1);
	}

	// Process commands
	switch ($data) {
		case "version":
			echo $hline.ct($reportVersion,"green").$nl.$hline;
			break;
		case "h":
			// (h)elp menu
			echo readDoc("$docRoot/$helpDoc");
			break;
		case "?":
			// (?) expanded help menu
			echo readDoc("$docRoot/$help2Doc");
			break;
		case "!":
			// (!) rules menu
			echo readDoc("$docRoot/$rulesDoc");
			break;
		case "v":
			// (v)alidate a user's email
			// first, ask if they already have a code (here for step 2)
			echo "Do you have a code yet? (y/N) :>";

			$data1 = getLine();
			$data1 = strtolower($data1);

			if($data1 == "y") {
				// Step 2, validate code+email
				echo "Good. What email address was the code sent to?".$nl;
				echo "(your email address) :>";

				// Get email
				$email = "";
				$email = getLine();

				// Make sure they're not already validated
				if(in_array($email,$validEmails)) {
					echo "That email address has already been validated.".$nl;
					break;
				}

				echo "What code did you receive?".$nl;
				echo "(your code) :>";

				$code = "";
				$code = getLine();

				// Check that they match
				$fp = fopen($authWaiting,"r");
				if($fp) {
					while (($line = fgets($fp)) !== false) {
						$line = trim($line);
						$emailCode = explode("|",$line);

						if($emailCode[0] == $email && $emailCode[1] == $code) {
							// Match found. ask for new pin
							echo "Email and validation code matched. Email validated.".$nl.$nl;
							echo "Now, you'll need to choose a pin that will be used for posting.".$nl;
							echo "Choose a 4-digit pin that you can remember. Only the first 4 digits".$nl."of what you type will be used.".$nl;
							echo "(your 4-digit pin, echo is on) :>";

							$pin = "";
							$pin = getLine();
							$pin = substr($pin,0,4);

							file_put_contents($authValid,$email."|".$pin.$nl, FILE_APPEND | LOCK_EX);
							logEntry("Email $email validated");
							echo "Pin saved. You can now login and post.".$nl;
							$validEmails[] = $email;
							$validUsers[$email] = $pin;
							logEntry("Validated $email");
						}
					}
					fclose($fp);
				}
				if(isset($pin) && $pin != "") {
					break;
				}
				echo "Match not found for [$email] and [$code]. Please try again.".$nl;

			} elseif($data1 == "n") {
				// Step 1, send code to email
				echo $clearScreen;
				echo readDoc("$docRoot/$validateDoc");
				echo "(your email address) :>";

				// Get email
				$email = "";
				$email = getLine();

				if(filter_var($email,FILTER_VALIDATE_EMAIL)) {
					// A valid email address was provided
					// make sure they're not abusing the system

					// First, are they already validated?
					if(in_array($email,$validEmails)) {
						echo "That email is already validated.".$nl;
						break;
					}

					// Next, are they already waiting to be validated more than n times?
					// we'll allow for a certain number of validation emails, in case
					// they can't find one.

					$waitingCount = 0;
					$fp = fopen($authWaiting,"r");
					if($fp) {
						while (($line = fgets($fp)) !== false) {
							$emailCode = explode("|",$line);
							//$waitingEmails[] = $emailCode[0];
							//$waitingUsers[] = array("email"=>$emailCode[0],"code"=>$emailCode[1]);
							if($email == $emailCode[0]) {
								$waitingCount++;
							}
						}
						fclose($fp);
					}
					if($waitingCount>2) {
						echo $nl."[".ct("ERROR!","red")."]It looks like you've tried 5 times to validate.".$nl."Please get some help.".$nl.$nl;
						break;
					}

					// Generate, save, and send the code
					$p1 = str_pad(rand(0, pow(10, 4)-1), 4, '0', STR_PAD_LEFT);
					$p2 = str_pad(rand(0, pow(10, 4)-1), 4, '0', STR_PAD_LEFT);
					$p3 = str_pad(rand(0, pow(10, 4)-1), 4, '0', STR_PAD_LEFT);
					$validCode = $p1."-".$p2."-".$p3;

					file_put_contents($authWaiting,$email."|".$validCode.$nl, FILE_APPEND | LOCK_EX);

					$message = "Thanks for validating your email for use on jozhaus.com port 2323. Please reconnect to the BBS and (v)alidate with the following code. This code is NOT your pin; you will create your pin after you validate.".$nl.$nl."     CODE: $validCode".$nl;
					mail($email,"Jozhaus BBS email validation",$message);
					logEntry("Validation sent $email");

					echo "Validation message sent to $email.".$nl;
					echo ct("Please check your email and come back to validate the code.","green").$nl;


				} else {
					// Error, invalid email address entered
					echo "[".ct("ERROR!","red")."] - Invalid email".$nl;
					echo "For some reason, our system did not view that as a vaild email. Try again.".$nl;

				}
			}

			break;
		case "l":
			// (l)ist boards
			// display a header for this list of boards
			echo $nl;
			echo "  [".ct("BOARD","yellow")."]             [".ct("POSTS","yellow")."]  [".ct("TOPIC","yellow")."]".$nl;
			echo $hline;

			$regBoards = "";
			$sBoards = "";

			foreach($boardDirs as $boardDir) {
				// get board topic
				$topic = readDoc($boardDir."/topic");

				// get board post count (from dir listing)
				if(isset($listPosts)) unset($listPosts);
				$listPosts = glob($boardDir . '/*' , GLOB_ONLYDIR);

				$postCount = str_pad(count($listPosts),4,'0',STR_PAD_LEFT);

				$boardName = basename($boardDir);
				$padding = str_repeat(" ",20 - strlen($boardName));
				if(in_array($boardName,$siteBoards)) {
					$sBoards .= "  ".ct($boardName,"cyan").$padding."[".ct($postCount,"yellow")."]   $topic ".$nl;
				} else {
					$regBoards .= "  ".ct($boardName,"cyan").$padding."[".ct($postCount,"yellow")."]   $topic ".$nl;
				}
			}

			echo $regBoards;
			echo "----- [System Boards] ".str_repeat("-",38).$nl;
			echo $sBoards;
			break;
		case "g":
			// (g)oto a board
			if($passArg == "") {
				echo "(goto which board?) :>";
				$gotoBoard = "";
				$gotoBoard = getLine();
			} else {
				$gotoBoard = $passArg;
				$passArg = "";
			}

			$gotoBoard = strtoupper($gotoBoard);

			if($gotoBoard == "") {
				// bboard style behavior, if they hit g but don't enter anything if gives a list
				echo "No board name specified. Here's a list:".$nl;
				$passCommand = "l";
				break;
			}

			// see if the board exists
			if(in_array($gotoBoard,$boardNames)) {
				$currentBoard = $gotoBoard;
				$topic = readDoc($boardRoot."/".$currentBoard."/topic");
				echo $hline;
				echo "You are now in the ".ct($currentBoard,"cyan")." board.".$nl;
				echo $hline;
				echo $topic.$nl;
			} else {
				echo "Couldn't find the ".ct($gotoBoard,"cyan")." board.".$nl;
			}

			break;
		case "M":
		case "m":
			// (m)essage list for current board
			// (M)essage list with reply authors and dates (bboard style)
			$postNumbers = getMessageList($boardRoot."/".$currentBoard);

			if($postNumbers == 0) {
				echo "No message threads in the ".ct($currentBoard,"cyan")." board".$nl;
				echo "Why not start a new one with \"n\"?".$nl;
				break;
			}

			// message listing header
			echo $clearScreen;
			echo $hline;
			echo "  Message thread list for ".ct($currentBoard,"cyan")." board (newest first)".$nl;
			echo "  [ ".ct("ID","yellow")."]  [".ct("DATE","yellow")."]   [".ct("AUTHOR","yellow")."]       [".ct("SUBJECT","yellow")."]".$nl;
			echo $hline;

			// Go through each message folder, get info and display
			foreach($postNumbers as $pn => $post) {
				$threadInfo = getThreadInfo($post);

				$subject = trim(str_replace("[SUBJECT]","",$threadInfo['subject']));
				$author = strtok(trim(str_replace("[AUTHOR]","",$threadInfo['author']))," ");
				if(strlen($author)>13) {
					$author = substr($author,0,13).">";
				}
				if(strlen($author)<14) {
					$author = str_pad($author,14," ");
				}

				//$author = str_pad(substr(strtok(trim(str_replace("[AUTHOR]","",$threadInfo['author']))," "),0,12),14,".");
				$date = trim(str_replace("[DATE]","",$threadInfo['date']));

				$tsDate = strtotime($date);
				$fmtDate = date("m/d/y",$tsDate);
				$fmtPostNum = str_pad($pn,3,' ',STR_PAD_LEFT);

				echo "  [".ct($fmtPostNum,"yellow")."]  ".ct($fmtDate,"red")." ".ct($author,"yellow")." $subject (".ct("posts: ".$threadInfo['count'],"light_blue").")".$nl;

				// If they specified "M" for a full listing, give it to them
				if($data == "M") {
					// build list of posts in this thread
					if(isset($listReplies)) unset($listReplies);
					$listReplies = glob($post.'/*');
					usort($listReplies, create_function('$a,$b', 'return filemtime($a) - filemtime($b);'));

					foreach($listReplies as $reply) {
						if(substr(strrchr($reply,"/"),1) == "original") continue;
						preg_match("/([0-9]+)\-(.*)/",substr(strrchr($reply,"/"),1),$matches);
						$replyDate = $matches[1];
						$author = $matches[2];
						echo "         ".ct(date("m/d/y",$replyDate),'red')." ".ct($author,'yellow').$nl;
					}
					echo $hline;

				} else {
					//echo $hline;
				}
			}

			if($data == "m") {
				echo $hline;
				echo "Enter \"M\" to expand all reply authors/dates on this board.".$nl;
			}
			break;
		case "t":
			// (t)ype a message, in other words, view a thread
			$postNumbers = getMessageList($boardRoot."/".$currentBoard);

			if($postNumbers == 0) {
				echo "No message threads in the ".ct($currentBoard,"cyan")." board".$nl;
				echo "Type \"n\" to start a new thread...".$nl;
				break;
			}

			// find out which message they want to view
			if($passArg == "") {
				echo "(type which message thread ID?) :>";
				$typeId = "";
    				$typeId = getLine();
			} else {
				$typeId = $passArg;
				$passArg = "";
			}

			if($typeId == "") {
				echo "Cancelled.".$nl;
				break;
			}

			// see if that thread exists
			if(isset($postNumbers[$typeId])) {
				// It exists, show them the latest post, and offer contextual menu
				// contextual: (r)eply, (o)lder, (n)ewer, (f)irst post, (d)one

				// build list of posts in this thread
				if(isset($listMessages)) unset($listMessages);
				$listMessages = glob($postNumbers[$typeId].'/*');
				usort($listMessages, create_function('$b,$a', 'return filemtime($a) - filemtime($b);'));

				$threadCount = count($listMessages);
				$viewMessage = 0;

				// View the latest message in the thread
				echo $clearScreen;
				//echo wordwrap(file_get_contents($listMessages[$viewMessage]),60,$nl);
				echo readDoc($listMessages[$viewMessage]).$nl;

				// Context menu loop
				$typeContext = "";
				while($typeContext != "d" && $typeContext != "D") {
					// context "menu"
					echo $nl;
					echo "Viewing message ".ct(($threadCount - $viewMessage),"yellow")." of ".ct($threadCount,"yellow").$nl;
					echo "(".ct("r","yellow").")eply, (".ct("o","yellow").")lder, (".ct("n","yellow").")ewer, (".ct("f","yellow").")irst post, (".ct("d","yellow").")one :>";

					$typeContext = "";
					$typeContext = getLine();

					switch($typeContext) {
						case "r":
							// reply to this thread
							$passCommand = "r";
							$passArg = $typeId;
						break 2; // break out of main swtich as well
						case "o":
							// next message in thread
							if($threadCount-$viewMessage == 1) {
								echo ct("Already at the original post.","yellow").$nl;
								break;
							}

							$viewMessage++;

							echo $clearScreen;
							//echo wordwrap(file_get_contents($listMessages[$viewMessage]),60,$nl);
							echo readDoc($listMessages[$viewMessage]).$nl;
						break;
						case "n":
							// previous message in thread
							if($viewMessage == 0) {
								echo ct("Already at the latest post.","yellow").$nl;
								break;
							}

							$viewMessage--;

							echo $clearScreen;
							//echo wordwrap(file_get_contents($listMessages[$viewMessage]),60,$nl);
							echo readDoc($listMessages[$viewMessage]).$nl;
						break;
						case "f":
							// view first post in thread
							$viewMessage = $threadCount-1;

							echo $clearScreen;
							//echo wordwrap(file_get_contents($listMessages[$viewMessage]),60,$nl);
							echo readDoc($listMessages[$viewMessage]).$nl;
						break;
						default:
					}
				}

			} else {
				echo "No message thread with that ID was found.".$nl;
				echo "Type \"m\" or \"M\" to list all message threads in this board.".$nl;
			}
			break;
		case "r":
			// Post a reply to a thread
			if($loggedIn == "") {
				echo "You must (login) before posting a reply.".$nl;
				$passArg = "";
				break;
			}

			$postNumbers = getMessageList($boardRoot."/".$currentBoard);

			if($postNumbers == 0) {
				echo "No message threads in the ".ct($currentBoard,"cyan")." board.".$nl;
				echo "Type \"n\" to start a new thread...".$nl;
				break;
			}

			// find out which message they want to reply to, unless one was passed
			if($passArg == "") {
				echo "(reply to which message thread ID?) :>";

				$typeId = "";
				$typeId = getLine();
			} else {
				$typeId = $passArg;
				$passArg = "";
			}

			// see if that thread exists
			if(isset($postNumbers[$typeId])) {
				// get the thread subject from the original post and display it
				$threadInfo = getThreadInfo($postNumbers[$typeId]);

				echo $clearScreen;
				echo "  Replying to the following message thread in the ".ct($currentBoard,"cyan")." board.".$nl;
				echo $hline;
				echo $threadInfo['subject'];
				echo $threadInfo['author'];
				echo $threadInfo['date'];
				echo $hline;

				echo "[YOUR REPLY] (enter \"/done\" on a new line to finish)".$nl;
				echo $hline;

				$replyText = getMultiLines();

				if($replyText == "") {
					echo "Cancelled.".$nl;
					break;
				}

				// Verify reply post is what they want.
				$emailParts = explode("@",$loggedIn);
				$postDate = date("D M j G:i:s T Y");

				$msgSave = $hline;
				$msgSave .= str_replace("[SUBJECT]","[SUBJECT] RE:",$threadInfo['subject']);
				$msgSave .= "[AUTHOR]  ".$emailParts[0]." [at] ".$emailParts[1].$nl;
				$msgSave .= "[DATE]    ".$postDate.$nl;
				$msgSave .= $hline;
				$msgSave .= implode($nl,$replyText).$nl;
				$msgSave .= $hline;

				echo $clearScreen;
				echo $msgSave.$nl;
				echo "Create new reply as shown above? (Y/n)? :>";

				$confirm = "";
				$confirm = getLine();
				$confirm = strtolower($confirm);

				if($confirm == "n") {
					echo "Cancelled.".$nl;
					break;
				}

				// Save reply to a file
				$newFile = $postNumbers[$typeId]."/".time()."-".preg_replace('/[^a-z0-9]/', '', $emailParts[0]);

				$newfp = fopen($newFile,"w");
				fwrite($newfp,$msgSave);
				fclose($newfp);

				echo "New reply created.".$nl;

			} else {
				echo "No message thread with that ID was found.".$nl;
			}

			break;
		case "s":
			// (s)can for new messages since last login/scan
			if($loggedIn == "") {
				echo "(s)can is only available after logging in.".$nl;
				break;
			}

			echo ct("Scanning for new messages since last login or last scan...","green").$nl;
			echo $hline;

			foreach($boardNames as $boardName) {
				echo "Scanning ".ct($boardName,"cyan")."... ";

				$numNew=0;
				$listPosts = glob($boardRoot."/".$boardName.'/*', GLOB_ONLYDIR);
				foreach($listPosts as $post) {
					if(filemtime($post) > $lastLogin) $numNew++;
				}

				if($numNew>0) {
					echo ct("$numNew new posts.","blue").$nl;
				} else {
					echo "No new posts.".$nl;
				}
			}

			// Set lastlogin to now, and update lastlogin file
			setLastLogin($loggedIn);
			$lastLogin = time();

			echo $hline;
			echo "Updated latest scan time to now.".$nl;
			break;
		case "c":
			// Disable/enable ansi colors
			color_toggle();
			if($colorState == false) {
				echo "ANSI color codes are now OFF.".$nl;
			} else {
				echo ct("ANSI color codes are now ON.","green").$nl;
			}
			break;
		case "n":
			// (n)ew post in current board
			if($loggedIn == "") {
				echo "You must (login) before starting a message thread.".$nl;
				break;
			}

			echo $clearScreen;
			echo $hline;
			echo "  Creating a new thread on the ".ct($currentBoard,"cyan")." board".$nl;
			echo $hline;

			echo "[SUBJECT] :>";

			$subject = "";
			$subject = getLine();
			$subject = mb_strimwidth($subject,0,60, "...");

			if($subject == "") {
				echo "Cancelled.".$nl;
				break;
			}

			echo "[BODY] (enter \"/done\" on a new line to finish)".$nl;
			echo $hline;

			$messageBody = getMultiLines();

			if($messageBody == "") {
				echo "Cancelled.".$nl;
				break;
			}

			// Verify post is what they want.
			$emailParts = explode("@",$loggedIn);
			$postDate = date("D M j G:i:s T Y");

			$msgSave = $hline;
			$msgSave .= "[SUBJECT] ".$subject.$nl;
			$msgSave .= "[AUTHOR]  ".$emailParts[0]." [at] ".$emailParts[1].$nl;
			$msgSave .= "[DATE]    ".$postDate.$nl;
			$msgSave .= $hline;
			$msgSave .= implode($nl,$messageBody).$nl;
			$msgSave .= $hline;

			echo $clearScreen;
			echo $msgSave.$nl;
			echo "Create new thread as shown above? (Y/n)? :>";

			$confirm = "";
			$confirm = getLine();
			$confirm = strtolower($confirm);

			if($confirm == "n") {
				echo "Cancelled.".$nl;
				break;
			}

			// Save to a file 
			$newFolder = $boardRoot."/".$currentBoard."/".time()."-".preg_replace('/[^a-z0-9]/', '', $emailParts[0]);

			mkdir($newFolder);

			$newfp = fopen($newFolder."/original","w");
			fwrite($newfp,$msgSave);
			fclose($newfp);

			echo "New thread created.".$nl;

			break;
		case "login":
			// (login) authenticate for this session
			if($loggedIn != "") {
				echo "You already authenticated this session.".$nl;
				break;
			}

			echo readDoc("$docRoot/$loginDoc");
			echo "(your validated email address) :>";

			// Get email
			$email = "";
			$email = getLine();

			if($email == "") {
				echo "Cancelled.".$nl;
				break;
			}

			echo "(your pin) :>";

			// Get pin
			$pin = "";
			$pin = getLine();

			if($pin == "") {
				echo "Cancelled.".$nl;
				break;
			}

			// Check against list
			if(in_array($email,$validEmails)) {
				if($validUsers[$email]==$pin) {
					// Email and pin valid, logged in

					// save last login time, for new message scan
					setLastLogin($email);

					// Welcome them, set logged in
					echo $clearScreen;
					echo "You are authenticated for this session.".$nl;
					$loggedIn = $email;
					logEntry("Login $email");
				} else {
					echo "The pin you entered was incorrect.".$nl;
				}
			} else {
				echo "That email address has not been validated yet.".$nl;
			}

			break;
		default:
	}

}

//echo $clearScreen;
echo "Goodbye.".$nl;

// log the disconnect
logEntry("Disconnect");

?>
