DECLARE SUB damagehero (damagelevel!)
DECLARE SUB delay (waittime!)
DECLARE SUB enemyreset (c!)

RANDOMIZE TIMER

TYPE badguy
    x AS SINGLE
    y AS SINGLE
    xv AS SINGLE
    yv AS SINGLE
    w AS INTEGER
    h AS INTEGER
END TYPE

TYPE goodguy
    x AS SINGLE
    y AS SINGLE
    xv AS SINGLE
    yv AS SINGLE
    w AS INTEGER
    h AS INTEGER
END TYPE

ENEMYS = 10
DEL = .01
DELMOD = 10

DIM SHARED enemy(ENEMYS) AS badguy
DIM SHARED enemyimg(100)
DIM SHARED heroimg(100)
DIM SHARED damage

FOR c = 1 TO ENEMYS
    enemyreset (c)
NEXT c

hero.x = 160
hero.y = 100
hero.xv = 0
hero.yv = 0
hero.w = 10
hero.h = 10
hero.v = .05


SCREEN 13

CIRCLE (5, 5), 4, 12
PAINT (5, 5), 12
GET (0, 0)-(10, 10), enemyimg

CIRCLE (5, 5), 3, 2
PAINT (5, 5), 2
GET (0, 0)-(10, 10), heroimg
CLS

LINE (0, 0)-(319, 15), 4, B
LINE (4, 4)-(106, 10), 4, B

PUT (hero.x, hero.y), heroimg, PSET

DO
    getkey$ = RIGHT$(INKEY$, 1)

    IF getkey$ <> "" THEN
        IF getkey$ = "K" THEN hero.xv = hero.xv - hero.v
        IF getkey$ = "H" THEN hero.yv = hero.yv - hero.v
        IF getkey$ = "M" THEN hero.xv = hero.xv + hero.v
        IF getkey$ = "P" THEN hero.yv = hero.yv + hero.v
    END IF

    IF hero.xv <> 0 OR hero.yv <> 0 THEN
        PUT (hero.x, hero.y), heroimg, XOR
       
        hero.x = hero.x + hero.xv
        hero.y = hero.y + hero.yv
      
        IF hero.x < 1 OR hero.x > 319 - hero.w THEN
            hero.x = hero.x - hero.xv
            hero.xv = -hero.xv
            damagehero (1)
        END IF

        IF hero.y < 16 OR hero.y > 199 - hero.h THEN
            hero.y = hero.y - hero.yv
            hero.yv = -hero.yv
            damagehero (1)
        END IF

        PUT (hero.x, hero.y), heroimg, PSET
    END IF

    FOR c = 1 TO ENEMYS

        PUT (enemy(c).x, enemy(c).y), enemyimg, XOR
      
        enemy(c).x = enemy(c).x + enemy(c).xv
        enemy(c).y = enemy(c).y + enemy(c).yv

        IF enemy(c).x < 1 OR enemy(c).x > 319 - enemy(c).w OR enemy(c).y < 16 OR enemy(c).y > 199 - enemy(c).h THEN enemyreset (c)
        IF ABS(enemy(c).x - hero.x) < hero.w - 1 AND ABS(enemy(c).y - hero.y) < hero.h - 1 THEN damagehero (.5)

        PUT (enemy(c).x, enemy(c).y), enemyimg, PSET
        
    NEXT c

    delayjump = delayjump + 1
    IF (delayjump MOD DELMOD) = 0 THEN delay (DEL)

LOOP UNTIL getkey$ = "q"

SUB damagehero (damagelevel)
 
    IF damage > 100 THEN
        LOCATE 1, 12
        PRINT "SHIELDS DEPLETED"
        END
    END IF

    damage = damage + damagelevel
    LINE (5, 5)-(damage + 5, 9), 3, BF

END SUB

SUB delay (waittime!)
   
    TIMER ON
    start! = TIMER
    DO
    LOOP UNTIL TIMER > start! + waittime!

END SUB

SUB enemyreset (c)

    enemy(c).x = 1 + RND * 308
    enemy(c).y = 17
    enemy(c).xv = -.2 + RND * .4
    enemy(c).yv = .1 + RND * .4
    enemy(c).w = 10
    enemy(c).h = 10

END SUB

