DECLARE SUB drawheader (lefttext$, righttext$, bgc!, fgc!)
DECLARE SUB paintbg (sym$, bgc!, fgc!)
DECLARE SUB drawbox (x!, y!, w!, h!, msg$, title$, bgc, fgc)

' /// EXAMPLES

SCREEN 0
WIDTH 80, 25
CLS

CALL paintbg(CHR$(177), 0, 7)

CALL drawheader("Calendar", "", 1, 15)

CALL drawbox(2, 2, 40, 8, "", "", 0, 15)
CALL drawbox(45, 2, 32, 8, "", "", 0, 15)
CALL drawbox(2, 13, 75, 8, "", "", 0, 15)

CALL drawbox(0, 0, 30, 8, "This is a test of the drawbox call. This shows all of the features of that function. supercalifragilisticexpialidocious if you say it loud enough... you get it.", "Another Box", 0, 14)

SUB drawbox (x, y, w, h, msg$, title$, bgc, fgc)
' //// Draw a text box with some text in it

' Set the a/v page
SCREEN 0, , 1, 0

' Set the color
COLOR fgc, bgc

' These are the line characters/style
topleft$ = CHR$(201)
topline$ = CHR$(205)
topright$ = CHR$(187)

leftline$ = CHR$(186)
rightline$ = CHR$(186)

shade$ = CHR$(178)
blankspace$ = " "

botleft$ = CHR$(200)
botline$ = CHR$(205)
botright$ = CHR$(188)

'set the X/Y to center the box, if 0 specified for x/y
IF x < 1 OR y < 1 THEN
        x = 40 - INT(w / 2)
        y = 12 - INT(h / 2)
END IF

h = h + 1

'Go to the top-left
LOCATE y, x

PRINT topleft$; ' top-left corner
FOR c = 1 TO w
        PRINT topline$; ' top line
NEXT c
PRINT topright$; ' top-right corner


FOR c = 1 TO h
        LOCATE y + c, x
        PRINT leftline$; ' left side
        FOR i = 1 TO w
                PRINT blankspace$; ' blank space
        NEXT i
        PRINT rightline$; ' right side
       
        ' shadow
        COLOR 7, 0
        PRINT shade$;
        COLOR fgc, bgc

NEXT c

LOCATE y + h, x

PRINT botleft$; ' bottom-left corner
FOR c = 1 TO w
        PRINT botline$; ' bottom
NEXT c
PRINT botright$;  ' bottom-right corner

' Shadow
COLOR 7, 0
PRINT shade$;
COLOR fgc, bgc

' Conditionally draw the bottom shadow
IF shade$ <> "" THEN
        LOCATE y + h + 1, x + 1
        COLOR 7, 0
        FOR c = 1 TO w + 2
                PRINT shade$;
        NEXT c
        COLOR fgc, bgc
END IF


' OK, the box is drawn, lets put in the optional text

IF msg$ <> "" THEN
       
        ' Break the message up into lines
        gotword = 0
        nextword$ = ""
        thisline$ = ""
        linecount = 0

        FOR i = 1 TO LEN(msg$)
                'skip if we're past our line limit
                IF linecount >= h - 1 THEN EXIT FOR

                'We will read-ahead a single word, to see if we need a CR/LF
                IF gotword = 1 THEN
                        IF LEN(thisline$ + nextword$) + 1 > w THEN
                                ' Too long, we'll print the line and move on
                                LOCATE y + linecount + 1, x + 1
                                PRINT thisline$;
                                linecount = linecount + 1

                                ' Reset
                                thisline$ = nextword$
                                nextword$ = ""
                                gotword = 0
                        ELSE
                                IF thisline$ = "" THEN
                                        thisline$ = nextword$
                                ELSE
                                        thisline$ = thisline$ + " " + nextword$
                                END IF
                                gotword = 0
                                nextword$ = ""
                        END IF
                END IF

                nextletter$ = MID$(msg$, i, 1)
                IF nextletter$ = " " THEN
                        gotword = 1
                ELSE
                        IF LEN(nextword$ + nextletter$) <= w THEN
                                nextword$ = nextword$ + nextletter$
                        END IF
                END IF
               
        NEXT i
       
        ' Process final line/word, if there was one
       
        IF thisline$ <> "" AND linecount < h - 1 THEN

                IF nextword$ <> "" THEN
                        IF LEN(thisline$ + nextword$) + 1 < w THEN
                                thisline$ = thisline$ + " " + nextword$
                        ELSE
                                IF linecount + 1 < h - 1 THEN
                                ' can we squeeze in one more line?
                                END IF
                        END IF
                END IF

                LOCATE y + linecount + 1, x + 1
                PRINT thisline$;

                thisline$ = ""
                nextword$ = ""
        END IF

END IF

' Draw a title if they specified one
IF title$ <> "" THEN
        ' Draw it only if it isn't too long
        titlelen = LEN(title$)
        IF titlelen < (w - 2) THEN
                tx = x + w / 2 - INT(titlelen / 2)
                LOCATE y, tx
                PRINT title$
        END IF
END IF

PCOPY 1, 0
SCREEN 0, , 0, 0

END SUB

SUB drawheader (lefttext$, righttext$, bgc, fgc)
' Draw a header with left and right text
SCREEN 0, , 1, 0

COLOR fgc, bgc
LOCATE 1, 1

FOR i = 1 TO 80
        PRINT " ";
NEXT i

LOCATE 1, 1
PRINT lefttext$


' Copy it to the page
PCOPY 1, 0
SCREEN 0, , 0, 0
END SUB

SUB paintbg (sym$, bgc, fgc)
'//// Routine to fill the text screen

SCREEN 0, , 1, 0

LOCATE 1, 1
COLOR fgc, bgc

FOR y = 1 TO 24
        FOR x = 1 TO 80
                PRINT sym$;
        NEXT x
NEXT y

PCOPY 1, 0
SCREEN 0, , 0, 0

END SUB

