DECLARE SUB paintbg (sym$, bgc!, fgc!)
DECLARE SUB drawbox (x!, y!, w!, h!, msg$, bgc, fgc)

'CLS
'CALL paintbg(CHR$(177), 0, 7)

'CALL drawbox(5, 5, 10, 4, "This is a test box", 1, 12)
'CALL drawbox(8, 8, 20, 6, "To see exactly what is going on here", 1, 12)
'CALL drawbox(10, 10, 18, 3, "Because I really really want to know ok? I want to see what will happen to this supercalifragilisticexpialidocious", 1, 12)
'CALL drawbox(12, 12, 10, 4, "yeah, a test box, got it?", 1, 15)

SUB drawbox (x, y, w, h, msg$, bgc, fgc)
'Draw a text box with some text in it

' Set the color
COLOR fgc, bgc

' These are the line characters/style
topleft$ = CHR$(201)
topline$ = CHR$(205)
topright$ = CHR$(187)

leftline$ = CHR$(186)
rightline$ = CHR$(186)

shade$ = CHR$(178)
blankspace$ = " "

botleft$ = CHR$(200)
botline$ = CHR$(205)
botright$ = CHR$(188)

h = h + 1

'Go to the top-left
LOCATE y, x

PRINT topleft$; ' top-left corner
FOR c = 1 TO w
        PRINT topline$; ' top line
NEXT c
PRINT topright$; ' top-right corner


FOR c = 1 TO h
        LOCATE y + c, x
        PRINT leftline$; ' left side
        FOR i = 1 TO w
                PRINT blankspace$; ' blank space
        NEXT i
        PRINT rightline$; ' right side
       
        ' shadow
        COLOR 7, 0
        PRINT shade$;
        COLOR fgc, bgc

NEXT c

LOCATE y + h, x

PRINT botleft$; ' bottom-left corner
FOR c = 1 TO w
        PRINT botline$; ' bottom
NEXT c
PRINT botright$;  ' bottom-right corner

' Shadow
COLOR 7, 0
PRINT shade$;
COLOR fgc, bgc

' Conditionally draw the bottom shadow
IF shade$ <> "" THEN
        LOCATE y + h + 1, x + 1
        COLOR 7, 0
        FOR c = 1 TO w + 2
                PRINT shade$;
        NEXT c
        COLOR fgc, bgc
END IF


' OK, the box is drawn, lets put in the optional text

IF msg$ <> "" THEN
       
        ' Break the message up into lines
        gotword = 0
        nextword$ = ""
        thisline$ = ""
        linecount = 0

        FOR i = 1 TO LEN(msg$)
                'skip if we're past our line limit
                IF linecount >= h - 1 THEN EXIT FOR

                'We will read-ahead a single word, to see if we need a CR/LF
                IF gotword = 1 THEN
                        IF LEN(thisline$ + nextword$) + 1 > w THEN
                                ' Too long, we'll print the line and move on
                                LOCATE y + linecount + 1, x + 1
                                PRINT thisline$;
                                linecount = linecount + 1

                                ' Reset
                                thisline$ = nextword$
                                nextword$ = ""
                                gotword = 0
                        ELSE
                                thisline$ = thisline$ + " " + nextword$
                                gotword = 0
                                nextword$ = ""
                        END IF
                END IF

                nextletter$ = MID$(msg$, i, 1)
                IF nextletter$ = " " THEN
                        gotword = 1
                ELSE
                        IF LEN(nextword$ + nextletter$) <= w THEN
                                nextword$ = nextword$ + nextletter$
                        END IF
                END IF
               
        NEXT i
       
        ' Process final line/word, if there was one
       
        IF thisline$ <> "" AND linecount < h - 1 THEN

                IF nextword$ <> "" THEN
                        IF LEN(thisline$ + nextword$) + 1 < w THEN
                                thisline$ = thisline$ + " " + nextword$
                        ELSE
                                IF linecount + 1 < h - 1 THEN
                                ' can we squeeze in one more line?
                                END IF
                        END IF
                END IF

                LOCATE y + linecount + 1, x + 1
                PRINT thisline$;

                thisline$ = ""
                nextword$ = ""
        END IF

END IF

END SUB

SUB paintbg (sym$, fgc, bgc)
' Routine to fill the text screen

LOCATE 1, 1
COLOR fgc, bgc

FOR y = 1 TO 24
        FOR x = 1 TO 80
                PRINT sym$;
        NEXT x
NEXT y

END SUB

