DECLARE SUB mainchar (imgfile$)
DECLARE SUB initgame ()
DECLARE SUB drawmap (mapfile$)

SCREEN 13
CLS

' Shared/Global variables
DIM SHARED cellsize
DIM SHARED numsprites
cellsize = INT((24 * 24 + 4) / 2 - 1)
numsprites = 36
DIM SHARED thismap$(1 TO 8, 1 TO 10) ' Enough to hold a single screen/map
DIM SHARED cells(1 TO cellsize * numsprites)
DIM SHARED mcsprites(1 TO cellsize * 24)
DIM SHARED mapup$, mapright$, mapdown$, mapleft$

DIM bgsave(1 TO cellsize)

' Init the game
CALL initgame
CALL mainchar("mainchar.raw")

' Main Program
CALL drawmap("2-3")

charx = 4
chary = 5
chard = 6

mainloop:

GET (charx * 23 - 23, chary * 23 - 23)-(charx * 23, chary * 23), bgsave
PUT (charx * 23 - 23, chary * 23 - 23), mcsprites(1 + ((chard + 4) * cellsize - cellsize)), AND
PUT (charx * 23 - 23, chary * 23 - 23), mcsprites(1 + ((chard + 1) * cellsize - cellsize)), OR

DO
        keypress$ = INKEY$
        ' Extended keys
        IF LEN(keypress$) > 1 THEN

                ' Get the extended codes
                kp1 = ASC(MID$(keypress$, 1, 1))
                kp2 = ASC(MID$(keypress$, 2, 1))

                ' An arrow key was pressed
                IF kp2 > 71 AND kp2 < 81 THEN
                       
                        ' Set the direction
                        IF kp2 = 75 THEN
                                chard = 18

                                ' Check for boundary
                                IF charx - 1 < 1 THEN
                                        charx = 10
                                        CALL drawmap(mapleft$)
                                        GOTO mainloop
                                END IF

                                ' Hit a solid object!
                                IF ASC(thismap$(chary, charx - 1)) > 18 THEN
                                        GOTO skipmove
                                END IF
                        END IF

                        IF kp2 = 72 THEN
                                chard = 0

                                IF chary - 1 < 1 THEN
                                        chary = 8
                                        CALL drawmap(mapup$)
                                        GOTO mainloop
                                END IF
                               
                                ' Hit a solid object!
                                IF ASC(thismap$(chary - 1, charx)) > 18 THEN
                                        GOTO skipmove
                                END IF

                        END IF

                        IF kp2 = 77 THEN
                                chard = 6
                                IF charx + 1 > 10 THEN
                                        charx = 1
                                        CALL drawmap(mapright$)
                                        GOTO mainloop
                                END IF

                                ' Hit a solid object!
                                IF ASC(thismap$(chary, charx + 1)) > 18 THEN
                                        GOTO skipmove
                                END IF

                        END IF

                        IF kp2 = 80 THEN
                                chard = 12
                                IF chary + 1 > 8 THEN
                                        chary = 1
                                        CALL drawmap(mapdown$)
                                        GOTO mainloop
                                END IF

                                ' Hit a solid object!
                                IF ASC(thismap$(chary + 1, charx)) > 18 THEN
                                        GOTO skipmove
                                END IF

                        END IF

                        ' Restore the saved BG
                        PUT (charx * 23 - 23, chary * 23 - 23), bgsave, PSET

                        xmod = 0
                        ymod = 0

                        ' Move the character
                        FOR m = 1 TO 10
                                ' Reduces flicker
                                WAIT &H3DA, 8

                                ' Restore the saved BG
                                PUT ((charx * 23 - 23) + xmod, (chary * 23 - 23) + ymod), bgsave, PSET

                                ' Move in the right direction
                                xmod = 0
                                ymod = 0
                              
                                IF chard = 18 THEN xmod = m * -2
                                IF chard = 0 THEN ymod = m * -2
                                IF chard = 6 THEN xmod = m * 2
                                IF chard = 12 THEN ymod = m * 2

                                ' Select the right sprite to display
                                cs = (m MOD 3)

                                GET ((charx * 23 - 23) + xmod, (chary * 23 - 23) + ymod)-((charx * 23) + xmod, (chary * 23) + ymod), bgsave
                               
                                PUT ((charx * 23 - 23) + xmod, (chary * 23 - 23) + ymod), mcsprites(1 + ((chard + 4 + cs) * cellsize - cellsize)), AND
                                PUT ((charx * 23 - 23) + xmod, (chary * 23 - 23) + ymod), mcsprites(1 + ((chard + 1 + cs) * cellsize - cellsize)), OR
                        NEXT m

                        PUT ((charx * 23 - 23) + xmod, (chary * 23 - 23) + ymod), bgsave, PSET
                       
                        IF kp2 = 75 THEN charx = charx - 1
                        IF kp2 = 72 THEN chary = chary - 1
                        IF kp2 = 77 THEN charx = charx + 1
                        IF kp2 = 80 THEN chary = chary + 1

                        GET (charx * 23 - 23, chary * 23 - 23)-(charx * 23, chary * 23), bgsave
                        PUT (charx * 23 - 23, chary * 23 - 23), mcsprites(1 + ((chard + 4) * cellsize - cellsize)), AND
                        PUT (charx * 23 - 23, chary * 23 - 23), mcsprites(1 + ((chard + 1) * cellsize - cellsize)), OR

                        ' Debug
                        LOCATE 20, 30
                        PRINT ASC(thismap$(chary, charx))
                        LOCATE 21, 30
                        PRINT charx; chary
                        LOCATE 22, 30
                        PRINT kp2

                END IF
skipmove:

        END IF
LOOP WHILE keypress$ <> "Q"

SUB drawmap (mapfile$)

' This loads a single 8x10 cell map into an array
OPEN "maps\" + mapfile$ + ".map" FOR INPUT AS #1
 FOR lines = 1 TO 8
  LINE INPUT #1, thisline$
  FOR char = 1 TO 10
   value = ASC(MID$(thisline$, char, 1))
   IF value < 58 THEN
    value = value - 47
   END IF

   IF value > 64 THEN
    value = value - 54
   END IF

   thismap$(lines, char) = CHR$(value)
  NEXT char
 NEXT lines
CLOSE #1

' Load data file for this map
OPEN "maps\" + mapfile$ + ".dat" FOR INPUT AS #1
       
        LINE INPUT #1, imgfile$

        LINE INPUT #1, mapup$
        LINE INPUT #1, mapright$
        LINE INPUT #1, mapdown$
        LINE INPUT #1, mapleft$
CLOSE #1

' We're going to GET some "cell" graphics

IF imgfile$ <> "noupdate" THEN
 ' Load the raw image, which GIMP supports
 DEF SEG = &HA000
 BLOAD imgfile$, 0

 ' Get 36 sprites
 i = 0
 FOR y = 1 TO 6
  FOR x = 1 TO 6
   i = i + 1
   GET (x * 24 - 24, y * 24 - 24)-(x * 24, y * 24), cells(1 + (i * cellsize) - cellsize)
  NEXT x
 NEXT y
 CLS
END IF

' Draw the game background
 DEF SEG = &HA000
 BLOAD "bg.raw", 0


' Draw the current map
FOR y = 1 TO 8
 FOR x = 1 TO 10
  PUT (x + (x * 22) - 23, y + (y * 22) - 23), cells(1 + (ASC(thismap$(y, x)) * cellsize - cellsize)), PSET
 NEXT x
NEXT y

END SUB

SUB initgame

' Load the PAL file from the raw image, generated by GIMP

 OPEN "mainchar.pal" FOR BINARY AS #1
 dcolor = 0
 rawbytes$ = "   "

 FOR i = 1 TO 765 STEP 3
 GET #1, i, rawbytes$

 r = ASC(MID$(rawbytes$, 1, 1))
 g = ASC(MID$(rawbytes$, 2, 1))
 b = ASC(MID$(rawbytes$, 3, 1))

' IF dcolor > 1 AND dcolor < 255 THEN
 OUT &H3C8, dcolor

 OUT &H3C9, r
 OUT &H3C9, g
 OUT &H3C9, b
' END IF

 dcolor = dcolor + 1

 NEXT i


 CLOSE #1


END SUB

SUB mainchar (imgfile$)

' Load up the main character sprites
DEF SEG = &HA000
BLOAD imgfile$, 0

' Get them
 ' Get 36 sprites
 i = 0
 FOR y = 1 TO 4
  FOR x = 1 TO 6
   i = i + 1
   GET (x * 24 - 23, y * 24 - 24)-(x * 24, y * 24), mcsprites(1 + (i * cellsize) - cellsize)
  NEXT x
 NEXT y

 CLS


END SUB

