' Convert BMP file to RAW & PAL files

TYPE BMPHeaderType
        id AS STRING * 2
        size AS LONG
        rr1 AS INTEGER
        rr2 AS INTEGER
        offset AS LONG
        horz AS LONG
        wid AS LONG
        hei AS LONG
        planes AS INTEGER
        bpp AS INTEGER
        pakbyte AS LONG
        imagebytes AS LONG
        xres AS LONG
        yres AS LONG
        colch AS LONG
        ic AS LONG
        pal AS STRING * 1024
END TYPE

SCREEN 13
CLS

' Load BMP with palette

DIM BmpHeader AS BMPHeaderType

LINE INPUT ; "BMP File Name (no .BMP):"; bmpfile$
IF bmpfile$ = "" THEN END

OPEN bmpfile$ + ".bmp" FOR BINARY AS #1

GET #1, , BmpHeader

' Process palette
a$ = BmpHeader.pal
           
' Save to a file
OPEN bmpfile$ + ".pal" FOR OUTPUT AS #2

FOR i% = 1 TO 1024 STEP 4
        OUT &H3C8, dcolor

        b% = ASC(MID$(a$, i%, 1)) \ 4
        g% = ASC(MID$(a$, i% + 1, 1)) \ 4
        r% = ASC(MID$(a$, i% + 2, 1)) \ 4

        PRINT #2, CHR$(r%); CHR$(g%); CHR$(b%);

        OUT &H3C9, r%
        OUT &H3C9, g%
        OUT &H3C9, b%
       
        dcolor = dcolor + 1
NEXT
CLOSE #2

LOCATE 10, 10
COLOR 0
PRINT "Loading..."

LOCATE 9, 10
COLOR 100
PRINT "Loading..."

LOCATE 11, 10
COLOR 255
PRINT "Loading..."

' Load pixels

Pixel$ = SPACE$(BmpHeader.wid)
iHeight% = BmpHeader.hei - 1
iWidth% = BmpHeader.wid - 1

FOR y% = iHeight% TO 0 STEP -1
        GET #1, , Pixel$
        FOR x% = 0 TO iWidth%
                PSET (x%, y%), ASC(MID$(Pixel$, x% + 1, 1))
        NEXT x%
NEXT y%
CLOSE #1

' Bsave
DEF SEG = &HA000
BSAVE bmpfile$ + ".raw", 0, 64000



