/* compile with :
   gcc -O -o cdspd cdspd.c
*/

/* 
From: bchafy@ccs.neu.edu ("Bryan E. Chafy")
Subject: set speed of the cdrom? - simple program
Date: 1999/01/20
Newsgroups: mailing.comp.cdwrite

cdspd.c (speed_limit.c)
simple cdrom speed limiter
My cdrom drive sounds like a Valujet DC-9 at max speed.  So I built this
program for linux.

Note that not all speeds sent to cdrom device mean the drive will accept it.
For example, my memorex cdrom drive accepts 0, 32, and  8 - 4 (where 0 is
the maximum default speed).  Also, my
drive resets to the default speed when the cd-rom disc is ejected.  YMMV

Also note:  If your kernel was created before July 17, 1998, you might
have trouble:
2.13  July 17, 1998 -- Erik Andersen <andersee@debian.org>
  -- Fixed a bug in CDROM_SELECT_SPEED where you couldn't lower the speed
     of the drive.  Thanks to Tobias Ringstr|m <tori@prosolvia.se> for pointing
     this out and providing a simple fix.

Tested with linux 2.1.128

Joerg Schilling made a comment about the program not working with 
Standard CD-ROMs.  This is evidently not true.  There is some support
for MMC drives in later kernels for the CDROM_SELECT_SPEED ioctl.
*/

#include <sys/types.h>
#include <linux/cdrom.h>
#include <sys/ioctl.h>
#include <stdio.h>

void usage()
{
printf ("\nUsage:\n");
printf ("cdspd [-d device] speed\n");
printf ("where speed is the positive multiple to set the cd-rom speed\n\n");
exit(0);
}

main(int argc, char *argv[])
{
int bcdfp;
int i;
int speed;

if (argc < 2)
  usage();

if (argc == 2)
{
speed = atoi(argv[1]);
   if (speed < 0)
     usage();
bcdfp = open ("/dev/cdrom",0);
}
else
  if ((!strcmp("-d",argv[1])) && argc == 4)
   {
   speed = atoi(argv[3]);
   if (speed < 0)
     usage();
   bcdfp = open (argv[2],0);
   }
  else
   usage();

   if (bcdfp < 0) {
      perror ("CD-ROM device");
      return (-1);
   }

i = ioctl(bcdfp, CDROM_SELECT_SPEED, speed);

if (i == -1)
  {
      perror ("CD-ROM device");
      close(bcdfp);
      return (-1);
   }

printf("Command sent successfully\n");

close(bcdfp);
}

