// Generic menuShim for IE to help with 'windowed' elements

function initMenuShim(){
 if (document.getElementById("nav")){ // does #nav element exist?
  var sfEls = document.getElementById("nav").getElementsByTagName("LI");
  for (var i=0; i<sfEls.length; i++){
   sfEls[i].attachEvent("onmouseover",useMenuShim);
   sfEls[i].attachEvent("onmouseout",dropMenuShim);
  }
  createMenuShim();
 }
}

if (document.all && window.attachEvent){ // assume IE
 window.attachEvent("onload", initMenuShim); // set onload event
}

function createMenuShim(){ // create the hidden iframe if needed
 if (!document.getElementById("menuShim")){ // does 'menuShim' exist already?
  // 1) Let's prep the styles of the sub-nav UL's
  var nav = document.getElementById("nav");
  var navULs = nav.getElementsByTagName("UL");
  var navULsL = navULs.length; // cache
  for (var i=0;i<navULsL;i++){
   navULs[i].style.zIndex = "1"; // set z-index to show above iframe
  }
  // 2) Let's create the menu shim
  var menuShim = document.createElement("iframe");
  menuShim.src = "javascript:false"; // dummy URL
  menuShim.style.position = "absolute";
  menuShim.style.zIndex = "0";
  menuShim.style.display = "none";
  menuShim.id = "menuShim";
  var dBody = document.getElementsByTagName('body').item(0);
  dBody.appendChild(menuShim); // append iframe to body node tree
  isMenuShimCreated = true; // set flag to true
 }
}

function useMenuShim(e){
 var eSrc = getTargetElement(window.event);
 while(eSrc.parentNode.id != "nav"){ // get top <LI> in node tree under UL#nav
  eSrc = eSrc.parentNode;
 }
 var menuUL = eSrc.getElementsByTagName("UL").item(0); // get subnav UL
 var menuShim = document.getElementById("menuShim"); // conform menu shim to UL dimensions
 menuShim.style.top = menuUL.offsetTop;
 menuShim.style.left = menuUL.offsetLeft;
 menuShim.style.width = menuUL.offsetWidth;
 menuShim.style.height = menuUL.offsetHeight;
 menuShim.style.display = "block";
}

function dropMenuShim(){
 document.getElementById("menuShim").style.display = "none";
}

function getTargetElement(evt){
 var elem;
 if (evt.target) {
  elem = (evt.target.nodeType == 3) ? evt.target.parentNode : evt.target;
 } else {
  elem = evt.srcElement;
 }
 return elem;
}