<?php
/**********************************************************************************
WIKINDX: Bibliographic Management system.
Copyright (C)

This program is free software; you can redistribute it and/or modify it under the terms
of the GNU General Public License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program;
if not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

The WIKINDX Team 2004
sirfragalot@users.sourceforge.net
**********************************************************************************/
/*****
* MESSAGES_en class (English)
* NOTE TO TRANSLATORS:  1/  '###' appearing anywhere in an array value will be replaced by text supplied by the core WIKINDX code.
*				Do not remove it and do not put space around it.
*			2/  Do not change the key (the first part) of an array element.
*			3/  Ensure that each array element value is enclosed in double quotes "..." and is followed by a comma "...",
*			4/  Both the class name and the constructor name should be changed to match the (case-sensitive) name of 
*				the folder your language files are in.  For example, if you are supplying a Klingon translation and 
*				your languages/ folder is languages/kn/, the class and constructor name for the file SUCCESS.php 
*				must both be SUCCESS_kn.
*****/
class MESSAGES_en
{
// Constructor
	function MESSAGES_en()
	{
	}
// English messages
	function loadArrays()
	{
		return array(
		"heading" => array(
				"configure"	=>	"Configure Wikindx",
				"logon"		=>	"Logon",
// MG - removed for v2.2
//				"convert"	=>	"Convert v1 database resources to v2",
				"list"		=>	"List Resources",
				"select"	=>	"Select Resources",
				"search"	=>	"Search Resources",
				"help"		=>	"WIKINDX Help",
				"helpBibtex"	=>	"Importing BibTeX bibliographies (.bib files)",
                                "aboutWikindx"	=>	"About Wikindx",
				"preferences"	=>	"User Preferences",
				"resources"	=>	"WIKINDX Resources",
				"files"		=>	"Export Files",
				"edit"		=>	"Edit WIKINDX Resources###",
				"admin"		=>	"Administer WIKINDX",
				"help"		=>	"WIKINDX Help",
				"exportRtf"	=>	"Export RTF",
				"exportHtml"	=>	"Export HTML",
				"exportBibtex"	=>	"Export BibTeX",
				"category"	=>	"Administer Categories###",
				"newResource"	=>	"New Resource",
				"editResource"	=>	"Edit Resource",
				"notes"		=>	"Resource Notes",
				"quotes"	=>	"Resource Quotes",
				"paraphrases"	=>	"Resource Paraphrases",
// 'Musings' are thoughts about a resource
				"musings"	=>	"Resource Musings",
				"abstract"	=>	"Resource Abstract",
				"bibtexImport"	=>	"Import BibTeX Bibliography",
				"delete"	=>	"Delete Resource",
				"text"		=>	"Display Text",
				"user"		=>	"Administer Users###",
// Prospective user wishing to register for a username/password in a multi-user WIKINDX
				"register"	=>	"Register",
// In a multi-user WIKINDX, settings for a user's bibliographies and personal details
				"myWikindx"	=>	"My Wikindx###",
				"bibs"		=>	"Bibliographies",
				"exportRis"	=>	"Export RIS",
				"news"		=>	"News###",
				"citations"	=>	"Resource citation",
				"exportEndnote"	=>	"Export Endnote",
				"styles"		=>	"Styles###",
				"helpStyles"	=>	"Bibliographic Style Creation and Editing",
				"endnoteImport"	=>	"Import Endnote XML Bibliography",
// The admin can create custom database fields for resources
				"field"		=>	"Administer Custom Database Fields###",
				"userEditField"	=>	"Resource Custom Field",
// Word processor articles/papers
				"wp"		=>		"Papers",
				"newWp"		=>		"New Paper",
// For file attachments
				"attach"	=>		"File Attachments###",
				"addToBib"		=>	"Add selected to bibliography",
				"addToCategory"		=>	"Add selected to categories",
				"addToKeyword"		=>	"Add selected to keywords",
				"convertResourceType"	=>	"Convert Resource Type",
				"bookmark"	=>	"Bookmarks",
			),
		"authorize" => array(
				"writeLogon"	=>	"Enter your username and password to logon to the system",
				"superLogon"	=>	"Enter your superadmin username and password to logon",
				"readOnly"	=>	"READ-ONLY access",
// This is only for an upgrade to v2.1
//				"v2.1Config"	=>	"WIKINDX v2.1 requires an initial administrator authorization the 
//								first time it is run",
			),
// WIKINDX administrator/default configuration
		"config" => array(
				"start"		=>	"Before being able to use WIKINDX, you must configure it",
// This WIKINDX's title
				"title"		=>	"Title displayed on each page",
				"email"		=>	"Contact email",
				"description"	=>	"Front Page Description",
				"superUsername"	=>	"Superadmin username",
				"superPassword"	=>	"Superadmin password",
				"deleteSeconds"	=>	"Seconds before export file is marked for deletion",
				"paging"	=>	"Default no. resources to display/screen (paging)",
				"maxPaging"	=>	"Default no. paging links to display/screen",
				"language"	=>	"Language",
				"template"	=>	"Template",
				"style"		=>	"Bibliographic style",
				"stringLimit"	=>	"Limit no. characters in select box text",
				"userRegistration"	=>	"Allow user registration",
				"multiUser"	=>	"Multi user mode",
				"notify"	=>	"Allow email notification",
// MG -- Added for v2.3.5
				"imgWidthLimit"	=>	"Max. pixel width for BBCode images",
				"imgHeightLimit"	=>	"Max. pixel height for BBCode images",
// v3.0 - File attachments (uploading) to resources
				"fileAttach"	=>	"Allow file attachments",
				"fileViewLoggedOnOnly" => "Allow only logged on users to view file attachments",
				"maxPaste"	=>	"Max. number of bibTeX entries a user can paste",
			),
		"viewResource" => array(
				"url"		=>	"Further information may be found at:",
				"notes"		=>	"Notes",
				"quotes"	=>	"Quotes",
				"paraphrases"	=>	"Paraphrases",
				"musings"	=>	"Musings",
// When viewing a resource, display a link to view an attached file
				"fileAttached"	=>	"Attached file:",
			),
		"resources" => array(
// paging system (number of resources to display/browser page.
				"pagingStart"	=>	"Start",
				"pagingEnd"	=>	"End",
				"noResult"	=>	"No resources found matching your selection",
				"noMusing"	=>	"There are no musings in the database",
				"noParaphrase"	=>	"There are no paraphrases in the database",
				"noQuote"	=>	"There are no quotes in the database",
				"new"		=>	"The minimum required are the type of resource, title of the 
							resource and the category(s) the resource belongs to. Do not put 
							any punctuation at the end of text fields: WIKINDX 
							will do this automatically depending on the bibliographic style. 
							You are responsible for correct capitalisation of titles and 
							proper names.",
// book, article in book, web resource, thesis etc.
				"type"		=>	"Select the type of new resource",
				"title"		=>	"Title",
				"subtitle"	=>	"Subtitle",
				"bookTitle"	=>	"Title of book",
// 'Contributors' are creators, authors, editors, translators etc.
				"numContributors" =>	"Select the number of contributors to this resource",
				"numContributorsEdit" => "Select the number of contributors to this resource. Shown are the 
							current number; select a higher number to add more",
				"firstname"	=>	"Firstname",
				"initials"	=>	"Initials",
				"surname"	=>	"Surname",
				"creator"	=>	"Creator###",
				"editor"	=>	"Editor###",
				"reviser"	=>	"Reviser###",
				"translator"	=>	"Translator###",
				"producer"	=>	"Producer###",
				"seriesTitle"	=>	"Series title",
				"seriesNumber"	=>	"Series number",
// For a publisher select box
				"publisher"	=>	"Publisher",
// Name and location for the publisher text entry boxes
				"publisherName"	=>	"Name",
				"publisherLocation" =>	"Location",
				"publicationYear" =>	"Publication year",
				"endPublicationYear" =>	"Publication year",
				"reprintYear"	=>	"Reprint year",
				"edition"	=>	"Edition",
				"volume"	=>	"Volume",
				"series"	=>	"Series",
				"numberOfVolumes" =>	"Number of volumes in set",
// Legal case reporter volume
				"reporterVolumeNumber" =>	"Reporter volume number",
				"bookVolumeNumber" =>	"This volume number",
				"volumeYear"	=>	"Volume set publication year",
				"categories"	=>	"Categories",
				"keywords"	=>	"Keywords",
				"url"		=>	"URL",
				"urlForm"	=>	"http://",
// Date of accessing a web-based resource
				"dateAccessed"	=>	"Date accessed",
				"day"		=>	"Day",
				"month"		=>	"Month",
				"endDay"	=>	"Day",
				"endMonth"	=>	"Month",
				"year"		=>	"Year",
				"pages"		=>	"Start and end pages",
				"pageStart"	=>	"Start",
				"pageEnd"	=>	"End",
				"note"		=>	"Note",
				"quote"		=>	"Quote",
				"paraphrase"	=>	"Paraphrase",
				"musing"	=>	"Musing",
				"resource"	=>	"Resource",
				"page"		=>	"Page",
				"comment"	=>	"Comment",
				"creatorEtAl"	=>	"More unnamed creators",
				"editorEtAl"	=>	"More unnamed editors",
				"reviserEtAl"	=>	"More unnamed revisers",
				"translatorEtAl" =>	"More unnamed translators",
				"producerEtAl"	=>	"More unnamed producers",
				"journalVolumeNumber" => "Journal volume number",
				"journalIssueNumber" => "Journal issue number",
				"journal"	=>	"Journal",
				"collection"	=>	"Collection",
// Abbreviated titles for journals etc.
				"collectionShort"	=>	"Short title",
				"newspaper"	=>	"Newspaper",
				"collectionTitle"	=>	"Title",
				"section"	=>	"Section",
				"conference"	=>	"Conference",
				"conferenceOrganiser"	=>	"Conference organiser",
				"conferenceLocation"	=>	"Conference location",
				"conferenceDate"	=>	"Conference date",
				"thesis"	=>	"Thesis/Dissertation",
				"thesisType"	=>	"Degree level",
				"thesisLabel"	=>	"Thesis label",
				"institution"	=>	"Institution",
				"thesisYear"	=>	"Year of awarding",
				"abstract"	=>	"Abstract",
				"thesisAbstract" =>	"If the thesis has had an abstract of it published in a 
							journal, enter those details below",
// The ID number of a resource as stored in the database
				"id"		=>	"Resource ID",
				"confirm"	=>	"Please confirm you wish to proceed",
// International Standard Book Number
				"isbn"		=>	"ID no. (ISBN etc.)",
				"keyword"	=>	"Keyword",
// Prefix for surname - e.g. de Witt, della Croce, von Neumann
				"prefix"	=>	"Prefix",
				"noUsers"	=>	"There are no users in the database",
// TV or radio channel
				"channel"	=>	"Broadcast Channel",
				"broadcastDate"	=>	"Broadcast Date",
// Film distributor/studio
				"distributor"	=>	"Distributor",
				"country"	=>	"Country",
				"runningTime"	=>	"Running time",
				"hours"		=>	"Hours",
				"minutes"	=>	"Minutes",
// Music
				"recordLabel"	=>	"Record Label",
				"album"		=>	"Album",
// Medium = 'oil on canvas', 'marble sculpture', 'multimedia show' etc. usually for art works
				"medium"	=>	"Medium",
// For legal cases
				"reporter"	=>	"Reporter",
// Date legal case decided
				"dateDecided"	=>	"Date Case Decided",
				"caseYear" 	=>	"Year",
				"court"		=>	"Court",
				"reporterVolume"	=>	"Reporter Volume",
// Parliamentary bills/laws
				"bill"		=>	"Bill",
				"code"		=>	"Code",
				"legislativeBody"	=>	"Legislative Body",
				"session"	=>	"Session",
				"codeVolume"	=>	"Code Volume",
				"billNumber"	=>	"Bill Number",
				"sessionYear"	=>	"Session Year",
// Legal Rulings/Regulations
				"ruleType"	=>	"Type of Ruling",
				"ruleNumber"	=>	"Rule Number",
				"codeEditionDate" =>	"Date of Code Edition",
// Reports and documentation
				"department"	=>	"Department",
// report issue number
				"issueNumber"	=>	"Issue Number",
				"typeOfReport"	=>	"Type of Report",
				"city"		=>	"City",
				"reportDate"	=>	"Date of Report",
// Government/legal hearings
				"committee"	=>	"Committee",
				"documentNumber"	=>	"Document Number",
				"hearingDate"	=>	"Date of Hearing",
				"magazine"	=>	"Magazine",
				"hearing"	=>	"Hearing",
// Type of article (interview, review, advert etc.) in magazines
				"typeOfArticle"	=>	"Type of Article",
// Manuscripts
				"typeOfManuscript"	=>	"Type of Manuscript",
				"manuscriptNumber"	=>	"Manuscript Number",
				"manuscript"	=>	"Manuscript Collection",
// Maps
				"map"		=>	"Map",
				"typeOfMap"	=>	"Type of Map",
// Charts/images
				"nameOfFile"	=>	"Name of File",
// sofware used to display image
				"imageProgram"	=>	"Image Program",
				"imageSize"	=>	"Image Size",
				"imageType"	=>	"Image Type",
				"version"	=>	"Version",
// Legal Statutes
				"publicLawNumber"	=>	"Public Law Number",
				"codeNumber"	=>	"Code Number",
				"dateEnacted"	=>	"Date Enacted",
// Patents
				"publishedSource"	=>	"Published Source",
				"patentVersionNumber"	=>	"Patent Version Number",
				"patentNumber"	=>	"Patent Number",
				"applicationNumber"	=>	"Application Number",
				"patentType"	=>	"Patent Type",
				"intPatentNumber"	=>	"International Patent Number",
				"intPatentClassification"	=>	"International Patent Classification",
				"intPatentTitle"	=>	"International Patent Title",
				"legalStatus"	=>	"Legal Status",
				"issueDate"	=>	"Issuing Date",
// Who is the patent assigned to?
				"assignee"	=>	"Assignee",
// Personal Communication
				"typeOfCommunication"	=>	"Type of Communication",
// Unpublished work
				"typeOfWork"		=>	"Type of Work",
// Computer program
				"version"		=>	"Version",
				"typeOfSoftware"	=>	"Type of Software",
				"number"		=>	"Number",
// Other resources citing this resource where '###' is the name of the user bibliography or 'WIKINDX Master Bibliography'
				"citedResources"	=>	"Resources citing this (Bibliography:###)",
// Other resources with at least one of the same keywords as this resource where '###' is the name of the user 
// bibliography or 'WIKINDX Master Bibliography'
				"keywordResources"	=>	"Resources with at least one of these keywords (Bibliography:###)",
// For file attachments/uploading to resources
				"fileAttach"		=>	"Attach a file to this resource",
				"fileName"		=>	"Filename",
// This continues on from the above two...
				"fileRemove"		=>	"or remove existing attachment (###)",
// hyperlinks for displaying next resource and previous resource
				"next"			=>	"next resource",
				"previous"		=>	"previous resource",
// Paragraph, section and chapter in resources
				"paragraph"		=>	"Paragraph",
				"section"		=>	"Section",
				"chapter"		=>	"Chapter",
				"noAttachments"	=>	"There are no attachments for this resource",
				"deleteConfirmAttach"		=>	"Delete attachment(s)###",
// Navigation links when editing a resource to jump directly to editing pages
				"jump"		=>	"Jump to:",
				"jumpNumCreators"	=>	"Number of creators",
				"jumpCreators"	=>	"Creators",
				"jumpDetails"	=>	"Resource details",
				"jumpMisc"	=>	"Miscellaneous details",
// For a range of dates
				"dateStart"	=>	"Start",
				"dateEnd"	=>	"End",
// For public/private comments and musings (first value is above next two which are in a select box)
				"commentPrivate"	=>	"Comment is",
				"musingPrivate"	=>	"Musing is",
				"public"			=>	"Public",
				"private"			=>	"Private",
// For adding resource lists or selected resources in the list to categories, keywords or user bibliographies
				"addSelected"	=>	"Add selected to",
				"addToBib"		=>	"User bibliography",
				"addToCategory"	=>	"Categories",
				"addToKeyword"	=>	"Keywords",
				"addAll"		=>	"Add all in list",
				"addToExistingKeyword"	=>	"You may either append the keywords above to an existing set for each resource or replace the existing set with the keywords above.  Replace existing keyword set?",
				"addToExistingCategory"	=>	"You may either append the categories above to an existing set for each resource or replace the existing set with the categories above.  Replace existing category set?",
// For converting resource types
				"convertType"	=>	"Convert the resource type",
// When editing a resource, some pages will have a checkbox to write the new details immediately rather than going to the next edit page
				"finish"		=>	"Finish editing",
			),
// Hint messages
		"hint" => array(
// Paging system e.g. 'Displaying 24-32 of 567 resource'
				"pagingInfo"	=>	"Displaying###",
				"pagingLimit"	=>	"(-1 is unlimited)",
				"multiples"	=>	"(Multiples can be chosen)",
				"creators"	=>	"('Creators' includes authors, directors, artists, composers...)",
				"resourceName"	=>	"A selection from the pre-existing names will be overridden by a 
							surname in the input boxes",
				"publisherName"	=>	"A selection from the pre-existing names will be overridden 
							by text in the box below",
				"bookTitle"	=>	"A selection from the pre-existing books will be overridden 
							by text in the 'title' box",
				"integer"	=>	"###must be a numeral and an integer",
				"volumeYear"	=>	"(e.g. 2001 or 1999-2003)",
				"year"		=>	"(e.g. 1999)",
				"publicationYear" =>	"Year of original publication",
				"categories"	=>	"Each resource must belong to at least one category",
				"keywords"	=>	"You can select keywords relating to the### from the 
							list and/or enter them as a comma-separated list",
				"keywordList"	=>	"(comma-separated list)",
				"url"		=>	"(http://)",
				"urlNote" 	=>	"If there is further information about this resource on the 
							internet, you may enter a URL here",
// Arabic (2, 34, 57) or Roman (xii, vi, LV)
				"pages"		=>	"If the article has page numbers, enter either arabic or 
							roman numerals",
				"collectionTitle"	=>	"A selection from the pre-existing titles will be overridden 
							by text in the 'title' box",
				"quote"		=>	"(To allow for free-form quoting such as: 'it is claimed 
							that WIKINDX is \"amongst the best\" resources available', 
							you are expected to distinguish the actual quote from 
							surrounding text yourself)",
				"format"	=>	"(You may use BBcode)",
				"capitals"	=>	"(Braces e.g. {BibTeX Specs.} maintain the case  
							whatever the requirements of the bibliographic style)",
				"userRegistration" =>	"Check php.ini for a valid mail server",
				"registerEmail"	=>	"An email will be sent with further instructions",
				"deleteFrom"	=>	"This only removes the reference to the resource from your bibliography",
				"addedBy"	=>	"Added by###",
				"editedBy"	=>	"Last edited by###",
				"styleShortName"	=>	"(No spaces)",
				"caseSensitive"	=>	"(Fields are case-sensitive)",
				"integer"	=>	"Integer",
// Power search - BOOLEAN searching - don't translate 'AND, 'NOT' and 'OR'.  These boolean hints follow on from 
// each other forming one complete hint.
				"boolean"	=>	"BOOLEAN string",
				"boolean1"	=>	"You may use BOOLEAN logic and double quotes to group words into single search terms.  e.g.",
// DO NOT TRANSLATE THIS NEXT EXAMPLE!
				"boolean2"	=>	"\"NOT endnote NOT microsoft AND \"Wikindx Bibliographic Management System\" OR Bibliophile",
// CONTINUE TRANSLATION
// The \" must remain as is
				"boolean3"	=>	"in the 'Title' field, will be interpreted as:",
				"boolean4"	=>	"\"return resources whose 'Title' field contains either the word 'Bibliophile' or the phrase 'Wikindx Bibliographic Management System' and which contains neither the word 'endnote' nor the word 'microsoft'\".",
				"boolean5"	=>	"A single space not enclosed in double quotes is equivalent to 'AND'. You may combine as many fields as you like for more complex searches. Searches are case-insensitive and you may search for either whole or partial word/phrase matching. If you wish to search on non-alphanumeric characters, you should wrap them in double quotes otherwise unexpected results may occur.",
				"refineSearch"	=>	"Power Search remembers your last search so you can refine a search by returning to this page."
			),
// Menu subsystem.  The trick here is to use short terms that don't cause problems with overflowing 
// the CSS drop-down boxes - some browsers may happily handle this, others won't.
// Up to 15-16 characters (depending on character width) is a good guide - but check!
		"menu" => array(
                 	       'home'		=>	"Home",
                                'prefs'		=>	"Preferences",
                                'file'		=>	"File",
                                'importBibtex'		=>	"Import BibTeX",
                                'exportBibtex'		=>	"Export BibTeX",
                                'rtfexp'		=>	"Export RTF",
                                'show'		=>	"Show Files",
                                'edit'		=>	"Edit",
                                'res'		=>	"Resources",
								"text"		=>	"Text",
                                'creator'	=>	"Creator",
                                'collection'	=>	"Collection",
                                'publisher'	=>	"Publisher",
                                'admin'		=>	"Admin",
                                'logon'		=>	"Logon",
                                'logout'		=>	"Logout",
                                'conf'		=>	"Configure",
// MG - removed for v2.2
 //                               'convert'	=>	"Convert DB",
				'category'	=>	"Categories",
                                'help'		=>	"Help",
                                'wkxhelp'	=>	"Wikindx Help",
				'importhelp'	=>	"Import Help",
				'confighelp'	=>	"Config Help",
                                'about'		=>	"About Wikindx",
                                'new'		=>	"New",
                                'select'		=>	"Select",
                                'list'		=>	"List",
                                'search'		=>	"Quick Search",
                                'musing'		=>	"Musing",
				'userLogon'	=>	"User Logon",
				'lastMulti'	=>	"Last Multi View",
				'lastSolo'	=>	"Last Solo View",
				"delete"	=>	"Delete Resource",
				"allMusings"	=>	"Musings",
				"randomMusings" =>	"Random Musing",
				"allParaphrases"	=>	"Paraphrases",
				"randomParaphrases" =>	"Random Paraphrase",
				"allQuotes"	=>	"Quotes",
				"randomQuotes" =>	"Random Quote",
				"keyword"	=>	"Keyword",
				"user"		=>	"Users",
				"register"	=>	"Register",
				"myWikindx"	=>	"My Wikindx",
				"bibs"		=>	"Bibliographies",
				"risExp"	=>	"Export RIS",
				"htmlExp"	=>	"Export HTML",
// For news items
				"news"		=>	"News",
				"endnoteExp"	=>	"Export Endnote",
				"styles"	=>	"Styles",
				"stylehelp"	=>	"Styles Help",
                                'importEndnote'		=>	"Import Endnote",
// The admin can create custom database fields for resources
				"customField"	=>	"Custom Fields",
// Ordinary user can paste a bibtex file into a textarea for importing
                                'pasteBibtex'	=>	"Paste BibTeX",
// Advanced searching
				'powerSearch'	=>	"Power Search",
// Word processor articles/papers
				"wp"		=>		"Papers",
				"newWp"		=>		"New Paper",
// User bookmarks
				"bookmark"	=>		"Bookmarks",
				"bookmarkAdd"	=>	"Add bookmark",
			),
// Miscellaneous items that don't fit anywhere else
		"misc" => array(
// <a name="..."> links in WIKINDX help files
				'top'		=>	"Top",
				'noResources'	=>	"There are no resources in the database",
				'noCreators'	=>	"There are no creators in the database",
				'noCollections'	=>	"There are no collections in the database",
				'noPublishers'	=>	"There are no publishers in the database",
// In select boxes - when it is not necessary to choose an existing selection.  WIKINDX will skip over this one. 
// Could be '---'
				'ignore'	=>	"IGNORE",
// This next one is required in BIBTEXPARSE - whatever the language, NEITHER THE KEY NOR THE VALUE SHOULD BE CHANGED!
// Leave as is!
// Leave as is!
// Leave as is!
				'IGNORE'	=>	"ignore",
// continue....
				"edited"	=>	"edited",
				"added"		=>	"added",
				"deleted"	=>	"deleted",
				"add"		=>	"add",
// 'Tag' - when importing bibtex resources, the administrator can give a label to each import which makes it possible to 
// later delete in one go resources that were imported under this label.
				"tag"		=>	"Delete resources by import tag",
				"noKeywords"	=>	"There are no keywords in the database",
// Used in SUCCESS.php when a user chooses a user bibliography to browse.  The message is "Successfully set Bibliography".
				"set"		=>	"set",
// When importing a bibliography (e.g. bibTeX), the admin has the choice of storing fields that wikindx does not recognise.
// Later, when exporting a bibliography, the user will have the choice of merging these unrecognised fields into the wikindx 
// export. Additionally, any stored citation keys from the original import can be used in preference to a WIKINDX-generated 
// one.
				"mergeStored"	=>	"If any fields that WIKINDX does not recognise are stored from an original import, merge these fields into this export:",
				"useOriginalCitation"	=>	"Use the citation keys from the original import (where available) in preference to WIKINDX generated keys:",
// Ask for confirmation deleting a large number of resources
				"confirmDelete"	=>	"Delete### resources?",
// Advice on what to do when editing a publisher name and the new name already exists in the database.
				"publisherExists"	=>	"If you proceed, this edited publisher will be deleted and all references in the database to it will be replaced by references to the pre-existing publisher.",
// Advice on what to do when editing a collection name and the new name already exists in the database.
				"collectionExists"	=>	"If you proceed, this edited collection will be deleted and all references in the database to it will be replaced by references to the pre-existing collection.",
// Advice on what to do when editing a keyword name and the new name already exists in the database.
				"keywordExists"	=>	"If you proceed, this edited keyword will be deleted and all references in the database to it will be replaced by references to the pre-existing keyword.",
// User bookmarks
				"bookmark"	=>	"You may store up to 10 bookmarks for returning to a single resource view.",
				"bookmarkDelete"	=>	"As you already have 10 bookmarks, you must choose one to be replaced by this new addition",
				"bookmarkName"	=>	"Enter a short name for your bookmark",
			),
// Plain listing of resources
		"list" => array(
				'listBy'	=>	"List all by",
				'creator'	=>	"First Creator",
				'title'		=>	"Title",
				'publisher'	=>	"Publisher",
				'year'		=>	"Publication Year",
				'timestamp'	=>	"Timestamp",
			),
// Select resources by...
		"select" => array(
				'selectBy'	=>	"Select by###",
				'type'		=>	"Type",
				"category"	=>	"Category",
				"tag"		=>	"Import Tag",
				"keyword"	=>	"Keyword",
				'publisher'	=>	"Publisher",
				'creator'	=>	"Creator",
				'collection'	=>	"Collection",
				'notInUserBib'	=>	"NOT in user bibliography",
			),
// Search the database
		"search" => array(
				'search'	=>	"Search###",
				'member'	=>	"Members###",
// Database field such as 'title', 'abstract', 'quotes' etc.
				'field'		=>	"on Field",
// Type = book, journal article, thesis etc.
				'type'		=>	"of Type",
				"category"	=>	"of Category",
				"keyword"	=>	"of Keyword",
				"title"		=>	"Title",
				"note"		=>	"Notes",
				"abstract"	=>	"Abstract",
				"quote"		=>	"Quote",
				"paraphrase"	=>	"Paraphrase",
				"musing"	=>	"Musing",
				"exact"		=>	"Exact phrase",
				"method"	=>	"Method",
				"word"		=>	"Search word(s)",
// Match part of a word or search term must equal whole word?
				"partial"	=>	"Partial word match",
			),
// Mapping WKX_resource.type to description.
		"resourceType" => array(
				'book'			=>	"Book",
				'book_article'		=>	"Book Chapter",
				'web_article'		=>	"Internet",
				'journal_article'	=>	"Journal Article",
				'newspaper_article'	=>	"Newspaper Article",
				'thesis'		=>	"Thesis/Dissertation",
				'proceedings_article'	=>	"Proceedings Article",
// TV or Radio broadcast
				'broadcast'		=>	'Broadcast',
				'film'			=>	"Film",
// Legal Ruling or Regulation
				'legal_ruling'		=>	"Legal Rule/Regulation",
// Computer software
				"software"	=>	"Software",
// Art etc.
				"artwork"	=>	"Artwork",
// Audiovisual material
				"audiovisual"	=>	"Audiovisual",
// Legal cases
				"case"		=>	"Legal Case",
// Parliamentary bill (law)
				"bill"		=>	"Bill",
// Classical (historical) work
				"classical"	=>	"Classical Work",
				"conference_paper"	=>	"Conference Paper",
// Reports or documentation
				"report"	=>	"Report/Documentation",
// Government report or documentation
				"government_report"	=>	"Government Report/Documentation",
// Legal/Government Hearing
				"hearing"	=>	"Hearing",
// Online databases
				"database"	=>	"Online Database",
				"magazine_article"	=>	"Magazine Article",
				"manuscript"	=>	"Manuscript",
// Maps
				"map"		=>	"Map",
// Charts/images
				"chart"		=>	"Chart/Image",
// Statute
				"statute"	=>	"Statute",
// Patents
				"patent"	=>	"Patent",
// Personal Communication
				"personal"	=>	"Personal Communication",
// Unpublished work
				"unpublished"	=>	"Unpublished Work",
// Conference proceedings (complete set)
				"proceedings"	=>	"Proceedings",
// Music
				"music_album"	=>	"Recorded Music Album",
				"music_track"	=>	"Recorded Music Track",
				"music_score"	=>	"Music Score",
// For anything else that does not fit into the above categories.
				'miscellaneous'		=>	"Miscellaneous",
// Generic resource types used when creating bibliographic styles.
				"genericBook"		=>	"Generic book-type",
				"genericArticle"	=>	"Generic article-type",
				"genericMisc"		=>	"Generic miscellaneous",
			),
// For RTF and BibTeX export
		"file"	=> array(
				"contents"		=>	"Contents of your temporary folder (newest first):",
				"warning"		=>	"These files will be available for###minutes or 
								while you keep your browser open (whichever is 
								the shorter) so download and save them elsewhere 
								immediately",
			),
// Administration of categories
		"category" => array(
				"addLabel"		=>	"Add a Category",
				"deleteLabel"		=>	"Delete Categories",
				"editLabel"		=>	"Edit Categories",
				"deleteConfirm"		=>	"Delete category(s)###",
				"deleteWarning"		=>	"Any resource belonging to the category(s) you are deleting 
								that does not belong to another category will be placed in 
								the 'General' category",
			),
// Form submit button text
		"submit" => array(
				"Submit"		=>	"Submit",
				"Add"			=>	"Add",
				"Delete"		=>	"Delete",
				"Confirm"		=>	"Confirm",
				"Edit"			=>	"Edit",
				"Proceed to Confirm"	=>	"Proceed to Confirm",
				"List"			=>	"List",
				"Proceed"		=>	"Proceed",
				"Search"		=>	"Search",
				"Select"		=>	"Select",
// Add citation 
				"Cite"			=>	"Cite",
// Reset button for forms
				"reset"			=>	"Reset",
			),
// Bibliography import messages
		"import" => array(
				"warning"		=>	"IT IS STRONGLY RECOMMENDED THAT YOU BACK UP YOUR 
								EXISTING DATABASE BEFORE PROCEEDING",
				"introBibtex"		=>	"You may import BibTeX bibliographies (.bib files) here. 
								Large files may take some time and may require the 
								WIKINDX admin to adjust file upload limits in php.ini 
								(alternatively, you may split large BibTeX files into 
								manageable chunks). See the help file for tips on 
								BibTeX import.",
				"introEndnote"		=>	"You may import Endnote XML bibliographies (.xml files) here. 
								Large files may take some time and may require the 
								WIKINDX admin to adjust file upload limits in php.ini 
								(alternatively, you may split large Endnote XML files into 
								manageable chunks).",
				"categoryPrompt"	=>	"All WIKINDX resources belong to at least one category 
								which you chose here.  The category(s) a resource belongs 
								to can always be edited later.",
				"category"		=>	"Category",
				"file"			=>	"Import File",
				"added"			=>	"No. resources added:###",
				"tag"			=>	"Tag this import",
// TRANSLATORS: do not translate '@string'
				"storeRawBibtex"	=>	"You may store BibTeX fields that WIKINDX does not use so that any resources later exported to BibTeX can include this original unchanged data.  Doing this, also stores any @string strings that are in the imported BibTeX file.",
				"storeRawEndnote"	=>	"You may store Endnote fields that WIKINDX does not use so that any resources later exported to Endnote can include this original unchanged data.",
				"storeRawLabel"		=>	"Store unused fields",
				"empty"		=>	"File is empty",
// For file imports, allow duplicates?
				"importDuplicates"	=>	"Import duplicates",
				"discarded"		=>	"No. resources discarded (duplicates):###",
// An ordinary user may cut 'n' paste bibtex entries into a textarea box for importing into the bibliography.
// '###' is the maximum number that the admin allows.
// Don't translate '@string'
				"pasteBibtex"		=>	"You may paste up to### bibTeX entries here in addition to @string types.",
			),
// Export RTF
		"exportRtf" => array(
				"bibliography"		=>	"Export bibliographic entries:",
				"fontSize"		=>	"Font size",
// Font type e.g. 'Times New Roman', 'Courier'
				"font"			=>	"Font",
				"abstract"		=>	"Export abstract:",
				"notes"			=>	"Export notes:",
				"quotes"		=>	"Export quotes:",
				"paraphrases"		=>	"Export paraphrases:",
				"musings"		=>	"Export musings:",
				"comments"		=>	"Export comments:",
// Number of indents (tabulation - TAB)
				"indentL"		=>	"Left indent",
				"indentR"		=>	"Right indent",
// 'CR' = carriage return (newlines)
				"crFollowing"		=>	"CR following",
				"crBetween"		=>	"CR between",
// bold, italics, underline
				"textFormat"		=>	"Text format",
// 'tag' = label given to each section (abstract, quotes, quote comments etc.)
				"tag"			=>	"Tag",
// Some text or characters to visually divide resources in the RT output
				"divider"		=>	"Divider between entries",
				"dividerCR"		=>	"CR after entries",
				"isbn"			=>	"Include ID no. (ISBN etc.)",
// Metadata export options
				"metadata"		=>	"If exporting quote and paraphrase comments or musings",
// These two are in a select box and follow on from the string above
				"metadataUser"	=>	"Export only mine",
				"metadataAll"	=>	"Export my data and all public data",
			),
// Users in a multi user WIKINDX
		"user" => array(
				"addLabel"		=>	"Add a User",
				"deleteLabel"		=>	"Delete Users",
				"editLabel"		=>	"Edit Users",
				"deleteConfirm"		=>	"Delete user(s)###",
				"username"		=>	"Username",
				"password"		=>	"Password",
				"fullname"		=>	"Full name",
				"admin"			=>	"Administrator",
				"email"			=>	"Email address",
// Do not use any TAB or CR in this one or the message formatting will be messed up in the email client.
				"emailText"		=>	"You recently registered to use our WIKINDX. If this was not you, please ignore this email.  Otherwise, to complete the registration process, please go to the following address and follow the instructions there:",
// Do not use any TAB or CR in this one or the message formatting will be messed up in the email client.
				"emailText2"		=>	"Thank you for registering to use our WIKINDX.  Please keep this email for reference:",
// Do not use any TAB or CR in this one or the message formatting will be messed up in the email client.
				"emailText3"		=>	"You recently updated your details on our WIKINDX.  Please keep this email for reference:",
// This user's bibliographies
				"bib"			=>	"My Bibliographies",
				"createBib"		=>	"Create a new bibliography",
				"deleteBib"		=>	"Delete bibliography",
				"editBib"		=>	"Edit bibliography details",
				"deleteFromBib"		=>	"Delete from bibliography",
				"noBibs"		=>	"You do not yet have any bibliographies",
				"bibTitle"		=>	"Title",
				"bibDescription"	=>	"Description",
				"deleteConfirmBib"	=>	"Delete bibliography###",
				"useBib"		=>	"Use this bibliography for browsing",
				"masterBib"		=>	"WIKINDX Master Bibliography",
				"bibliography"		=>	"Bibliography",
// displayed in select box - other users' bibliographies
				"otherBibs"		=>	"______OTHER USERS______",
				"displayBib"		=>	"Display bibliography details",
				"passwordConfirm"	=>	"Confirm password",
// For optional cookies
				"cookie"		=>	"Remember me",
// Email notification of resource additions/edits etc.
				"notification"		=>	"Email notification",
				"notifyNone"		=>	"Never",
				"notifyAll"		=>	"When any resource or its text is added/edited by other users",
				"notifyMy"		=>	"When any resource from my bibliographies or its text is added/edited by other users",
				"notifyAdd"		=>	"When a resource has been added",
				"notifyEdit"	=>	"When a resource or its text has been edited",
				"notify"		=>	"### has added or edited the following resource or its text",
// When a user has been deleted but her input remains, display this when viewing a resource and its associated text
				"unkown"		=>	"Deleted user",
			),
// Administering and display of news items
		"news" => array(
				"addNews"		=>	"Add news",
				"deleteNews"		=>	"Delete news",
				"deleteConfirm"		=>	"Delete news###",
				"editNews"		=>	"Edit news",
				"noNews"		=>	"There is no news available to view",
				"title"			=>	"Title",
				"body"			=>	"Main Text",
			),
// Messages for adding citations to quotes, notes, musings , comments etc. and for administration of 
// citation templates within bibliographic style creation/editing
		"cite" => array(
// The displayed hyperlink next to the textarea form input
				"cite"			=>	"Cite",
				"citationFormat"	=>	"Citation Formatting",
// In-text citation style as opposed to footnote style citations.
				"citationFormatInText"	=>	"In-text style",
				"citationFormatFootnote"	=>	"Footnote style",
				"creatorList"		=>	"Creator list abbreviation",
				"creatorListSubsequent"	=>	"Creator list abbreviation (subsequent appearances)",
				"creatorSep"		=>	"Creator delimiters",
				"creatorStyle" 		=>	"Creator style",
				"lastName"		=>	"Last name only",
// 'Last name only' is a choice in a select box and should not be translated
				"useInitials"		=>	"If 'Last name only', use initials to differentiate between creators with the same surname",
				"consecutiveCreator"	=>	"For consecutive citations by the same creator(s)",
				"omitCreator"		=>	"Omit creator list",
				"printCreator"		=>	"Print creator list",
// 'Omit creator list' is a choice in a select box and should not be translated as above
				"consecutiveCreatorSep"	=>	"If 'Omit creator list', separate citations with",
// The template is something like '(author|, year)' that the user is asked to enter
				"template"		=>	"Template",
				"consecutiveCitationSep" =>	"Separate consecutive citations with",
// Formatting of years
				"yearFormat"		=>	"Year format",
// Superscripting of citation
				"superscript"		=>	"Superscript",
// Ambiguous citations
				"ambiguous"		=>	"Ambiguous citations",
				"ambiguousFull"		=>	"Use the full name or initials",
				"ambiguousMore"		=>	"Add more creator names",
				"ambiguousTitle"	=>	"Add the title",
				"ambiguousYear"		=>	"Add a letter after the year",
				"ambiguousNameFormat"	=>	"Name format",
				"ambiguousYearFormat"	=>	"Year format",
// For footnote-style citations
				"footnoteStyleBib"	=>	"Format like bibliography",
				"footnoteStyleInText"	=>	"Format like in-text citations",
				"ibid"		=>	"Replace consecutive citations for the same resource and the same page with",
				"idem"		=>	"Replace consecutive citations for the same resource but a different page with",
				"opCit"		=>	"Replace previously cited resources with",
// Insert citation page number before or after footnote-style citation?
				"footnotePagePosition"	=>	"Position of citation page number",
				"footnotePageBefore"	=>	"Before citation",
				"footnotePageAfter"		=>	"After citation",
// For 'ibid' (by default does not display citation page numbers)
				"ibidPage"	=>	"Always display citation page number(s)",
// How to format the citation pages in footnote-style citations
				"footnoteCitationPageFormat" => "Format the citation page(s)",
				"footnoteCitationPageFormatNever" => "Never print citation page(s)",
				"footnoteCitationPageFormatBib"	=>	"Same as the bibliographic templates",
				"footnoteCitationPageFormatTemplate" => "Use the template below",
			),
// Administration of bibliographic styles
		"style" => array(
				"addLabel"		=>	"Add a Style",
				"copyLabel"		=>	"Copy a Style",
				"editLabel"		=>	"Edit Styles",
				"shortName"		=>	"Short Name",
				"longName"		=>	"Long Name",
				"primaryCreatorSep"	=>	"Primary creator delimiters",
				"otherCreatorSep"	=>	"Other creator delimiters",
				"ifOnlyTwoCreators"	=>	"If only two creators",
				"creatorSepBetween"	=>	"between",
				"creatorSepLast"	=>	"before last",
				"sepCreatorsFirst"	=>	"Between first two creators",
				"sepCreatorsNext"	=>	"Between following creators",
				"primaryCreatorStyle" 	=>	"Primary creator style",
				"otherCreatorStyle"	=>	"Other creator styles",
				"creatorFirstStyle" 	=>	"First",
				"creatorOthers"		=>	"Others",
				"creatorInitials"	=>	"Initials",
				"creatorFirstName"	=>	"First name",
				"creatorFirstNameFull"	=>	"Full",
				"creatorFirstNameInitials"	=>	"Initial",
				"primaryCreatorList"	=>	"Primary creator list abbreviation",
				"otherCreatorList"	=>	"Other creator list abbreviation",
				"creatorListFull"	=>	"Full list",
				"creatorListLimit"	=>	"Limit list",
// The next 3 surround form text boxes:
// "If xx or more creators, list the first xx and abbreviate with xx".  For example:
// "If 4 or more creators, list the first 1 and abbreviate with ,et. al"
				"creatorListIf"		=>	"If",
				"creatorListOrMore"		=>	"or more creators, list the first",
				"creatorListAbbreviation"	=>	"and abbreviate with",
				"titleCapitalization"	=>	"Title capitalization",
// Title as entered with no changes to capitalization
				"titleAsEntered"	=>	"As entered",
				"availableFields"	=>	"Available fields:",
				"editionFormat"		=>	"Edition format",
				"monthFormat"		=>	"Month format",
				"dateFormat"		=>	"Date format",
				"dayFormat"		=>	"Day format",
				"pageFormat"		=>	"Page format",
// Length of film, broadcast etc.
				"runningTimeFormat"	=>	"Running time format",
// When displaying a book that has no author but has an editor, do we put the editor in the position occupied 
// by the author?
				"editorSwitchHead"		=>	"Editor switch",
				"editorSwitch"		=>	"For books with no author but an editor, put editor in author position",
				"yes"			=>	"Yes",
				"no"			=>	"No",
				"editorSwitchIfYes"	=>	"If 'Yes', replace editor field in style definitions with",
// Uppercase creator names?
				"uppercaseCreator"	=>	"Uppercase all names",
// For repeated creator names in next bibliographic item
				"repeatCreators"	=>	"For works immediately following by the same creators",
				"repeatCreators1"	=>	"Print the creator list",
				"repeatCreators2"	=>	"Do not print the creator list",
				"repeatCreators3"	=>	"Replace creator list with text below",
// Fallback formatting style when a specific resource type has none defined
				"fallback"		=>	"Fallback style",
				"bibFormat"		=>	"Bibliography Formatting",
// Italic font
				"italics"		=>	"Italics",
// For user specific month naming
				"userMonthSelect"	=>	"Use month names defined below",
				"userMonths"	=>	"User-defined month names (all fields must be completed if selected above)",
// Date ranges for e.g. conferences
				"dateRange"		=>	"Date range",
				"dateRangeDelimit1"	=>	"Delimiter between start and end dates if day and month given",
				"dateRangeDelimit2"	=>	"Delimiter between start and end dates if month only given",
				"dateRangeSameMonth"	=>	"If start and end months are equal",
				"dateRangeSameMonth1"	=>	"Print both months",
				"dateRangeSameMonth2"	=>	"Print start month only",
			),
		"creators" => array(
				"author"	=>	"Authors",
				"editor"	=>	"Editors",
				"translator"	=>	"Translators",
				"reviser"	=>	"Revisers",
				"seriesEditor"	=>	"Series Editors",
// For films etc.
				"director"	=>	"Director",
				"producer"	=>	"Producer",
// For artwork
				"artist"	=>	"Artist",
				"performer"	=>	"Performer",
// For legal cases
				"counsel"	=>	"Counsel",
// For classical works of doubtful provenance
				"attributedTo"	=>	"Attributed to",
// Map makers
				"cartographer"	=>	"Cartographer",
// Charts/images
				"creator"	=>	"Creator",
// For patents
				"inventor"	=>	"Inventor",
				"issuingOrganisation"	=>	"Issuing Organisation",
				"agent"		=>	"Agent/Attorney",
// International patent author
				"intAuthor"	=>	"International Author",
// Personal Communication
				"recipient"	=>	"Recipient",
// For Musical works
				"composer"	=>	"Composer",
				"conductor"	=>	"Conductor",
// Advice on what to do when editing a creator name and the new name already exists in the database.
				"creatorExists"	=>	"If you proceed, this edited creator will be deleted and all references in the database to it will be replaced by references to the pre-existing creator.",
			),
// For adding custom database fields
		"custom" => array(
// The label given to the field
				"label"		=>	"Label",
// The field storage space can be small or large
				"size"		=>	"The database size allocation for the field can be small (max. 255 characters) or large",
				"small"		=>	"Small",
				"large"		=>	"Large",
				"warning"	=>	"Deleting these fields will also remove any resource data belonging to the field.",
				"addLabel"		=>	"Add a Field",
				"deleteLabel"		=>	"Delete Fields",
				"editLabel"		=>	"Edit Fields",
				"deleteConfirm"		=>	"Delete fields(s)###",
				"customFields"		=>	"Custom fields",
			),
// Power search
		"powerSearch" => array(
				"possibleFields"	=>	"Items this field may represent",
				"title"		=>	"Title",
				"type"		=>	"Resource type",
				"creator1"	=>	"Primary creator",
				"creator2"	=>	"Creator 2",
				"creator3"	=>	"Creator 3",
				"creator4"	=>	"Creator 4",
				"creator5"	=>	"Creator 5",
				"publisher"	=>	"Publisher",
				"conferenceOrganiser"	=>	"Conference organiser",
				"collectionTitle"	=>	"Collection",
				"collectionTitleShort"	=>	"Collection short title",
				"year1"		=>	"Publication year",
				"year2"		=>	"Year 2",
				"year3"		=>	"Year 3",
				"conferenceYear"	=>	"Conference year",
				"abstractYear"	=>	"Abstract publication year",
				"accessYear"	=>	"Access year",
				"categories"	=>	"Categories",
				"resourceKeywords"	=>	"Resource keywords",
				"url"		=>	"URL",
				"file"		=>	"Attached file",
				"isbn"		=>	"ID (ISBN etc.)",
				"notes"		=>	"Notes",
				"abstract"	=>	"Abstract",
				"quotes"	=>	"Quotes",
				"numQuotes"	=>	"Number of quotes",
				"quoteComments"	=>	"Quote comments",
				"quoteKeywords"	=>	"Quote keywords",
				"paraphrases"	=>	"Paraphrases",
				"numParaphrases"	=>	"Number of paraphrases",
				"paraphraseComments"	=>	"Paraphrase comments",
				"paraphraseKeywords"	=>	"Paraphrase keywords",
				"musings"	=>	"Musings",
				"numMusings"	=>	"Number of musings",
				"musingKeywords"	=>	"Musing keywords",
				"pageStart"	=>	"Page start",
				"pageEnd"	=>	"Page end",
				"addUserIdResource"	=>	"Resource added by",
				"editUserIdResource"	=>	"Resource last edited by",
				"addUserIdQuote"	=>	"Quote added by",
				"addUserIdParaphrase"	=>	"Paraphrase added by",
				"addUserIdMusing"	=>	"Musing added by",
				"addUserIdQuoteComment"	=>	"Quote comment added by",
				"addUserIdParaphraseComment"	=>	"Paraphrase comment added by",
				"timestamp"	=>	"Resource last updated",
// Miscellaneous database fieldsthat are not specifically named
				"field1"	=>	"Field 1",
				"field2"	=>	"Field 2",
				"field3"	=>	"Field 3",
				"field4"	=>	"Field 4",
				"field5"	=>	"Field 5",
				"field6"	=>	"Field 6",
				"field7"	=>	"Field 7",
				"field8"	=>	"Field 8",
				"field9"	=>	"Field 9",
				"miscField1"	=>	"Minutes",
				"miscField2"	=>	"Day",
				"miscField3"	=>	"Month",
				"miscField4"	=>	"Miscellaneous Field 4",
// For date ranges
				"miscField5"	=>	"End day",
				"miscField6"	=>	"End month",
// Custom database field added by admin
				"custom"	=>	"Custom field",
// Integer logic
				"equalTo"	=>	"Equal to",
				"greaterThan"	=>	"Greater than",
				"lessThan"	=>	"Less than",
				"lessThanOrEqualTo"	=>	"Less than or equal to",
				"greaterThanOrEqualTo"	=>	"Greater than or equal to",
// List display order
				"order1"	=>	"1st. sort by",
				"order2"	=>	"2nd. sort by",
				"order3"	=>	"3rd. sort by",
				"ascending"	=>	"Ascending",
				"descending"	=>	"Descending",
// ALT image text for javascript checkall and uncheckall form checkboxes
				"checkAll"	=>	"Check all",
				"uncheckAll"	=>	"Uncheck all",
			),
		);
	}
}
?>
